/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import java.util.HashMap;
import javax.media.opengl.GL;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.GLSLShadowMappingFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.effects.shadows.VolumeShadowFactory;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.ShadowMappingRenderPeer;
import org.xith3d.render.jsr231.VolumeShadowRenderPeer;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.View;

public class ShadowRenderPeer {
    private RenderPeerImpl renderPeer;
    private final HashMap<ShadowFactory.ShadowFactoryIdentifier, ShadowRenderPeerInterface> peerMap = new HashMap();

    public RenderPeerImpl getRenderPeer() {
        return this.renderPeer;
    }

    private static final ShadowFactory getShadowFactory() {
        EffectFactory effFact = EffectFactory.getInstance();
        if (effFact == null) {
            return null;
        }
        return effFact.getShadowFactory();
    }

    public final int initShadows(GL gl, View view, Light light, RenderBin shadowBin, long frameId) {
        ShadowFactory shadowFact = ShadowRenderPeer.getShadowFactory();
        if (shadowFact == null || !shadowFact.isEnabled()) {
            return 0;
        }
        ShadowRenderPeerInterface peer = this.peerMap.get(shadowFact.getShadowFactoryId());
        return peer.initShadows(gl, view, light, shadowBin, this.renderPeer, frameId);
    }

    public final int drawShadows(GL gl, View view, Light light, RenderBin shadowBin, long frameId) {
        ShadowFactory shadowFact = ShadowRenderPeer.getShadowFactory();
        if (shadowFact == null || !shadowFact.isEnabled()) {
            return 0;
        }
        ShadowRenderPeerInterface peer = this.peerMap.get(shadowFact.getShadowFactoryId());
        return peer.drawShadows(gl, view, light, shadowBin, this.renderPeer, frameId);
    }

    public ShadowRenderPeer(RenderPeerImpl renderPeer) {
        this.renderPeer = renderPeer;
        this.peerMap.put(VolumeShadowFactory.SHADOW_FACTORY_ID, new VolumeShadowRenderPeer());
        this.peerMap.put(GLSLShadowMappingFactory.SHADOW_FACTORY_ID, new ShadowMappingRenderPeer());
    }

    public static interface ShadowRenderPeerInterface {
        public int initShadows(GL var1, View var2, Light var3, RenderBin var4, RenderPeerImpl var5, long var6);

        public int drawShadows(GL var1, View var2, Light var3, RenderBin var4, RenderPeerImpl var5, long var6);
    }
}

