/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFragmentProgram;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.GL11;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShaderProgram;
import org.xith3d.scenegraph.AssemblyShaderProgramContext;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

public class AssemblyShaderProgramStateUnitPeer {
    private static final IntBuffer tmpIntBuffer = BufferUtils.createIntBuffer(16);
    private static SceneGraphOpenGLReferences.Provider shaderProgramNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    tmpIntBuffer.clear();
                    tmpIntBuffer.put(0, name);
                    ARBVertexProgram.glDeleteProgramsARB(tmpIntBuffer);
                }
            };
        }
    };
    private static boolean ARB_shader_programs_supported = false;
    private static boolean checkedOnce = false;

    private static final void checkOnce() {
        String extensions = GL11.glGetString(7939);
        if (extensions.indexOf("GL_ARB_vertex_program") != -1 && extensions.indexOf("GL_ARB_fragment_program") != -1) {
            ARB_shader_programs_supported = true;
        }
        checkedOnce = true;
        if (!ARB_shader_programs_supported) {
            // empty if block
        }
    }

    protected static final boolean areARBShaderProgramsSupported() {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce();
        }
        return ARB_shader_programs_supported;
    }

    private static final int defineVertexProgram(AssemblyVertexShader shaderProgram, SceneGraphOpenGLReference openGLRef) {
        tmpIntBuffer.clear();
        ARBVertexProgram.glGenProgramsARB(tmpIntBuffer);
        int spHandle = tmpIntBuffer.get(0);
        openGLRef.setName(spHandle);
        ARBVertexProgram.glBindProgramARB(34336, spHandle);
        String program = shaderProgram.getShaderCode();
        byte[] programBytes = program.getBytes();
        ByteBuffer programBuffer = BufferUtils.createByteBuffer(programBytes.length);
        programBuffer.put(programBytes).flip();
        ARBVertexProgram.glProgramStringARB(34336, 34933, programBuffer);
        String programErrorString = GL11.glGetString(34932);
        tmpIntBuffer.clear();
        GL11.glGetInteger(34379, tmpIntBuffer);
        if (tmpIntBuffer.get(0) != -1) {
            X3DLog.error("VP Error String:", programErrorString);
        }
        X3DLog.debug("Binding Shader Program to handle " + spHandle);
        return spHandle;
    }

    private static final int defineFragmentProgram(AssemblyFragmentShader shaderProgram, SceneGraphOpenGLReference openGLRef) {
        tmpIntBuffer.clear();
        ARBFragmentProgram.glGenProgramsARB(tmpIntBuffer);
        int spHandle = tmpIntBuffer.get(0);
        openGLRef.setName(spHandle);
        ARBFragmentProgram.glBindProgramARB(34820, spHandle);
        String program = shaderProgram.getShaderCode();
        byte[] programBytes = program.getBytes();
        ByteBuffer programBuffer = BufferUtils.createByteBuffer(programBytes.length);
        programBuffer.put(programBytes).flip();
        ARBFragmentProgram.glProgramStringARB(34820, 34933, programBuffer);
        String programErrorString = GL11.glGetString(34932);
        tmpIntBuffer.clear();
        GL11.glGetInteger(34379, tmpIntBuffer);
        if (tmpIntBuffer.get(0) != -1) {
            System.err.println("FP Error String:" + programErrorString);
        }
        X3DLog.debug("Binding Shader Program to handle ", spHandle);
        return spHandle;
    }

    private static final void bindVertexProgram(OpenGLStatesCache statesCache, AssemblyVertexShader shaderProgram, CanvasPeer canvasPeer) {
        int spHandle;
        SceneGraphOpenGLReference openGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        if (!statesCache.enabled || !statesCache.assemblyVertexShadersEnabled) {
            GL11.glEnable(34336);
            statesCache.assemblyVertexShadersEnabled = true;
        }
        if ((spHandle = openGLRef.getName()) != -1 && _SG_PrivilegedAccess.isDirty(shaderProgram)) {
            tmpIntBuffer.clear();
            tmpIntBuffer.put(0, spHandle);
            ARBVertexProgram.glDeleteProgramsARB(tmpIntBuffer);
            _SG_PrivilegedAccess.setDirty(shaderProgram, false);
            spHandle = openGLRef.deleteName();
        }
        if (spHandle != -1) {
            X3DLog.debug("Already cached, so binding Shader Program");
            ARBVertexProgram.glBindProgramARB(34336, spHandle);
        } else {
            spHandle = AssemblyShaderProgramStateUnitPeer.defineVertexProgram(shaderProgram, openGLRef);
        }
        Vector4f[] parameters = shaderProgram.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ARBVertexProgram.glProgramEnvParameter4fARB(34336, i, parameters[i].getX(), parameters[i].getY(), parameters[i].getZ(), parameters[i].getW());
            }
        }
    }

    private static final void bindFragmentProgram(OpenGLStatesCache statesCache, AssemblyFragmentShader shaderProgram, CanvasPeer canvasPeer) {
        int spHandle;
        SceneGraphOpenGLReference openGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        if (!statesCache.enabled || !statesCache.assemblyFragmentShadersEnabled) {
            GL11.glEnable(34820);
            statesCache.assemblyFragmentShadersEnabled = true;
        }
        if ((spHandle = openGLRef.getName()) != -1 && _SG_PrivilegedAccess.isDirty(shaderProgram)) {
            tmpIntBuffer.clear();
            tmpIntBuffer.put(0, spHandle);
            ARBFragmentProgram.glDeleteProgramsARB(tmpIntBuffer);
            _SG_PrivilegedAccess.setDirty(shaderProgram, false);
            spHandle = openGLRef.deleteName();
        }
        if (spHandle != -1) {
            X3DLog.debug("Already cached, so binding Shader Program");
            ARBFragmentProgram.glBindProgramARB(34820, spHandle);
        } else {
            spHandle = AssemblyShaderProgramStateUnitPeer.defineFragmentProgram(shaderProgram, openGLRef);
        }
        Vector4f[] parameters = shaderProgram.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ARBFragmentProgram.glProgramEnvParameter4fARB(34820, i, parameters[i].getX(), parameters[i].getY(), parameters[i].getZ(), parameters[i].getW());
            }
        }
    }

    private static final void setVertexProgramState(OpenGLStatesCache statesCache, AssemblyVertexShader shaderProgram, CanvasPeer canvasPeer) {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce();
        }
        if (ARB_shader_programs_supported) {
            if (shaderProgram == null || !shaderProgram.isEnabled() || shaderProgram.getShaderCode() == null) {
                if (!statesCache.enabled || statesCache.assemblyVertexShadersEnabled) {
                    GL11.glDisable(34336);
                    statesCache.assemblyVertexShadersEnabled = false;
                }
            } else {
                AssemblyShaderProgramStateUnitPeer.bindVertexProgram(statesCache, shaderProgram, canvasPeer);
            }
        }
    }

    private static final void setFragmentProgramState(OpenGLStatesCache statesCache, AssemblyFragmentShader shaderProgram, CanvasPeer canvasPeer) {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce();
        }
        if (ARB_shader_programs_supported) {
            if (shaderProgram == null || !shaderProgram.isEnabled() || shaderProgram.getShaderCode() == null) {
                if (!statesCache.enabled || statesCache.assemblyFragmentShadersEnabled) {
                    GL11.glDisable(34820);
                    statesCache.assemblyFragmentShadersEnabled = false;
                }
            } else {
                AssemblyShaderProgramStateUnitPeer.bindFragmentProgram(statesCache, shaderProgram, canvasPeer);
            }
        }
    }

    protected static final void disableAssemblyShaders(OpenGLStatesCache statesCache) {
        if (statesCache.enabled && !statesCache.assemblyVertexShadersEnabled && !statesCache.assemblyFragmentShadersEnabled) {
            return;
        }
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce();
        }
        if (ARB_shader_programs_supported) {
            GL11.glDisable(34336);
            GL11.glDisable(34820);
        }
        statesCache.assemblyVertexShadersEnabled = false;
        statesCache.assemblyFragmentShadersEnabled = false;
    }

    public static final void apply(AssemblyShaderProgramContext shaderProgram, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, RenderPeer.RenderMode renderMode) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "AssemblyShaderProgramStateUnitPeer::apply()");
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce();
        }
        if (renderMode == RenderPeer.RenderMode.NORMAL && shaderProgram.isEnabled()) {
            AssemblyShaderProgram program = (AssemblyShaderProgram)shaderProgram.getProgram();
            AssemblyVertexShader vertexProgram = null;
            if (program.getNumVertexShaders() > 0) {
                vertexProgram = (AssemblyVertexShader)program.getVertexShader(0);
            }
            AssemblyFragmentShader fragmentProgram = null;
            if (program.getNumFragmentShaders() > 0) {
                fragmentProgram = (AssemblyFragmentShader)program.getFragmentShader(0);
            }
            AssemblyShaderProgramStateUnitPeer.setVertexProgramState(statesCache, vertexProgram, canvasPeer);
            AssemblyShaderProgramStateUnitPeer.setFragmentProgramState(statesCache, fragmentProgram, canvasPeer);
        } else {
            AssemblyShaderProgramStateUnitPeer.disableAssemblyShaders(statesCache);
        }
        ProfileTimer.endProfile();
    }
}

