/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import javax.imageio.ImageIO;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.lwjgl.LWJGLCursorConverter;
import org.jagatoo.input.impl.mixed.LWJGLJInputInputDeviceFactory;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.util.image.ImageUtility;
import org.jagatoo.util.nio.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.PixelFormat;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplNative
extends CanvasPeerImplBase {
    private static final boolean NON_INTERACTIVE_MODE = false;
    private int left = 0;
    private int top = 0;
    private int width;
    private int height;
    private boolean displayModeChanged = false;
    private boolean isRendering = false;
    private static final long PROCESS_MESSAGE_TIME_INTERVAL = 100000000L;
    private long lastIsCloseRequestedQueryTime = 0L;
    private LWJGLJInputInputDeviceFactory inputDeviceFactory = null;

    @Override
    public LWJGLJInputInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new LWJGLJInputInputDeviceFactory(this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    @Override
    public final Object getDrawable() {
        return null;
    }

    @Override
    public void refreshCursor(Mouse mouse) {
        try {
            if (!org.lwjgl.input.Mouse.isCreated()) {
                org.lwjgl.input.Mouse.create();
            }
            if (this.getCursor() == null) {
                if (mouse.isAbsolute()) {
                    org.lwjgl.input.Mouse.setGrabbed(true);
                }
            } else if (mouse.isAbsolute()) {
                org.lwjgl.input.Mouse.setGrabbed(false);
            }
            if (this.getCursor() == org.jagatoo.input.render.Cursor.DEFAULT_CURSOR) {
                org.lwjgl.input.Mouse.setNativeCursor(null);
            } else if (this.getCursor() != null) {
                LWJGLCursorConverter.convertCursor(this.getCursor());
                org.lwjgl.input.Mouse.setNativeCursor((Cursor)this.getCursor().getCursorObject());
            }
        }
        catch (LWJGLException e) {
            throw new Error(e);
        }
    }

    @Override
    public final boolean receivesInputEvents() {
        return true;
    }

    public CanvasPeerImplNative(Object owner, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        try {
            if (this.isUndecorated()) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", String.valueOf(true));
            } else {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", String.valueOf(false));
            }
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        try {
            System.setProperty("org.xith3d.render.lwjgl.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        this.width = this.getDisplayMode().getWidth();
        this.height = this.getDisplayMode().getHeight();
        try {
            Display.setDisplayMode(this.getNativeDisplayMode());
            Display.setFullscreen(fullscreen.isFullscreen());
            Display.setTitle("Xith3D (LWJGL)");
            Display.setVSyncEnabled(vsync);
            Display.create(new PixelFormat(0, depthBufferSize, 8, fsaa.getIntValue()));
            if (!fullscreen.isFullscreen()) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
            }
            this.clear();
            this.beforeThreadChanged();
            this.init();
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Error(t.getMessage(), t);
        }
    }

    @Override
    protected final void init() throws Throwable {
        Display.makeCurrent();
        super.init();
        Display.releaseContext();
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.LWJGL;
    }

    @Override
    protected void applyVSync() {
        Display.setVSyncEnabled(this.isVSyncEnabled());
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.vsyncSwitched = true;
    }

    @Override
    public final Object getWindow() {
        return null;
    }

    @Override
    public final Object getComponent() {
        return null;
    }

    private static ByteBuffer[] createIcon(URL url) throws IOException {
        ByteBuffer[] bbs;
        BufferedImage srcImg = ImageIO.read(url);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") >= 0) {
            SharedBufferedImage trgImg0 = SharedBufferedImage.create(16, 16, 4, true, new int[]{0, 1, 2, 3}, null);
            ImageUtility.scaleImage(srcImg, trgImg0);
            ByteBuffer bb0 = BufferUtils.createByteBuffer(trgImg0.getWidth() * trgImg0.getHeight() * 4);
            bb0.put(trgImg0.getSharedData());
            bb0.flip();
            SharedBufferedImage trgImg1 = SharedBufferedImage.create(32, 32, 4, true, new int[]{0, 1, 2, 3}, null);
            ImageUtility.scaleImage(srcImg, trgImg1);
            ByteBuffer bb1 = BufferUtils.createByteBuffer(trgImg1.getWidth() * trgImg1.getHeight() * 4);
            bb1.put(trgImg1.getSharedData());
            bb1.flip();
            bbs = new ByteBuffer[]{bb0, bb1};
        } else if (osName.indexOf("mac") >= 0) {
            SharedBufferedImage trgImg0 = SharedBufferedImage.create(128, 128, 4, true, new int[]{0, 1, 2, 3}, null);
            ImageUtility.scaleImage(srcImg, trgImg0);
            ByteBuffer bb0 = BufferUtils.createByteBuffer(trgImg0.getWidth() * trgImg0.getHeight() * 4);
            bb0.put(trgImg0.getSharedData());
            bb0.flip();
            bbs = new ByteBuffer[]{bb0};
        } else {
            SharedBufferedImage trgImg0 = SharedBufferedImage.create(32, 32, 4, true, new int[]{0, 1, 2, 3}, null);
            ImageUtility.scaleImage(srcImg, trgImg0);
            ByteBuffer bb0 = BufferUtils.createByteBuffer(trgImg0.getWidth() * trgImg0.getHeight() * 4);
            bb0.put(trgImg0.getSharedData());
            bb0.flip();
            bbs = new ByteBuffer[]{bb0};
        }
        return bbs;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        Display.setIcon(CanvasPeerImplNative.createIcon(iconResource));
    }

    @Override
    public final void setTitle(String title) {
        Display.setTitle(title);
    }

    @Override
    public final String getTitle() {
        return Display.getTitle();
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.left == x && this.top == y) {
            return false;
        }
        Display.setLocation(x, y);
        this.left = x;
        this.top = y;
        return true;
    }

    @Override
    public final int getLeft() {
        return this.left;
    }

    @Override
    public final int getTop() {
        return this.top;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (width == this.width && height == this.height) {
            return false;
        }
        DisplayMode displayMode = DisplayModeSelector.getImplementation(OpenGLLayer.LWJGL).getBestMode(width, height, this.getBPP(), this.getFrequency());
        if (displayMode == null) {
            return false;
        }
        this.setDisplayModeRef(displayMode);
        this.displayModeChanged = true;
        this.width = this.getDisplayMode().getWidth();
        this.height = this.getDisplayMode().getHeight();
        return true;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.displayModeChanged = true;
        this.width = displayMode.getWidth();
        this.height = displayMode.getHeight();
        return true;
    }

    @Override
    public void setGamma(float gamma, float brightness, float contrast) {
        super.setGamma(gamma, brightness, contrast);
        try {
            Display.setDisplayConfiguration(gamma, brightness, contrast);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    @Override
    protected Thread makeCurrent() {
        try {
            Display.makeCurrent();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return Thread.currentThread();
    }

    @Override
    public void beforeThreadChanged() {
        if (this.renderingThread != null || this.getRenderedFrames() == 0L) {
            try {
                Display.releaseContext();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.renderingThread = null;
        }
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        boolean pmTimeHit;
        if (!this.isInitialized()) {
            return null;
        }
        if (this.getFullscreenSwitchRequest() != null) {
            try {
                boolean newFSMode = this.getFullscreenSwitchRequest();
                Display.setFullscreen(newFSMode);
                if (newFSMode) {
                    this.left = 0;
                    this.top = 0;
                } else {
                    this.left = Display.getDisplayMode().getWidth() / 2;
                    this.top = 0;
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Display.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
                }
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            this.resetFullscreenSwitchRequest();
        }
        if (this.displayModeChanged) {
            try {
                int currentCenterX = this.left + Display.getDisplayMode().getWidth() / 2;
                int currentCenterY = this.top + Display.getDisplayMode().getHeight() / 2;
                Display.setDisplayMode(this.getNativeDisplayMode());
                if (!this.isFullscreen()) {
                    this.left = currentCenterX - this.getNativeDisplayMode().getWidth() / 2;
                    this.top = currentCenterY - this.getNativeDisplayMode().getHeight() / 2;
                    Display.setLocation(this.left, this.top);
                }
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            this.displayModeChanged = false;
        }
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "CanvasPeerImpl::render");
        boolean bl = pmTimeHit = nanoTime - this.lastIsCloseRequestedQueryTime >= 100000000L;
        if (this.isClosingListenerRegistered() && pmTimeHit && Display.isCloseRequested()) {
            this.fireClosingEvent();
        }
        this.isRendering = true;
        Object result = this.doRender(view, renderPasses, layeredMode, frameId, nanoTime, nanoStep, pickRequest);
        this.isRendering = false;
        if (frameId % 100L == 0L || pmTimeHit) {
            Display.processMessages();
        }
        if (pmTimeHit) {
            this.lastIsCloseRequestedQueryTime = nanoTime;
        }
        try {
            Display.swapBuffers();
        }
        catch (LWJGLException e) {
            X3DLog.print(e);
            e.printStackTrace();
        }
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            Display.releaseContext();
            Display.makeCurrent();
            if (Display.isCreated() && Display.isActive()) {
                Display.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

