/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord1f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.TexCoord4f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GeometryStripArray;
import org.xith3d.scenegraph.IndexedGeometryArray;
import org.xith3d.scenegraph.IndexedGeometryStripArray;

public class DisplayListRenderPeer {
    private static final boolean USE_PRECOMPILED_DISPLAY_LISTS = true;
    private static final SceneGraphOpenGLReferences.Provider dlNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL11.glDeleteLists(name, 1);
                }
            };
        }
    };
    private static Point3f coord = new Point3f();
    private static Vector3f normal = new Vector3f();
    private static Colorf color = new Colorf();
    private static TexCoord1f texCoord1 = new TexCoord1f();
    private static TexCoord2f texCoord2 = new TexCoord2f();
    private static TexCoord3f texCoord3 = new TexCoord3f();
    private static TexCoord4f texCoord4 = new TexCoord4f();

    private static final void drawGeometryArray(Geometry geom, int[] index, int startIndex, int endIndex, int mode, boolean isMinVersion13) {
        GL11.glBegin(mode);
        for (int i = startIndex; i <= endIndex; ++i) {
            int i_;
            int n = i_ = index == null ? i : index[i];
            if (geom.hasNormals()) {
                geom.getNormal(i_, normal);
                GL11.glNormal3f(normal.getX(), normal.getY(), normal.getZ());
            }
            if (geom.hasColors()) {
                geom.getColor(i_, color);
                if (color.hasAlpha()) {
                    GL11.glColor4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                } else {
                    GL11.glColor3f(color.getRed(), color.getGreen(), color.getBlue());
                }
            }
            int[] tuSetMap = geom.getTexCoordSetMap();
            block7: for (int t = 0; t < tuSetMap.length; ++t) {
                int unit = tuSetMap[t];
                switch (geom.getTexCoordSize(unit)) {
                    case 1: {
                        geom.getTextureCoordinate(unit, i_, texCoord1);
                        if (isMinVersion13) {
                            GL13.glMultiTexCoord1f(unit, texCoord1.getS());
                            continue block7;
                        }
                        ARBMultitexture.glMultiTexCoord1fARB(unit, texCoord1.getS());
                        continue block7;
                    }
                    case 2: {
                        geom.getTextureCoordinate(unit, i_, texCoord2);
                        if (isMinVersion13) {
                            GL13.glMultiTexCoord2f(unit, texCoord2.getS(), texCoord2.getT());
                            continue block7;
                        }
                        ARBMultitexture.glMultiTexCoord2fARB(unit, texCoord2.getS(), texCoord2.getT());
                        continue block7;
                    }
                    case 3: {
                        geom.getTextureCoordinate(unit, i_, texCoord3);
                        if (isMinVersion13) {
                            GL13.glMultiTexCoord3f(unit, texCoord3.getS(), texCoord3.getT(), texCoord3.getP());
                            continue block7;
                        }
                        ARBMultitexture.glMultiTexCoord3fARB(unit, texCoord3.getS(), texCoord3.getT(), texCoord3.getP());
                        continue block7;
                    }
                    case 4: {
                        geom.getTextureCoordinate(unit, i_, texCoord4);
                        if (isMinVersion13) {
                            GL13.glMultiTexCoord4f(unit, texCoord4.getS(), texCoord4.getT(), texCoord4.getP(), texCoord4.getQ());
                            continue block7;
                        }
                        ARBMultitexture.glMultiTexCoord4fARB(unit, texCoord4.getS(), texCoord4.getT(), texCoord4.getP(), texCoord4.getQ());
                    }
                }
            }
            geom.getCoordinate(i_, coord);
            GL11.glVertex3f(coord.getX(), coord.getY(), coord.getZ());
        }
        GL11.glEnd();
    }

    public static final void drawRegularGeometryArray(Geometry geom, int mode, boolean isMinVersion13) {
        int[] index = null;
        int startIndex = geom.getInitialVertexIndex();
        int numIndices = geom.getValidVertexCount();
        DisplayListRenderPeer.drawGeometryArray(geom, index, startIndex, startIndex + numIndices - 1, mode, isMinVersion13);
    }

    public static final void drawIndexedGeometryArray(IndexedGeometryArray geom, int mode, boolean isMinVersion13) {
        int[] index = geom.getIndex();
        int startIndex = geom.getInitialIndexIndex();
        int numIndices = geom.getValidIndexCount();
        DisplayListRenderPeer.drawGeometryArray(geom, index, startIndex, startIndex + numIndices - 1, mode, isMinVersion13);
    }

    public static final void drawGeometryStripArray(GeometryStripArray geom, int mode, int stripsCount, int[] stripVertexCounts, boolean isMinVersion13) {
        int startIndex = geom.getInitialVertexIndex();
        int numIndices = geom.getValidVertexCount();
        int i0 = 0;
        for (int strip = 0; strip < stripsCount; ++strip) {
            int start = i0 >= startIndex ? i0 : startIndex;
            int end = start + stripVertexCounts[strip] - 1;
            if (end + 1 > numIndices) {
                end = numIndices - 1;
            }
            if (end < start) break;
            DisplayListRenderPeer.drawGeometryArray(geom, null, start, end, mode, isMinVersion13);
            i0 += stripVertexCounts[strip];
        }
    }

    public static final void drawIndexedGeometryStripArray(IndexedGeometryStripArray geom, int mode, int stripsCount, int[] stripVertexCounts, boolean isMinVersion13) {
        int[] index = geom.getIndex();
        int startIndex = geom.getInitialIndexIndex();
        int numIndices = geom.getValidIndexCount();
        int i0 = 0;
        for (int strip = 0; strip < stripsCount; ++strip) {
            int start = i0 >= startIndex ? i0 : startIndex;
            int end = start + stripVertexCounts[strip] - 1;
            if (end + 1 > numIndices) {
                end = numIndices - 1;
            }
            if (end < start) break;
            DisplayListRenderPeer.drawGeometryArray(geom, index, start, end, mode, isMinVersion13);
            i0 += stripVertexCounts[strip];
        }
    }

    private static final int recordDisplayList(ShapeAtom atom, Geometry geom, int dlName, boolean useVertexArrayWorkaround, int texturesUseMap, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache) {
        if (dlName == -1) {
            dlName = GL11.glGenLists(1);
        }
        GL11.glNewList(dlName, 4864);
        if (useVertexArrayWorkaround) {
            ShapeAtomPeer.renderWithForcedVertexArrays(atom, texturesUseMap, geom, canvasPeer, glCaps, statesCache);
        } else {
            atom.lastComputedPolysCount = ShapeAtomPeer.drawBuffers(geom, false, true, glCaps.isMinVersion13());
        }
        GL11.glEndList();
        return dlName;
    }

    private static final void playbackDisplayList(int dlName) {
        GL11.glCallList(dlName);
    }

    public static final void renderDisplayList(ShapeAtom atom, Geometry geom, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, boolean isNormalRenderMode) {
        SceneGraphOpenGLReference openGLRef = geom.getOpenGLReference_DL().getReference(canvasPeer, dlNameProvider);
        boolean useVertexArrayWorkaround = !glCaps.supportsPlainMultiTexturing() || geom.hasVertexAttributes();
        int texturesUseMap = 0;
        if (useVertexArrayWorkaround) {
            texturesUseMap = ShapeAtomPeer.setStates(geom, glCaps, statesCache, isNormalRenderMode, 63);
        }
        if (!openGLRef.nameExists()) {
            openGLRef.setName(DisplayListRenderPeer.recordDisplayList(atom, geom, -1, useVertexArrayWorkaround, texturesUseMap, canvasPeer, glCaps, statesCache));
        } else if (!openGLRef.isNameValid()) {
            int dlName = openGLRef.getName();
            DisplayListRenderPeer.recordDisplayList(atom, geom, dlName, useVertexArrayWorkaround, texturesUseMap, canvasPeer, glCaps, statesCache);
            openGLRef.setName(dlName);
            DisplayListRenderPeer.playbackDisplayList(dlName);
        } else {
            int dlName = openGLRef.getName();
            DisplayListRenderPeer.playbackDisplayList(dlName);
        }
    }
}

