/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.FogStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.ExponentialFog;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.LinearFog;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FogStateUnitPeer
implements StateUnitPeer {
    private FloatBuffer float4 = BufferUtils.createFloatBuffer(4);

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "FogStateUnitPeer::apply()");
        FogStateUnit fsu = (FogStateUnit)stateUnit;
        if (fsu.numFogs() == 0) {
            if (!statesCache.enabled || statesCache.fogEnabled) {
                GL11.glDisable(2912);
                statesCache.fogEnabled = false;
            }
            ProfileTimer.endProfile();
            return;
        }
        for (int i = 0; i < fsu.numFogs(); ++i) {
            Fog fog = fsu.getFog(i);
            Colorf color = fog.getColor();
            this.float4.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(1.0f).position(0);
            if (fog instanceof LinearFog) {
                LinearFog linearFog = (LinearFog)fog;
                GL11.glFogi(2917, 9729);
                GL11.glFog(2918, this.float4);
                GL11.glHint(3156, 4354);
                GL11.glFogf(2915, linearFog.getFrontDistance());
                GL11.glFogf(2916, linearFog.getBackDistance());
                if (statesCache.enabled && statesCache.fogEnabled) continue;
                GL11.glEnable(2912);
                statesCache.fogEnabled = true;
                continue;
            }
            if (!(fog instanceof ExponentialFog)) continue;
            ExponentialFog expFog = (ExponentialFog)fog;
            switch (expFog.getFogMode()) {
                case EXP: {
                    GL11.glFogi(2917, 2048);
                    break;
                }
                case EXP2: {
                    GL11.glFogi(2917, 2049);
                    break;
                }
                default: {
                    throw new Error("Unknown/Unsupported FogMode");
                }
            }
            GL11.glFog(2918, this.float4);
            GL11.glFogf(2914, expFog.getDensity());
            GL11.glHint(3156, 4354);
            if (statesCache.enabled && statesCache.fogEnabled) continue;
            GL11.glEnable(2912);
            statesCache.fogEnabled = true;
        }
        ProfileTimer.endProfile();
    }
}

