/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.LightingStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightingStateUnitPeer
implements StateUnitPeer {
    private final FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(4);
    private static final FloatBuffer blackColorBuffer = BufferUtils.createFloatBuffer(4);
    private final Point3f tmpPoint = new Point3f();
    private final Vector3f tmpVector = new Vector3f();

    public static final int getGlLight(int lightIndex) {
        switch (lightIndex) {
            case 0: {
                return 16384;
            }
            case 1: {
                return 16385;
            }
            case 2: {
                return 16386;
            }
            case 3: {
                return 16387;
            }
            case 4: {
                return 16388;
            }
            case 5: {
                return 16389;
            }
            case 6: {
                return 16390;
            }
            case 7: {
                return 16391;
            }
        }
        throw new Error("Invalid Light");
    }

    private final boolean shadeLight(OpenGLStatesCache statesCache, Light light, Transform3D transform, int lightIndex) {
        if (light == null || !light.isEnabled() || lightIndex > 7) {
            return false;
        }
        if (light instanceof AmbientLight) {
            AmbientLight aLight = (AmbientLight)light;
            Colorf color = aLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(1.0f);
            this.floatBuffer.rewind();
            GL11.glLightModel(2899, this.floatBuffer);
            return false;
        }
        if (light instanceof DirectionalLight) {
            DirectionalLight dLight = (DirectionalLight)light;
            int glLight = LightingStateUnitPeer.getGlLight(lightIndex);
            Colorf color = dLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(1.0f);
            this.floatBuffer.rewind();
            GL11.glLight(glLight, 4609, this.floatBuffer);
            GL11.glLight(glLight, 4610, this.floatBuffer);
            if (transform == null) {
                this.tmpVector.set((TupleNf)dLight.getDirection());
            } else {
                transform.getMatrix4f().transform(dLight.getDirection(), this.tmpVector);
            }
            this.floatBuffer.clear();
            this.floatBuffer.put(-this.tmpVector.getX()).put(-this.tmpVector.getY()).put(-this.tmpVector.getZ()).put(0.0f);
            this.floatBuffer.rewind();
            GL11.glLight(glLight, 4611, this.floatBuffer);
            GL11.glLight(glLight, 4608, blackColorBuffer);
            GL11.glLightf(glLight, 4613, 0.0f);
            GL11.glLightf(glLight, 4614, 180.0f);
            if (!statesCache.enabled || !statesCache.lightEnabled[lightIndex]) {
                GL11.glEnable(glLight);
                statesCache.lightEnabled[lightIndex] = true;
            }
        } else if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            int glLight = LightingStateUnitPeer.getGlLight(lightIndex);
            Colorf color = pLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).put(1.0f);
            this.floatBuffer.rewind();
            GL11.glLight(glLight, 4609, this.floatBuffer);
            GL11.glLight(glLight, 4610, this.floatBuffer);
            GL11.glLight(glLight, 4608, blackColorBuffer);
            if (transform == null) {
                this.tmpPoint.set((TupleNf)pLight.getLocation());
            } else {
                transform.transform(pLight.getLocation(), this.tmpPoint);
            }
            this.floatBuffer.clear();
            this.floatBuffer.put(this.tmpPoint.getX()).put(this.tmpPoint.getY()).put(this.tmpPoint.getZ() + 1.0E-5f).put(1.0f);
            this.floatBuffer.rewind();
            GL11.glLight(glLight, 4611, this.floatBuffer);
            Tuple3f att = pLight.getAttenuation();
            GL11.glLightf(glLight, 4615, att.getX());
            GL11.glLightf(glLight, 4616, att.getY());
            GL11.glLightf(glLight, 4617, att.getZ());
            if (light instanceof SpotLight) {
                SpotLight sLight = (SpotLight)pLight;
                GL11.glLightf(glLight, 4613, sLight.getConcentration());
                GL11.glLightf(glLight, 4614, sLight.getSpreadAngleDeg());
                if (transform == null) {
                    this.tmpVector.set((TupleNf)sLight.getDirection());
                } else {
                    transform.getMatrix4f().transform(sLight.getDirection(), this.tmpVector);
                }
                this.floatBuffer.clear();
                this.floatBuffer.put(this.tmpVector.getX()).put(this.tmpVector.getY()).put(this.tmpVector.getZ());
                this.floatBuffer.rewind();
                GL11.glLight(glLight, 4612, this.floatBuffer);
            } else {
                GL11.glLightf(glLight, 4613, 0.0f);
                GL11.glLightf(glLight, 4614, 180.0f);
            }
            if (!statesCache.enabled || !statesCache.lightEnabled[lightIndex]) {
                GL11.glEnable(glLight);
                statesCache.lightEnabled[lightIndex] = true;
            }
        }
        return true;
    }

    private static final Transform3D getTrackedNodeTransform(Light light) {
        DirectionalLight dLight;
        if (light == null || !light.isEnabled()) {
            return null;
        }
        if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            if (pLight.getTrackedNode() != null) {
                return pLight.getTrackedNode().getWorldTransform();
            }
        } else if (light instanceof DirectionalLight && (dLight = (DirectionalLight)light).getTrackedNode() != null) {
            return dLight.getTrackedNode().getWorldTransform();
        }
        return null;
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        int i;
        boolean hasLights;
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "LightingStateUnitPeer::apply()");
        LightingStateUnit lsu = (LightingStateUnit)stateUnit;
        int lightIndex = 0;
        boolean bl = hasLights = lsu.numLights() > 0 || view.getAttachedLight() != null;
        if (renderMode == RenderPeer.RenderMode.NORMAL && hasLights) {
            GL11.glPushMatrix();
            GL11.glLoadMatrix(_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(false), true));
            for (i = 0; i < lsu.numLights(); ++i) {
                Light light = lsu.getLight(i);
                if (!this.shadeLight(statesCache, light, LightingStateUnitPeer.getTrackedNodeTransform(light), lightIndex)) continue;
                ++lightIndex;
            }
            if (this.shadeLight(statesCache, view.getAttachedLight(), view.getTransform(), lightIndex)) {
                ++lightIndex;
            }
        }
        for (i = lightIndex; i <= 7; ++i) {
            if (statesCache.enabled && !statesCache.lightEnabled[i]) continue;
            GL11.glDisable(LightingStateUnitPeer.getGlLight(i));
            statesCache.lightEnabled[i] = false;
        }
        if (renderMode == RenderPeer.RenderMode.NORMAL && hasLights) {
            GL11.glPopMatrix();
        }
        ProfileTimer.endProfile();
    }

    static {
        blackColorBuffer.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
        blackColorBuffer.rewind();
    }
}

