/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.VolumeShadowFactory;
import org.xith3d.effects.shadows.occluder.Occluder;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.ShadowRenderPeer;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

public class VolumeShadowRenderPeer
implements ShadowRenderPeer.ShadowRenderPeerInterface {
    private final FloatBuffer floatBuffer4x4 = BufferUtils.createFloatBuffer(16);
    private float[] trans = new float[16];

    public final int initShadows(View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        return 0;
    }

    private final int drawObjectShadow(OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, Occluder occluder) {
        occluder.getWorldTransform().getColumnMajor(this.trans);
        this.floatBuffer4x4.clear();
        this.floatBuffer4x4.put(this.trans).flip();
        this.floatBuffer4x4.rewind();
        GL11.glLoadMatrix(this.floatBuffer4x4);
        if (!statesCache.enabled || statesCache.normalsArrayEnabled) {
            GL11.glDisableClientState(32885);
            statesCache.normalsArrayEnabled = false;
        }
        if (!statesCache.enabled || statesCache.colorsArrayEnabled) {
            GL11.glDisableClientState(32886);
            statesCache.colorsArrayEnabled = false;
        }
        for (int i = 0; i < glCaps.getMaxTextureUnits(); ++i) {
            int tuMaskValue = FastMath.pow(2, i);
            if (statesCache.enabled && (statesCache.texCoordArraysEnableMask & tuMaskValue) == 0) continue;
            ShapeAtomPeer.selectClientTextureUnit(i, statesCache, false);
            GL11.glDisableClientState(32888);
            statesCache.texCoordArraysEnableMask &= ~tuMaskValue;
        }
        if (!statesCache.enabled || !statesCache.coordsArrayEnabled) {
            GL11.glEnableClientState(32884);
            statesCache.coordsArrayEnabled = true;
        }
        GL11.glVertexPointer(3, 0, occluder.getBuffer().getCoordinatesData().getBuffer());
        GL11.glDrawArrays(4, 0, occluder.getBuffer().getValidVertexCount());
        return occluder.getBuffer().getValidVertexCount() / 3;
    }

    public final int drawShadows(View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        Occluder occluder;
        Node node2;
        int i;
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        OpenGLCapabilities glCaps = renderPeer.getCanvasPeer().getOpenGLCapabilities();
        VolumeShadowFactory shadowFactory = (VolumeShadowFactory)EffectFactory.getInstance().getShadowFactory();
        Point3f lightSourcePos = shadowFactory.getLightSourcePosition();
        int numTriangles = 0;
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "ShadowShaderPeer::drawShadows");
        int FULLMASK = -1;
        int STENCIL_VAL = 128;
        RenderBin bin = shadowBin;
        for (i = 0; i < bin.size(); ++i) {
            node2 = bin.getAtom(i).getNode();
            occluder = (Occluder)node2.getShadowAttachment();
            occluder.determineVisibleEdges(lightSourcePos);
        }
        GL11.glPushAttrib(25864);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable(2896);
        statesCache.lightingEnabled = false;
        GL11.glDisable(3553);
        statesCache.texture2DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable(32879);
        statesCache.texture3DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable(3042);
        statesCache.blendingEnabled = false;
        GL11.glStencilFunc(512, 255, -1);
        GL11.glDepthMask(true);
        GL11.glDepthFunc(515);
        GL11.glEnable(2929);
        statesCache.depthTestEnabled = true;
        GL11.glPopMatrix();
        GL11.glColor3f(1.0f, 0.0f, 0.0f);
        GL11.glClearStencil(128);
        GL11.glClear(1024);
        GL11.glDisable(2896);
        statesCache.lightingEnabled = false;
        GL11.glFrontFace(2305);
        GL11.glEnable(2884);
        statesCache.cullFaceEnabled = true;
        GL11.glCullFace(1028);
        GL11.glDepthMask(false);
        GL11.glDepthFunc(515);
        GL11.glEnable(2960);
        statesCache.stencilTestEnabled = true;
        GL11.glColorMask(false, false, false, false);
        GL11.glStencilFunc(519, 128, -1);
        GL11.glStencilOp(7680, 7680, 7682);
        for (i = 0; i < bin.size(); ++i) {
            node2 = bin.getAtom(i).getNode();
            occluder = (Occluder)node2.getShadowAttachment();
            numTriangles += this.drawObjectShadow(statesCache, glCaps, occluder);
        }
        GL11.glCullFace(1029);
        GL11.glStencilOp(7680, 7680, 7683);
        GL11.glColor3f(0.5f, 0.5f, 0.0f);
        for (i = 0; i < bin.size(); ++i) {
            node2 = bin.getAtom(i).getNode();
            occluder = (Occluder)node2.getShadowAttachment();
            this.drawObjectShadow(statesCache, glCaps, occluder);
        }
        GL11.glColorMask((statesCache.colorWriteMask & 1) != 0, (statesCache.colorWriteMask & 2) != 0, (statesCache.colorWriteMask & 4) != 0, (statesCache.colorWriteMask & 8) != 0);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.4f);
        GL11.glEnable(3042);
        statesCache.blendingEnabled = true;
        GL11.glBlendFunc(770, 771);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        view.getProjection().getColumnMajor(this.trans);
        this.floatBuffer4x4.clear();
        this.floatBuffer4x4.put(this.trans).flip();
        this.floatBuffer4x4.rewind();
        GL11.glLoadMatrix(this.floatBuffer4x4);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDepthMask(false);
        GL11.glStencilFunc(517, 128, -1);
        GL11.glStencilOp(7680, 7680, 7680);
        GL11.glCullFace(1029);
        GL11.glDisable(2884);
        statesCache.cullFaceEnabled = false;
        GL11.glAlphaFunc(519, 0.0f);
        GL11.glBegin(5);
        GL11.glVertex3f(-100.0f, 100.0f, -2.0f);
        GL11.glVertex3f(-100.0f, -1000.0f, -2.0f);
        GL11.glVertex3f(100.0f, 100.0f, -2.0f);
        GL11.glVertex3f(100.0f, -1000.0f, -2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        ProfileTimer.endProfile();
        return numTriangles;
    }
}

