/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import java.util.BitSet;
import java.util.List;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRay;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.RenderPass;
import org.xith3d.render.preprocessing.BoundsAtom;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.render.preprocessing.ShadowAtom;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.scenegraph.AbstractLODShape3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.LODSwitch;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.SpecialCullingNode;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.UpdatableNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrustumCuller {
    private ShadowFactory shadowFactory;
    private int unculledShapesCount = 0;
    private final Point3f viewPosition2 = new Point3f();

    private final void cullSwitchAtoms(Switch sw, Classifier.Classification parentClassify, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass) {
        if (sw instanceof LODSwitch) {
            ((LODSwitch)sw).updateWhichChild(viewPosition);
        }
        int childIdx = sw.getWhichChild();
        switch (childIdx) {
            case -3: {
                BitSet bs = sw.getChildMask();
                int numChildren = sw.numChildren();
                int i = bs.nextSetBit(0);
                while (i >= 0 && i < numChildren) {
                    this.cullNodeAtoms(sw.getChild(i), parentClassify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
                    i = bs.nextSetBit(i + 1);
                }
                break;
            }
            case -2: {
                int numChildren = sw.numChildren();
                for (int i = 0; i < numChildren; ++i) {
                    this.cullNodeAtoms(sw.getChild(i), parentClassify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
                }
                break;
            }
            case -1: {
                break;
            }
            default: {
                Node n = sw.getChild(childIdx);
                this.cullNodeAtoms(n, parentClassify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
                break;
            }
        }
    }

    private final void cullGroupAtoms(GroupNode group, Classifier.Classification parentClassify, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass) {
        int numChildren = group.numChildren();
        for (int i = 0; i < numChildren; ++i) {
            this.cullNodeAtoms(group.getChild(i), parentClassify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
        }
    }

    private final void handleGroupShadow(GroupNode group, Classifier.Classification classify, RenderBinProvider binProvider, long frameId, boolean isShadowPass) {
        ShadowAtom shadowAtom;
        boolean b;
        boolean bl = b = this.shadowFactory.needsPerLightCulling() && isShadowPass || !this.shadowFactory.needsPerLightCulling() && !isShadowPass;
        if (this.shadowFactory != null && b && group.isOccluder() && (shadowAtom = this.shadowFactory.getShadowAtom(group)) != null) {
            shadowAtom.updateLightsAndFogs();
            binProvider.addShadowAtom(shadowAtom, classify, frameId);
            return;
        }
    }

    private void addShapeAtom(Shape3D shape, Classifier.Classification classify, Point3f viewPosition, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, PickRay pickRay, boolean isShadowPass) {
        ShapeAtom atom = _SG_PrivilegedAccess.getAtom(shape);
        if (atom == null) {
            atom = new ShapeAtom(shape, glCaps);
            _SG_PrivilegedAccess.setAtom(shape, atom);
        }
        if (shape instanceof AbstractLODShape3D) {
            ((AbstractLODShape3D)shape).updateLOD(viewPosition);
        }
        binProvider.addMainAtom(atom, classify, frameId);
        if (pickRay == null) {
            ShadowAtom shadowAtom;
            Appearance app = shape.getAppearance();
            if (app != null && (!app.isStatic() || app.isStaticDirty())) {
                atom.updateStateUnits(app, glCaps);
            }
            if (this.shadowFactory != null && this.shadowFactory.isEnabled() && shape.isOccluder() && (this.shadowFactory.needsPerLightCulling() && isShadowPass || !this.shadowFactory.needsPerLightCulling() && !isShadowPass) && (shadowAtom = this.shadowFactory.getShadowAtom(shape)) != null) {
                binProvider.addShadowAtom(shadowAtom, classify, frameId);
            }
        }
        ++this.unculledShapesCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void cullNodeAtoms(Node node2, Classifier.Classification parentClassify, boolean cullingSuppressed, View view, Point3f viewPosition, Frustum frustum, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass) {
        Classifier.Classification classify;
        if (pickRay == null) {
            if (!node2.isRenderable()) return;
        }
        if (pickRay != null && !node2.isPickable()) {
            return;
        }
        if (node2 instanceof BranchGroup) {
            classify = null;
        } else if (pickRay != null) {
            if (!node2.isIgnoreBounds()) {
                if (!node2.getWorldBounds().intersects(pickRay)) {
                    Classifier.Classification classify2 = Classifier.Classification.OUTSIDE;
                    return;
                }
                classify = null;
            } else {
                classify = null;
            }
        } else if (!cullingSuppressed && !node2.isIgnoreBounds()) {
            if (parentClassify != Classifier.Classification.INSIDE) {
                classify = node2.getBoundsType() == BoundsType.SPHERE ? Classifier.classifyFrustumSphere(frustum, (Sphere)((Object)node2.getWorldBounds())) : (node2.getBoundsType() == BoundsType.AABB ? Classifier.classifyFrustumBox(frustum, (Box)((Object)node2.getWorldBounds())) : null);
                if (classify == Classifier.Classification.OUTSIDE) {
                    return;
                }
            } else {
                classify = parentClassify;
            }
        } else {
            classify = null;
        }
        if (node2.isUpdatableNode()) {
            _SG_PrivilegedAccess.update((UpdatableNode)((Object)node2), view, frustum, nanoTime, nanoStep);
        }
        if (node2.getShowBounds() && !(node2 instanceof Shape3D)) {
            binProvider.addMainAtom(new BoundsAtom(node2), classify, frameId);
        }
        if (!(node2 instanceof GroupNode)) {
            if (!(node2 instanceof Shape3D)) return;
            Shape3D shape = (Shape3D)node2;
            if (!shape.isVisible()) return;
            this.addShapeAtom(shape, classify, viewPosition, binProvider, glCaps, frameId, pickRay, isShadowPass);
            return;
        }
        if (pickRay == null) {
            this.handleGroupShadow((GroupNode)node2, classify, binProvider, frameId, isShadowPass);
        }
        if (((GroupNode)node2).getTotalNumShapes() <= 0L) return;
        if (node2 instanceof SpecialCullingNode) {
            ((SpecialCullingNode)((Object)node2)).cullSpecialNode(node2, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass, this);
            return;
        }
        if (node2 instanceof Switch) {
            this.cullSwitchAtoms((Switch)node2, classify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
            return;
        }
        this.cullGroupAtoms((GroupNode)node2, classify, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
    }

    private final void cullAtoms(GroupNode group, Frustum frustum, boolean cullingSuppressed, View view, Point3f viewPosition, RenderBinProvider binProvider, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRay pickRay, boolean isShadowPass) {
        this.cullNodeAtoms(group, null, cullingSuppressed, view, viewPosition, frustum, binProvider, glCaps, frameId, nanoTime, nanoStep, pickRay, isShadowPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int cullAtoms_normal(RenderPass renderPass, boolean initialize, GroupNode rootGroup, Canvas3D canvas, Point3f viewPosition, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep) {
        this.unculledShapesCount = 0;
        View view = canvas.getView();
        _SG_PrivilegedAccess.set(view, true, renderPass.getConfig());
        Sized2i viewport = renderPass.getConfig() != null && renderPass.getConfig().getViewport() != null ? renderPass.getConfig().getViewport() : canvas;
        Frustum frustum = view.getFrustum(viewport);
        renderPass.getRenderBinProvider().clearAllBins();
        this.cullAtoms(rootGroup, frustum, !renderPass.isFrustumCullingEnabled(), view, viewPosition, renderPass.getRenderBinProvider(), glCaps, frameId, nanoTime, nanoStep, null, false);
        try {
            RenderPass viewPass;
            _SG_PrivilegedAccess.set(canvas.getView(), false, null);
            if (this.shadowFactory != null && this.shadowFactory.isEnabled() && this.shadowFactory.needsPerLightCulling() && renderPass.getShadowCasterLight() != null && (viewPass = this.shadowFactory.setupRenderPass(view, renderPass.getShadowCasterLight(), 0.0f, null, frameId, true)) != null) {
                _SG_PrivilegedAccess.set(view, true, viewPass.getConfig());
                Sized2iRO viewport2 = this.shadowFactory.getLightViewport() != null ? this.shadowFactory.getLightViewport() : (renderPass.getConfig() != null && renderPass.getConfig().getViewport() != null ? renderPass.getConfig().getViewport() : canvas);
                frustum = view.getFrustum(viewport2);
                this.cullAtoms(rootGroup, frustum, !renderPass.isFrustumCullingEnabled(), canvas.getView(), viewPosition, renderPass.getRenderBinProvider(), glCaps, frameId, nanoTime, nanoStep, null, true);
                _SG_PrivilegedAccess.set(view, false, null);
            }
        }
        finally {
            renderPass.getRenderBinProvider().shrinkAllBins();
        }
        return this.unculledShapesCount;
    }

    private final int cullAtoms_picking(Canvas3D canvas, Point3f viewPosition, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        int i;
        this.unculledShapesCount = 0;
        BranchGroup bg0 = null;
        Frustum frustum = null;
        PickRay pickRay = null;
        int j = 0;
        for (i = 0; i < pickRequest.getGroups().size(); ++i) {
            pickRequest.getRenderPasses().get(i).getRenderBinProvider().clearAllBins();
        }
        for (i = 0; i < pickRequest.getGroups().size(); ++i) {
            GroupNode group = pickRequest.getGroups().get(i);
            RenderPass pass = pickRequest.getRenderPasses().get(i);
            BranchGroup bg = group.getRoot();
            if (i == 0 || bg != bg0) {
                bg0 = bg;
                if (bg == null) {
                    throw new NullPointerException("You cannot cull on non-live Groups.");
                }
                View view = canvas.getView();
                _SG_PrivilegedAccess.set(view, true, pass.getConfig());
                ++j;
                Sized2i viewport = pass.getConfig() != null ? (pass.getConfig().getViewport() != null ? pass.getConfig().getViewport() : canvas) : canvas;
                frustum = view.getFrustum(viewport);
            }
            if (pickRay == null) {
                pickRay = PickPool.allocatePickRay();
            }
            pickRay.recalculate(pass.getConfig(), canvas, pickRequest.getMouseX(), pickRequest.getMouseY());
            this.cullAtoms(group, frustum, !pass.isFrustumCullingEnabled(), canvas.getView(), viewPosition, pass.getRenderBinProvider(), glCaps, frameId, nanoTime, nanoStep, pickRay, false);
        }
        if (pickRay != null) {
            PickPool.deallocatePickRay(pickRay);
        }
        while (j-- > 0) {
            _SG_PrivilegedAccess.set(canvas.getView(), false, null);
        }
        return this.unculledShapesCount;
    }

    private final void updateShadowFactory() {
        EffectFactory effFact = EffectFactory.getInstance();
        this.shadowFactory = effFact != null ? effFact.getShadowFactory() : null;
    }

    public final int cullAtoms(RenderPass renderPass, GroupNode rootGroup, Canvas3D canvas, Point3f viewPosition, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        this.updateShadowFactory();
        if (pickRequest == null) {
            return this.cullAtoms_normal(renderPass, true, rootGroup, canvas, viewPosition, glCaps, frameId, nanoTime, nanoStep);
        }
        return this.cullAtoms_picking(canvas, viewPosition, glCaps, frameId, nanoTime, nanoStep, pickRequest);
    }

    public final int cullAtoms(List<RenderPass> renderPasses, List<? extends List<GroupNode>> groupsLists, Canvas3D canvas, OpenGLCapabilities glCaps, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        this.updateShadowFactory();
        int unculledShapesCount = 0;
        if (pickRequest == null) {
            if (groupsLists == null) {
                for (int i = 0; i < renderPasses.size(); ++i) {
                    RenderPass pass = renderPasses.get(i);
                    pass.getRenderCallbackNotifier().notifyBeforeRenderPassIsProcessed(pass);
                    if (pass.getConfig().getViewTransform() == null) {
                        canvas.getView().getPosition(this.viewPosition2);
                    } else {
                        pass.getConfig().getViewTransform().getTranslation(this.viewPosition2);
                    }
                    if (pass.getBranchGroup() != null) {
                        unculledShapesCount += this.cullAtoms_normal(pass, i == 0, pass.getBranchGroup(), canvas, this.viewPosition2, glCaps, frameId, nanoTime, nanoStep);
                    }
                    pass.getRenderCallbackNotifier().notifyAfterRenderPassIsProcessed(pass);
                }
            } else {
                for (int i = 0; i < renderPasses.size(); ++i) {
                    RenderPass pass = renderPasses.get(i);
                    pass.getRenderCallbackNotifier().notifyBeforeRenderPassIsProcessed(pass);
                    if (pass.getConfig().getViewTransform() == null) {
                        canvas.getView().getPosition(this.viewPosition2);
                    } else {
                        pass.getConfig().getViewTransform().getTranslation(this.viewPosition2);
                    }
                    List<GroupNode> groups = groupsLists.get(i);
                    for (int j = 0; j < groups.size(); ++j) {
                        unculledShapesCount += this.cullAtoms_normal(pass, i == 0 && j == 0, groups.get(j), canvas, this.viewPosition2, glCaps, frameId, nanoTime, nanoStep);
                    }
                    pass.getRenderCallbackNotifier().notifyAfterRenderPassIsProcessed(pass);
                }
            }
        } else {
            return this.cullAtoms_picking(canvas, canvas.getView().getPosition(), glCaps, frameId, nanoTime, nanoStep, pickRequest);
        }
        return unculledShapesCount;
    }
}

