/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.openmali.FastMath;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.ScissorRect;
import org.xith3d.render.preprocessing.OrderedState;
import org.xith3d.render.states.StateSortable;
import org.xith3d.render.states.StateSortableMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderAtom<T extends Node>
extends StateSortable {
    private final T node;
    private final boolean hasOrderedState;
    private final StateUnit[] stateUnits;
    private int numStateUnits;
    private Classifier.Classification classify;
    private float squaredDistanceToView;
    private boolean hasPlainDistance = false;
    private float distanceToView;
    private float zValue;
    private Comparable customComparable = null;
    protected boolean translucent = false;
    private StateSortableMap map = new StateSortableMap();

    public final void setCompareIndicators(float squaredDistanceToView, float zValue, Comparable customComparable) {
        this.squaredDistanceToView = squaredDistanceToView;
        this.hasPlainDistance = false;
        this.zValue = zValue;
        this.customComparable = customComparable;
    }

    public final float getSquaredDistanceToView() {
        return this.squaredDistanceToView;
    }

    public final float getDistanceToView() {
        if (!this.hasPlainDistance) {
            this.distanceToView = FastMath.sqrt(this.squaredDistanceToView);
            this.hasPlainDistance = true;
        }
        return this.distanceToView;
    }

    public final float getZValue() {
        return this.zValue;
    }

    public final Comparable getCustomComparable() {
        return this.customComparable;
    }

    public void setClassification(Classifier.Classification classify) {
        this.classify = classify;
    }

    public Classifier.Classification getClassification() {
        return this.classify;
    }

    public abstract <Tup extends Tuple3f> Tup getPosition(Tup var1);

    public final ScissorRect getScissorRect() {
        return ((Node)this.node).getInheritedNodeAttributes().getScissorRect();
    }

    public final ClipperInfo getClipper() {
        return ((Node)this.node).getInheritedNodeAttributes().getClipper();
    }

    public final T getNode() {
        return this.node;
    }

    public final int getNumStateUnits() {
        return this.numStateUnits;
    }

    public void clearStateUnits() {
        this.numStateUnits = 0;
    }

    protected final void updateStateMap(StateUnit stateUnit) {
        this.map.map[stateUnit.getStateType()] = stateUnit;
        this.map.mapID[stateUnit.getStateType()] = stateUnit.getStateId();
        this.map.calcHash();
    }

    public void updateStateUnit(StateUnit stateUnit) {
        if (this.stateUnits[stateUnit.getStateType()] != stateUnit) {
            this.stateUnits[stateUnit.getStateType()] = stateUnit;
            this.updateStateMap(stateUnit);
        }
    }

    public final StateSortableMap getSortableStates() {
        return this.map;
    }

    public final StateUnit[] getStateUnits() {
        return this.stateUnits;
    }

    public final StateUnit getStateUnit(int index) {
        return this.stateUnits[index];
    }

    public final boolean isTranslucent() {
        return this.translucent;
    }

    @Override
    public final long getStateId() {
        return -1L;
    }

    public final OrderedState getOrderedState() {
        if (!this.hasOrderedState || this.getNode() == null) {
            return null;
        }
        return ((Node)this.getNode()).getOrderedState();
    }

    public RenderAtom(int stateType, T node2, boolean hasOrderedState) {
        super(stateType);
        this.node = node2;
        this.hasOrderedState = hasOrderedState;
        this.stateUnits = new StateUnit[17];
        this.numStateUnits = 0;
        this.updateCachedStateId();
    }
}

