/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.openmali.vecmath2.Tuple3f;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateTypes;
import org.xith3d.render.states.units.FogStateUnit;
import org.xith3d.render.states.units.LightingStateUnit;
import org.xith3d.scenegraph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowAtom
extends RenderAtom<Node> {
    public static final int STATE_TYPE = 2;

    @Override
    public <Tup extends Tuple3f> Tup getPosition(Tup p) {
        if (((Node)this.getNode()).getWorldBounds() != null) {
            ((Node)this.getNode()).getWorldBounds().getCenter(p);
        } else {
            ((Node)this.getNode()).getWorldTransform().getTranslation(p);
        }
        return p;
    }

    public final void updateLightsAndFogs() {
        ((LightingStateUnit)this.getStateUnit(LightingStateUnit.STATE_TYPE)).update();
        ((FogStateUnit)this.getStateUnit(FogStateUnit.STATE_TYPE)).update();
    }

    protected ShadowAtom(int stateType, Node node2) {
        super(stateType, node2, true);
        StateTypes.init();
        LightingStateUnit lsu = LightingStateUnit.makeLightingStateUnit(node2.getInheritedNodeAttributes());
        this.updateStateUnit(lsu);
        FogStateUnit fsu = FogStateUnit.makeFogStateUnit(node2.getInheritedNodeAttributes());
        this.updateStateUnit(fsu);
    }

    public ShadowAtom(Node node2) {
        this(2, node2);
    }
}

