/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.openmali.spatial.bodies.Plane;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontToBackRenderBinSorter2
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    private final Plane viewPlane = new Plane();
    private final Point3f tmpPos = new Point3f();
    private final float[] tmpFloats = new float[8];

    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        if (atom1.getSquaredDistanceToView() < atom2.getSquaredDistanceToView()) {
            return -1;
        }
        if (atom1.getSquaredDistanceToView() > atom2.getSquaredDistanceToView()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void updateDistancesToView(RenderBin renderBin, Transform3D viewTransform) {
        viewTransform.getMatrix4f().transform(Vector3f.NEGATIVE_Z_AXIS, this.viewPlane.getNormal());
        viewTransform.getTranslation(this.tmpPos);
        this.viewPlane.setD(this.tmpPos.distance(0.0f, 0.0f, 0.0f));
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        float dist = 0.0f;
        float distSq = 0.0f;
        float depth = 0.0f;
        for (int i = 0; i < atoms.size(); ++i) {
            Bounds bounds = ((Node)atoms.get(i).getNode()).getWorldBounds();
            if (bounds != null && bounds instanceof BoundingSphere) {
                BoundingSphere bs = (BoundingSphere)bounds;
                this.tmpPos.set(bs.getCenterX(), bs.getCenterY(), bs.getCenterZ());
                dist = this.viewPlane.distanceTo(this.tmpPos);
                distSq = dist * dist;
                distSq -= bs.getRadiusSquared();
                depth = this.tmpPos.getZ() + bs.getRadius();
            }
            if (bounds != null && bounds instanceof BoundingBox) {
                BoundingBox bb = (BoundingBox)bounds;
                this.tmpFloats[0] = this.viewPlane.distanceTo(bb.getLowerX(), bb.getLowerY(), bb.getLowerZ());
                this.tmpFloats[1] = this.viewPlane.distanceTo(bb.getUpperX(), bb.getLowerY(), bb.getLowerZ());
                this.tmpFloats[2] = this.viewPlane.distanceTo(bb.getLowerX(), bb.getUpperY(), bb.getLowerZ());
                this.tmpFloats[3] = this.viewPlane.distanceTo(bb.getUpperX(), bb.getUpperY(), bb.getLowerZ());
                this.tmpFloats[4] = this.viewPlane.distanceTo(bb.getLowerX(), bb.getLowerY(), bb.getUpperZ());
                this.tmpFloats[5] = this.viewPlane.distanceTo(bb.getUpperX(), bb.getLowerY(), bb.getUpperZ());
                this.tmpFloats[6] = this.viewPlane.distanceTo(bb.getLowerX(), bb.getUpperY(), bb.getUpperZ());
                this.tmpFloats[7] = this.viewPlane.distanceTo(bb.getUpperX(), bb.getUpperY(), bb.getUpperZ());
                dist = this.tmpFloats[0];
                for (int j = 1; j < this.tmpFloats.length; ++j) {
                    if (!(this.tmpFloats[j] < dist)) continue;
                    dist = this.tmpFloats[j];
                }
                distSq = dist * dist;
                depth = bb.getUpperZ();
            } else {
                atoms.get(i).getPosition(this.tmpPos);
                dist = this.viewPlane.distanceTo(this.tmpPos);
                distSq = dist * dist;
                depth = this.tmpPos.getZ();
            }
            atoms.get(i).setCompareIndicators(distSq, depth, null);
        }
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        this.updateDistancesToView(renderBin, viewTransform);
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        Sorter.quickSort(atoms.getRawArray(), 0, atoms.size() - 1, this);
    }
}

