/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.render.states.StateSortable;
import org.xith3d.render.states.StateSortableMap;
import org.xith3d.scenegraph.Transform3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TU2StateRenderBinSorter
extends RenderBinSorter {
    private static final void swap(RenderAtom<?>[] a, int i, int j) {
        RenderAtom<?> tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    private final void quickSort(RenderAtom<?>[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            RenderAtom<?> mid = a[lo0 + hi0 >>> 1];
            while (lo <= hi) {
                while (lo < hi0 && TU2StateRenderBinSorter.compare(a[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && TU2StateRenderBinSorter.compare(a[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                TU2StateRenderBinSorter.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private static final int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        if (atom1 == atom2) {
            return 0;
        }
        if (atom1.getSortableStates().hash == atom2.getSortableStates().hash) {
            return 0;
        }
        StateSortableMap ssMap1 = atom1.getSortableStates();
        StateSortableMap ssMap2 = atom2.getSortableStates();
        StateSortable ss1 = ssMap1.map[2];
        StateSortable ss2 = ssMap2.map[2];
        if (ss1 != ss2) {
            if (ss1 == null) {
                return -1;
            }
            if (ss2 == null) {
                return 1;
            }
            long stateID1 = ssMap1.mapID[2];
            long stateID2 = ssMap2.mapID[2];
            if (stateID1 < stateID2) {
                return -1;
            }
            if (stateID1 > stateID2) {
                return 1;
            }
            ss1 = ssMap1.map[3];
            ss2 = ssMap2.map[3];
            if (ss1 != ss2) {
                return 0;
            }
            if (ss1 == null) {
                return -1;
            }
            if (ss2 == null) {
                return 1;
            }
            stateID1 = ssMap1.mapID[2];
            stateID2 = ssMap2.mapID[2];
            if (stateID1 < stateID2) {
                return -1;
            }
            if (stateID1 > stateID2) {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        this.quickSort(atoms.getRawArray(), 0, atoms.size() - 1);
    }
}

