/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.ShaderProgramContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderProgramStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private static final StateMap shaderStateMap = new StateMap();
    private static final ShaderProgramStateUnit DEFAULT_PROG = new ShaderProgramStateUnit(new GLSLContext(new GLSLShaderProgram(false)), true);
    private ShaderProgramContext<?> shaderProgram;

    public final ShaderProgramContext<?> getShaderProgram() {
        return this.shaderProgram;
    }

    @Override
    public ShaderProgramContext<?> getNodeComponent() {
        return this.shaderProgram;
    }

    @Override
    public final boolean isTranslucent() {
        return false;
    }

    @Override
    public final long getStateId() {
        return this.shaderProgram.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public void update(ShaderProgramContext<?> shaderProgram) {
        this.shaderProgram = shaderProgram;
        shaderStateMap.assignState(shaderProgram);
    }

    private ShaderProgramStateUnit(ShaderProgramContext<?> shaderProgram, boolean isDefault) {
        super(STATE_TYPE, isDefault);
        this.update(shaderProgram);
    }

    public static ShaderProgramStateUnit makeShaderProgramStateUnit(ShaderProgramContext<?> shaderProgram, StateUnit[] cache) {
        if (shaderProgram == null) {
            return DEFAULT_PROG;
        }
        if (cache[STATE_TYPE] != null) {
            ShaderProgramStateUnit stateUnit = (ShaderProgramStateUnit)cache[STATE_TYPE];
            stateUnit.update(shaderProgram);
            return stateUnit;
        }
        ShaderProgramStateUnit stateUnit = new ShaderProgramStateUnit(shaderProgram, false);
        cache[ShaderProgramStateUnit.STATE_TYPE] = stateUnit;
        return stateUnit;
    }
}

