/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xith3d.loaders.models.Model;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.Shader;
import org.xith3d.scenegraph.Texture;
import org.xith3d.sound.SoundContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBag {
    private static ResourceBag singletonInstance = null;
    private final Map<String, Texture> textures = new HashMap<String, Texture>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Map<String, SoundContainer> sounds = new HashMap<String, SoundContainer>();
    private final Map<String, Shader> shaders = new HashMap<String, Shader>();

    public static void setSingletonInstance(ResourceBag resBag) {
        singletonInstance = resBag;
    }

    public static ResourceBag getInstance() {
        return singletonInstance;
    }

    public void addTexture(String name, Texture texture) {
        this.textures.put(name, texture);
    }

    public Texture getTexture(String name) {
        return this.textures.get(name);
    }

    public Collection<Texture> getTextures() {
        return this.textures.values();
    }

    public int numTextures() {
        return this.textures.size();
    }

    public void addModel(String name, Model model) {
        this.models.put(name, model);
    }

    public Model getModel(String name) {
        return this.models.get(name);
    }

    public Model getModelInstance(String name) {
        Model model = this.getModel(name);
        if (model == null) {
            return null;
        }
        return model.getSharedInstance();
    }

    public Collection<Model> getModels() {
        return this.models.values();
    }

    public int numModels() {
        return this.models.size();
    }

    public void addSound(String name, SoundContainer sound) {
        this.sounds.put(name, sound);
    }

    public SoundContainer getSound(String name) {
        return this.sounds.get(name);
    }

    public Collection<SoundContainer> getSounds() {
        return this.sounds.values();
    }

    public int numSounds() {
        return this.sounds.size();
    }

    public void addShader(String name, Shader shader) {
        this.shaders.put(name, shader);
    }

    public Shader getShader(String name) {
        return this.shaders.get(name);
    }

    public Collection<Shader> getShaders() {
        return this.shaders.values();
    }

    public int numShaders() {
        return this.shaders.size();
    }

    public int numResources() {
        return this.numTextures() + this.numModels() + this.numShaders();
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        for (Texture texture : this.textures.values()) {
            texture.freeOpenGLResources(canvasPeer);
        }
        for (Model model : this.models.values()) {
            model.freeOpenGLResources(canvasPeer);
        }
        for (Shader shader : this.shaders.values()) {
            shader.freeOpenGLResources(canvasPeer);
        }
    }

    public final void freeOpenGLResources(Canvas3D canvas) {
        if (canvas.getPeer() == null) {
            throw new Error("The given Canvas3D is not linked to a CanvasPeer.");
        }
        this.freeOpenGLResources(canvas.getPeer());
    }
}

