/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.xith3d.resources.LoadingScreenUpdater;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLoaderListener;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;

public class ResourceLoader {
    private ResourceLocator resLoc;
    private final ArrayList<ResourceRequest> requests = new ArrayList();
    private final ArrayList<ResourceLoaderListener> listeners = new ArrayList();

    public void setResourceLocator(ResourceLocator resLoc) {
        this.resLoc = resLoc;
    }

    public ResourceLocator getResourceLocator() {
        return this.resLoc;
    }

    public void addResourceLoaderListener(ResourceLoaderListener l) {
        this.listeners.add(l);
    }

    public void removeResourceLoaderListener(ResourceLoaderListener l) {
        this.listeners.remove(l);
    }

    public void addRequest(ResourceRequest resReq) {
        this.requests.add(resReq);
    }

    public final int numRequests() {
        return this.requests.size();
    }

    protected boolean loadResource(ResourceRequest resReq, ResourceBag resBag) {
        boolean success = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).beforeResourceLoaded(this, resReq);
        }
        Object resource = null;
        try {
            resource = resReq.loadResource(this.resLoc, resBag);
        }
        catch (Throwable t) {
            success = false;
            t.printStackTrace();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).afterResourceLoaded(this, resReq, resource);
        }
        return success;
    }

    public ResourceBag loadResources(LoadingScreenUpdater lsu) {
        if (lsu instanceof ResourceLoaderListener) {
            this.addResourceLoaderListener((ResourceLoaderListener)((Object)lsu));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).beforeAnyResourceLoaded(this);
        }
        ResourceBag resBag = new ResourceBag();
        if (lsu != null) {
            lsu.init(-this.numRequests(), null, (String)null);
        }
        if (!this.requests.isEmpty()) {
            RequestsSorter.INSTANCE.sort(this.requests);
            Class<?> lastRequestType = null;
            for (int i = 0; i < this.requests.size(); ++i) {
                int j;
                if (this.requests.get(i).getClass() != lastRequestType) {
                    for (j = 0; j < this.listeners.size(); ++j) {
                        this.listeners.get(j).beforeResourceBundleLoaded(this, this.requests.get(i).getClass());
                    }
                    lastRequestType = this.requests.get(i).getClass();
                }
                if (lsu != null) {
                    lsu.updateOnly("Loading Texture resource \"" + this.requests.get(i).getBagName() + "\"");
                }
                this.loadResource(this.requests.get(i), resBag);
                if (lsu != null) {
                    lsu.update();
                }
                if (this.requests.size() <= i + 1 || this.requests.get(i + 1).getClass() == lastRequestType) continue;
                for (j = 0; j < this.listeners.size(); ++j) {
                    this.listeners.get(j).afterResourceBundleLoaded(this, this.requests.get(i + 1).getClass());
                }
            }
        }
        if (lsu != null) {
            lsu.updateOnly("ready");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).afterAllResourceLoaded(this);
        }
        if (lsu instanceof ResourceLoaderListener) {
            this.removeResourceLoaderListener((ResourceLoaderListener)((Object)lsu));
        }
        return resBag;
    }

    public ResourceBag loadResources() {
        return this.loadResources(null);
    }

    public ResourceLoader(ResourceLocator resLoc) {
        this.resLoc = resLoc;
    }

    public ResourceLoader() {
        this(ResourceLocator.getInstance());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestsSorter
    implements Comparator<ResourceRequest> {
        public static final RequestsSorter INSTANCE = new RequestsSorter();

        private RequestsSorter() {
        }

        @Override
        public int compare(ResourceRequest o1, ResourceRequest o2) {
            return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
        }

        public void sort(ArrayList<ResourceRequest> requests) {
            Collections.sort(requests, this);
        }
    }
}

