/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.io.IOException;
import org.xith3d.loaders.sound.ExtensionSoundLoader;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;
import org.xith3d.sound.SoundContainer;

public class SoundResourceRequest
implements ResourceRequest {
    private final String name;
    private final String bagName;
    private final SoundLoader loader;

    public final String getName() {
        return this.name;
    }

    public final String getBagName() {
        return this.bagName;
    }

    public final SoundLoader getSoundLoader() {
        return this.loader;
    }

    public Object loadResource(ResourceLocator resLoc, ResourceBag resBag) throws IOException {
        SoundLoader loader = this.getSoundLoader();
        if (loader == null) {
            loader = ExtensionSoundLoader.getInstance();
        }
        SoundContainer sound = loader.loadSound(resLoc.getResource(this.getName()));
        resBag.addSound(this.getBagName(), sound);
        return sound;
    }

    public SoundResourceRequest(String name, String bagName, SoundLoader loader) {
        this.name = name;
        this.bagName = bagName;
        this.loader = loader;
    }

    public SoundResourceRequest(String name, String bagName) {
        this(name, bagName, null);
    }
}

