/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.util.image.ImageUtility;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.utility.characters.CharIndex;

public class ASCIITexture
extends Texture2D {
    private final CharIndex charIndex;
    private final TexCoord2f[][] texCoords;
    private final Sized2iRO[] charSizes;
    private static Graphics2D metricsGraphics = null;

    public final CharIndex getCharIndex() {
        return this.charIndex;
    }

    public TexCoord2f[] getTextureCoordinates(char ch) {
        int i = this.charIndex.getIndex(ch);
        if (i < 0 || i >= this.texCoords.length) {
            return null;
        }
        return this.texCoords[i];
    }

    public Sized2iRO getCharSize(char ch) {
        int i = this.charIndex.getIndex(ch);
        if (i < 0 || i >= this.texCoords.length) {
            return null;
        }
        return this.charSizes[i];
    }

    private ASCIITexture(Sized2iRO[] charSizes, TexCoord2f[][] texCoords, CharIndex charIndex) {
        super(TextureFormat.RGBA);
        this.charIndex = charIndex;
        this.charSizes = charSizes;
        this.texCoords = texCoords;
    }

    private static CharMetrics getCharMetrics(char ch, Font font) {
        if (metricsGraphics == null) {
            BufferedImage image = new BufferedImage(16, 16, 6);
            metricsGraphics = image.createGraphics();
        }
        FontMetrics metrics = metricsGraphics.getFontMetrics(font);
        int ascend = metrics.getAscent();
        int descend = metrics.getDescent();
        int lineWidth = metrics.stringWidth(String.valueOf(ch));
        int lineHeight = ascend + descend;
        return new CharMetrics(ch, lineWidth, lineHeight, ascend, descend);
    }

    private static CharMetrics[] createCharMetricsMap(Font font, CharIndex charIndex) {
        CharMetrics[] map = new CharMetrics[charIndex.getNumberOfPrintableChars()];
        char c = charIndex.getTotalNumberOfCharacters();
        for (char ch = '\u0000'; ch < c; ch = (char)(ch + '\u0001')) {
            int i = charIndex.getIndex(ch);
            if (i < 0) continue;
            map[i] = ASCIITexture.getCharMetrics(ch, font);
        }
        return map;
    }

    public static ASCIITexture create(Colorf color, Font font, CharIndex charIndex) {
        CharMetrics[] map = ASCIITexture.createCharMetricsMap(font, charIndex);
        int sqrSize = (int)Math.ceil(Math.sqrt(charIndex.getNumberOfPrintableChars()));
        int sqrW = 0;
        int sqrH = 0;
        int w = 0;
        int h = 0;
        int x = 0;
        for (int i = 0; i < map.length; ++i) {
            x = i % sqrSize;
            if (x == 0) {
                w = 0;
                h = 0;
            }
            w += map[i].width;
            h = Math.max(h, map[i].height);
            if (x != sqrSize - 1) continue;
            sqrW = Math.max(sqrW, w);
            sqrH += h;
        }
        int width = ImageUtility.roundUpPower2(sqrW);
        int height = ImageUtility.roundUpPower2(sqrH);
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(1.0f, 0.0f, 1.0f, 0.0f));
        g2.fillRect(0, 0, width, height);
        if (color == null) {
            g2.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            g2.setColor(color.getAWTColor());
        }
        g2.setFont(font);
        Sized2iRO[] charSizes = new Sized2iRO[map.length];
        TexCoord2f[][] texCoords = new TexCoord2f[map.length][];
        h = 0;
        int left = 0;
        int top = 0;
        int lineHeight = 0;
        float texPx = 1.0f / (float)width;
        float texPy = 1.0f / (float)height;
        for (int i = 0; i < map.length; ++i) {
            x = i % sqrSize;
            if (x == 0) {
                left = 0;
                lineHeight = 0;
            }
            g2.drawString(String.valueOf(map[i].getChar()), left, top + map[i].getLineHeight() - map[i].getDescend());
            charSizes[i] = new Dim2i(map[i].width, map[i].height);
            texCoords[i] = new TexCoord2f[]{new TexCoord2f((float)left * texPx, 1.0f - (float)(top + map[i].height) * texPy), new TexCoord2f((float)(left + map[i].width) * texPx, 1.0f - (float)top * texPy)};
            left += 0 + map[i].width;
            lineHeight = Math.max(lineHeight, map[i].height);
            if (x != sqrSize - 1) continue;
            top += 0 + lineHeight;
        }
        ASCIITexture tex = new ASCIITexture(charSizes, texCoords, charIndex);
        TextureCreator.createTexture(image, TextureLoader.FlipMode.FLIPPED_VERTICALLY, TextureFormat.RGBA, Texture.MipmapMode.BASE_LEVEL, width, height, tex);
        tex.setName("ASCIITexture: " + font + ", " + color);
        return tex;
    }

    private static class CharMetrics
    extends TextureCreator.TextMetrics {
        private static final long serialVersionUID = 1L;
        private final char ch;

        public final char getChar() {
            return this.ch;
        }

        public CharMetrics(char ch, int width, int height, int ascend, int descend) {
            super(width, height, new int[]{width}, height, ascend, descend);
            this.ch = ch;
        }
    }
}

