/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.ShaderProgramContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLContext
extends ShaderProgramContext<GLSLShaderProgram> {
    private static boolean debuggingEnabled = false;
    private final GLSLParameters parameters = new GLSLParameters();

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        super.freeOpenGLResources(canvasPeer);
        this.parameters.freeOpenGLResources(canvasPeer);
    }

    public static void setDebuggingEnabled(boolean debuggingEnabled) {
        GLSLContext.debuggingEnabled = debuggingEnabled;
    }

    public static boolean isDebuggingEnabled() {
        return debuggingEnabled;
    }

    public final GLSLParameters getUniformParameters() {
        return this.parameters;
    }

    @Override
    public GLSLContext getCopy() {
        return this.cloneNodeComponent(true);
    }

    @Override
    protected GLSLShaderProgram newProgramInstance() {
        return new GLSLShaderProgram();
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        GLSLContext orgSP = (GLSLContext)original;
        this.parameters.duplicateNodeComponent(orgSP.getUniformParameters(), forceDuplicate);
    }

    @Override
    public GLSLContext cloneNodeComponent(boolean forceDuplicate) {
        GLSLContext clone = new GLSLContext(null);
        clone.duplicateNodeComponent(this, forceDuplicate);
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GLSLContext)) {
            return false;
        }
        GLSLContext sp = (GLSLContext)o;
        return ((GLSLShaderProgram)this.getProgram()).equals(sp.getProgram()) && this.getUniformParameters().equals(sp.getUniformParameters());
    }

    @Override
    public int compareTo(ShaderProgramContext<GLSLShaderProgram> o) {
        if (this == o) {
            return 0;
        }
        return ((GLSLShaderProgram)this.getProgram()).compareTo(o.getProgram());
    }

    public GLSLContext(GLSLShaderProgram program) {
        super(program);
    }
}

