/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.List;
import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.WriteableTriangleContainer;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.picking.PickPool;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.scenegraph.GeomNioFloatData;
import org.xith3d.scenegraph.GeometryDataContainer;
import org.xith3d.scenegraph.NodeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Geometry
extends NodeComponent
implements VertexContainer {
    public static final int COORDINATES = 1;
    public static final int NORMALS = 2;
    public static final int COLORS = 4;
    public static final int TEXTURE_COORDINATES = 8;
    public static final int VERTEX_ATTRIBUTES = 16;
    public static final int BY_REFERENCE = 512;
    public static final int INTERLEAVED = 1024;
    protected final GeometryDataContainer dataContainer;
    private final SceneGraphOpenGLReferences openGLReferences_texCoords = new SceneGraphOpenGLReferences(1);
    private final SceneGraphOpenGLReferences openGLReferences_geomData = new SceneGraphOpenGLReferences(1);
    private final SceneGraphOpenGLReferences openGLReferences = new SceneGraphOpenGLReferences(1);
    private Optimization optimization = Optimization.AUTO;
    private Bounds cachedBounds = null;

    public final GeometryArrayType getType() {
        return this.dataContainer.getType();
    }

    public final boolean isStrip() {
        return this.dataContainer.isStrip();
    }

    public final int getFaceSize() {
        return this.dataContainer.getFaceSize();
    }

    public abstract boolean isTriangulatable();

    public abstract boolean isTriangulated();

    public final int getMaxVertexCount() {
        return this.dataContainer.getMaxVertexCount();
    }

    @Override
    public int getVertexCount() {
        return this.dataContainer.getVertexCount();
    }

    @Override
    public boolean getVertex(int i, Tuple3f pos) {
        return this.dataContainer.getVertex(i, pos);
    }

    public final int getVertexFormat() {
        return this.dataContainer.getVertexFormat();
    }

    public final boolean isInterleaved() {
        return this.dataContainer.isInterleaved();
    }

    public final boolean hasIndex() {
        return this.dataContainer.hasIndex();
    }

    public final boolean hasColorAlpha() {
        return this.dataContainer.hasColorAlpha();
    }

    public final boolean hasFeature(int flag) {
        return this.dataContainer.hasFeature(flag);
    }

    public void setOptimization(Optimization opt) {
        if (opt == null) {
            throw new NullPointerException("Optimization must not be null");
        }
        this.optimization = opt;
    }

    public final Optimization getOptimization() {
        return this.optimization;
    }

    public void setBoundsDirty() {
        this.cachedBounds = null;
    }

    public final boolean isBoundsDirty() {
        return this.cachedBounds == null;
    }

    void setCachedBounds(Bounds b) {
        this.cachedBounds = b;
    }

    final Bounds getCachedBounds() {
        return this.cachedBounds;
    }

    public void calculateFaceNormals(boolean apply, Vector3f[] faceNormals, Vector3f[] vertexNormals) {
        if (!(this instanceof WriteableTriangleContainer)) {
            throw new Error("Not an instance of WriteableTriangleContainer");
        }
        WriteableTriangleContainer wtc = (WriteableTriangleContainer)((Object)this);
        Triangle triangle = PickPool.allocateTriangle();
        triangle.setFeatures(3);
        Vector3f faceNormal = Vector3f.fromPool();
        int numTrangles = wtc.getTriangleCount();
        for (int i = 0; i < numTrangles; ++i) {
            wtc.getTriangle(i, triangle);
            triangle.getFaceNormal(faceNormal);
            if (apply) {
                triangle.setVertexNormalA(faceNormal);
                triangle.setVertexNormalB(faceNormal);
                triangle.setVertexNormalC(faceNormal);
                this.setTriangle(triangle);
            }
            if (faceNormals != null) {
                if (faceNormals[i] != null) {
                    faceNormals[i].set((TupleNf)faceNormal);
                } else {
                    faceNormals[i] = new Vector3f(faceNormal);
                }
            }
            if (vertexNormals == null) continue;
            if (vertexNormals[triangle.getVertexIndexA()] != null) {
                vertexNormals[triangle.getVertexIndexA()].set((TupleNf)faceNormal);
            } else {
                vertexNormals[triangle.getVertexIndexA()] = new Vector3f(faceNormal);
            }
            if (vertexNormals[triangle.getVertexIndexB()] != null) {
                vertexNormals[triangle.getVertexIndexB()].set((TupleNf)faceNormal);
            } else {
                vertexNormals[triangle.getVertexIndexB()] = new Vector3f(faceNormal);
            }
            if (vertexNormals[triangle.getVertexIndexC()] != null) {
                vertexNormals[triangle.getVertexIndexC()].set((TupleNf)faceNormal);
                continue;
            }
            vertexNormals[triangle.getVertexIndexC()] = new Vector3f(faceNormal);
        }
        Vector3f.toPool(faceNormal);
    }

    public void calculateFaceNormals() {
        this.calculateFaceNormals(true, null, null);
    }

    public void invertNormals() {
        if (!this.hasNormals()) {
            return;
        }
        Vector3f normal = Vector3f.fromPool();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.getNormal(i, normal);
            normal.negate();
            this.setNormal(i, normal);
        }
        Vector3f.toPool(normal);
    }

    public final void addData(float[] coordData, float[] texCoordData, float[] normalData, float[] colorData) {
        this.dataContainer.addData(coordData, texCoordData, normalData, colorData);
    }

    public final void addData(Tuple3f translate, int numVertices, float[] coordData, float[] texCoordData, float[] normalData, float[] colorData) {
        this.dataContainer.addData(translate.getX(), translate.getY(), translate.getZ(), numVertices, coordData, texCoordData, normalData, colorData);
    }

    public void addData(Tuple3f translate, int numVertices, float[] coordData, float[] texCoordData, float[] normalData, float alpha) {
        this.dataContainer.addData(translate.getX(), translate.getY(), translate.getZ(), numVertices, coordData, texCoordData, normalData, alpha);
    }

    public final void setCoordinateData(GeomNioFloatData data) {
        this.dataContainer.setCoordinateData(data);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final GeomNioFloatData getCoordinatesData() {
        return (GeomNioFloatData)this.dataContainer.getCoordinatesData();
    }

    public final int getCoordinatesSize() {
        return this.dataContainer.getCoordinatesSize();
    }

    public final long getCoordinatesOffset() {
        return this.dataContainer.getCoordinatesOffset();
    }

    public void setNormalData(GeomNioFloatData data) {
        this.dataContainer.setNormalData(data);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final GeomNioFloatData getNormalsData() {
        return (GeomNioFloatData)this.dataContainer.getNormalsData();
    }

    public final int getNormalsSize() {
        return this.dataContainer.getNormalsSize();
    }

    public final long getNormalsOffset() {
        return this.dataContainer.getNormalsOffset();
    }

    public void setColorData(GeomNioFloatData data) {
        this.dataContainer.setColorData(data);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final GeomNioFloatData getColorData() {
        return (GeomNioFloatData)this.dataContainer.getColorData();
    }

    public final int getColorsSize() {
        return this.dataContainer.getColorsSize();
    }

    public final long getColorsOffset() {
        return this.dataContainer.getColorsOffset();
    }

    public void setTexCoordData(int unit, GeomNioFloatData data) {
        this.dataContainer.setTexCoordData(unit, data);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final GeomNioFloatData getTexCoordsData(int unit) {
        return (GeomNioFloatData)this.dataContainer.getTexCoordsData(unit);
    }

    public final int getTexCoordSize(int unit) {
        return this.dataContainer.getTexCoordSize(unit);
    }

    public final int getNumTextureUnits() {
        return this.dataContainer.getNumTextureUnits();
    }

    @Deprecated
    public final int getTexCoordSetCount() {
        return this.getNumTextureUnits();
    }

    public final int[] getTexCoordSetMap() {
        return this.dataContainer.getTexCoordSetMap();
    }

    public final void getTexCoordSetMap(int[] intArray) {
        this.dataContainer.getTexCoordSetMap(intArray);
    }

    public final long getTexCoordsOffset(int unit) {
        return this.dataContainer.getTexCoordsOffset(unit);
    }

    public final GeomNioFloatData getVertexAttribData(int index) {
        return (GeomNioFloatData)this.dataContainer.getVertexAttribData(index);
    }

    public final int getVertexAttribSize(int index) {
        return this.dataContainer.getVertexAttribSize(index);
    }

    public final long getVertexAttribsOffset(int index) {
        return this.dataContainer.getVertexAttribsOffset(index);
    }

    public final GeomNioFloatData getInterleavedData() {
        return (GeomNioFloatData)this.dataContainer.getInterleavedData();
    }

    public final void setInitialVertexIndex(int initialVertex) {
        this.dataContainer.setInitialIndex(initialVertex);
    }

    public final int getInitialVertexIndex() {
        return this.dataContainer.getInitialIndex();
    }

    public void setValidVertexCount(int count) {
        this.dataContainer.setValidVertexCount(count);
        this.setChanged(true);
        this.setBoundsDirty();
    }

    public final int getValidVertexCount() {
        return this.dataContainer.getValidVertexCount();
    }

    public final void setCoordinate(int vertexIndex, float[] floatArray) {
        this.dataContainer.setCoordinate(vertexIndex, floatArray);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinates(int vertexIndex, float[] floatArray, int startIndex, int length) {
        this.dataContainer.setCoordinates(vertexIndex, floatArray, startIndex, length);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinates(int vertexIndex, float[] floatArray) {
        this.dataContainer.setCoordinates(vertexIndex, floatArray);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinate(int vertexIndex, Tuple3f point3f) {
        this.dataContainer.setCoordinate(vertexIndex, point3f);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinate(int vertexIndex, float x, float y, float z) {
        this.dataContainer.setCoordinate(vertexIndex, x, y, z);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinates(int vertexIndex, Tuple3f[] point3fArray) {
        this.dataContainer.setCoordinates(vertexIndex, point3fArray);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinates(int vertexIndex, Tuple3f[] point3fArray, int startIndex, int length) {
        this.dataContainer.setCoordinates(vertexIndex, point3fArray, startIndex, length);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setCoordinates(int vertexIndex, List<Tuple3f> point3fList) {
        this.dataContainer.setCoordinates(vertexIndex, point3fList);
        this.setBoundsDirty();
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final <T extends Tuple3f> T getCoordinate(int index, T point) {
        this.dataContainer.getCoordinate(index, point);
        return point;
    }

    public final void getCoordinate(int vertexIndex, float[] floatArray) {
        this.dataContainer.getCoordinate(vertexIndex, floatArray);
    }

    public final void getCoordinates(int vertexIndex, Tuple3f[] point3fArray) {
        this.dataContainer.getCoordinates(vertexIndex, point3fArray);
    }

    public final void getCoordinates(int vertexIndex, float[] floatArray) {
        this.dataContainer.getCoordinates(vertexIndex, floatArray);
    }

    public final boolean hasNormals() {
        return this.dataContainer.hasNormals();
    }

    public final void setNormal(int vertexIndex, float[] floatArray) {
        this.dataContainer.setNormal(vertexIndex, floatArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormals(int vertexIndex, float[] floatArray) {
        this.dataContainer.setNormals(vertexIndex, floatArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormals(int vertexIndex, float[] floatArray, int startIndex, int length) {
        this.dataContainer.setNormals(vertexIndex, floatArray, startIndex, length);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormal(int vertexIndex, Vector3f vector3f) {
        this.dataContainer.setNormal(vertexIndex, vector3f);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormal(int vertexIndex, float x, float y, float z) {
        this.dataContainer.setNormal(vertexIndex, x, y, z);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormals(int vertexIndex, Vector3f[] vector3fArray) {
        this.dataContainer.setNormals(vertexIndex, vector3fArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setNormals(int vertexIndex, Vector3f[] vector3fArray, int startIndex, int length) {
        this.dataContainer.setNormals(vertexIndex, vector3fArray, startIndex, length);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final Vector3f getNormal(int index, Vector3f normal) {
        return this.dataContainer.getNormal(index, normal);
    }

    public final void getNormal(int vertexIndex, float[] floatArray) {
        this.dataContainer.getNormal(vertexIndex, floatArray);
    }

    public final void getNormals(int vertexIndex, float[] floatArray) {
        this.dataContainer.getNormals(vertexIndex, floatArray);
    }

    public final void getNormals(int index0, Vector3f[] vector3fArray) {
        this.dataContainer.getNormals(index0, vector3fArray);
    }

    public void flipNormals() {
        if (!this.hasNormals()) {
            throw new Error("This Geometry doesn't have normals!");
        }
        Vector3f normal = Vector3f.fromPool();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.getNormal(i, normal);
            normal.negate();
            this.setNormal(i, normal);
        }
        Vector3f.toPool(normal);
    }

    public final boolean hasColors() {
        return this.dataContainer.hasColors();
    }

    public final void setColor(int vertexIndex, float[] floatArray) {
        this.dataContainer.setColor(vertexIndex, floatArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColors(int vertexIndex, int colorSize, float[] floatArray) {
        this.dataContainer.setColors(vertexIndex, colorSize, floatArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColors(int vertexIndex, int colorSize, float[] floatArray, int startIndex, int length) {
        this.dataContainer.setColors(vertexIndex, colorSize, floatArray, startIndex, length);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColor(int vertexIndex, Colorf colorf) {
        this.dataContainer.setColor(vertexIndex, colorf);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColor(int vertexIndex, float r, float g, float b) {
        this.dataContainer.setColor(vertexIndex, r, g, b);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColor(int vertexIndex, float r, float g, float b, float a) {
        this.dataContainer.setColor(vertexIndex, r, g, b, a);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColors(int vertexIndex, Colorf[] colorfArray) {
        this.dataContainer.setColors(vertexIndex, colorfArray);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setColors(int vertexIndex, Colorf[] colorfArray, int startIndex, int length) {
        this.dataContainer.setColors(vertexIndex, colorfArray, startIndex, length);
        this.openGLReferences_geomData.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final Colorf getColor(int vertexIndex, Colorf colorf) {
        return this.dataContainer.getColor(vertexIndex, colorf);
    }

    public final void getColor(int vertexIndex, float[] floatArray) {
        this.dataContainer.getColor(vertexIndex, floatArray);
    }

    public final void getColors(int vertexIndex, float[] floatArray) {
        this.dataContainer.getColors(vertexIndex, floatArray);
    }

    public final boolean hasTextureCoordinates() {
        return this.dataContainer.hasTextureCoordinates();
    }

    public final boolean hasTextureCoordinates(int unit) {
        return this.dataContainer.hasTextureCoordinates(unit);
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, float[] floatArray) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, floatArray);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinates(int unit, int vertexIndex, int texCoordSize, float[] floatArray) {
        this.dataContainer.setTextureCoordinates(unit, vertexIndex, texCoordSize, floatArray);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinates(int unit, int vertexIndex, int texCoordSize, float[] floatArray, int startIndex, int length) {
        this.dataContainer.setTextureCoordinates(unit, vertexIndex, texCoordSize, floatArray, startIndex, length);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, float s) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, s);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, float s, float t) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, s, t);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, float s, float t, float r) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, s, t, r);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, float s, float t, float r, float q) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, s, t, r, q);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinate(int unit, int vertexIndex, TexCoordf<?> texCoord) {
        this.dataContainer.setTextureCoordinate(unit, vertexIndex, texCoord);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinates(int unit, int vertexIndex, TexCoordf<?>[] texCoordArray) {
        this.dataContainer.setTextureCoordinates(unit, vertexIndex, texCoordArray);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void setTextureCoordinates(int unit, int vertexIndex, TexCoordf<?>[] texCoordArray, int startIndex, int length) {
        this.dataContainer.setTextureCoordinates(unit, vertexIndex, texCoordArray, startIndex, length);
        this.openGLReferences_texCoords.invalidateNames();
        this.openGLReferences.invalidateNames();
    }

    public final void getTextureCoordinate(int unit, int vertexIndex, float[] floatArray) {
        this.dataContainer.getTextureCoordinate(unit, vertexIndex, floatArray);
    }

    public final void getTextureCoordinates(int unit, int vertexIndex, float[] floatArray) {
        this.dataContainer.getTextureCoordinates(unit, vertexIndex, floatArray);
    }

    public final <T extends TexCoordf<?>> T getTextureCoordinate(int unit, int vertexIndex, T texCoord) {
        return this.dataContainer.getTextureCoordinate(unit, vertexIndex, texCoord);
    }

    public final boolean hasVertexAttributes() {
        return this.dataContainer.hasVertexAttributes();
    }

    public final boolean hasVertexAttributes(int attribIndex) {
        return this.dataContainer.hasVertexAttributes(attribIndex);
    }

    public final int getVertexAttributesCount() {
        return this.dataContainer.getVertexAttributesCount();
    }

    public final void setVertexAttribute(int attribIndex, int vertexIndex, float[] floatArray) {
        this.dataContainer.setVertexAttribute(attribIndex, vertexIndex, floatArray);
    }

    public final void setVertexAttributes(int attribIndex, int vertexIndex, float[] values, int attribSize) {
        this.dataContainer.setVertexAttributes(attribIndex, vertexIndex, values, attribSize);
    }

    public final void setVertexAttributes(int attribIndex, int vertexIndex, float[] values, int attribsSize, int startIndex, int length) {
        this.dataContainer.setVertexAttributes(attribIndex, vertexIndex, values, attribsSize, startIndex, length);
    }

    public final void setVertexAttribute(int attribIndex, int vertexIndex, float value) {
        this.dataContainer.setVertexAttribute(attribIndex, vertexIndex, value);
    }

    public final void setVertexAttribute(int attribIndex, int vertexIndex, TupleNf<?> value) {
        this.dataContainer.setVertexAttribute(attribIndex, vertexIndex, value);
    }

    public final void setVertexAttributes(int attribIndex, int vertexIndex, TupleNf<?>[] values) {
        this.dataContainer.setVertexAttributes(attribIndex, vertexIndex, values);
    }

    public final void setVertexAttributes(int attribIndex, int vertexIndex, TupleNf<?>[] values, int startIndex, int length) {
        this.dataContainer.setVertexAttributes(attribIndex, vertexIndex, values, startIndex, length);
    }

    public final void getVertexAttribute(int attribIndex, int vertexIndex, float[] floatArray) {
        this.dataContainer.getVertexAttribute(attribIndex, vertexIndex, floatArray);
    }

    public final void getVertexAttributes(int attribIndex, int vertexIndex, float[] floatArray) {
        this.dataContainer.getVertexAttributes(attribIndex, vertexIndex, floatArray);
    }

    public final float getVertexAttribute(int attribIndex, int vertexIndex) {
        return this.dataContainer.getVertexAttribute(attribIndex, vertexIndex);
    }

    public final void getVertexAttribute(int attribIndex, int vertexIndex, TupleNf<?> value) {
        this.dataContainer.getVertexAttribute(attribIndex, vertexIndex, value);
    }

    public final boolean setTriangle(int i0, int i1, int i2, Triangle triangle) {
        return this.dataContainer.setTriangle(i0, i1, i2, triangle);
    }

    public final boolean setTriangle(Triangle triangle) {
        return this.dataContainer.setTriangle(triangle);
    }

    public final boolean getTriangle(int i0, int i1, int i2, Triangle triangle) {
        return this.dataContainer.getTriangle(i0, i1, i2, triangle);
    }

    public final float[] getCoordRefFloat() {
        return this.dataContainer.getCoordRefFloat();
    }

    public final float[] getColorRefFloat() {
        return this.dataContainer.getColorRefFloat();
    }

    public final float[] getNormalRefFloat() {
        return this.dataContainer.getNormalRefFloat();
    }

    public final float[] getTexCoordRefFloat(int unit) {
        return this.dataContainer.getTexCoordRefFloat(unit);
    }

    public final SceneGraphOpenGLReferences getOpenGLReference_DL_GeomData() {
        return this.openGLReferences_geomData;
    }

    public final SceneGraphOpenGLReferences getOpenGLReference_DL_TexCoords() {
        return this.openGLReferences_texCoords;
    }

    public final SceneGraphOpenGLReferences getOpenGLReference_DL() {
        return this.openGLReferences;
    }

    protected void finalize() {
        this.openGLReferences_geomData.prepareObjectForDestroy();
        this.openGLReferences_texCoords.prepareObjectForDestroy();
        this.openGLReferences.prepareObjectForDestroy();
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        int i;
        if (this.getCoordinatesData() != null) {
            this.getCoordinatesData().freeOpenGLResources(canvasPeer);
        }
        if (this.getNormalsData() != null) {
            this.getNormalsData().freeOpenGLResources(canvasPeer);
        }
        if (this.getColorData() != null) {
            this.getColorData().freeOpenGLResources(canvasPeer);
        }
        if (this.hasTextureCoordinates()) {
            int[] tcsm = this.getTexCoordSetMap();
            for (i = 0; i < tcsm.length; ++i) {
                this.getTexCoordsData(tcsm[i]).freeOpenGLResources(canvasPeer);
            }
        }
        if (this.hasVertexAttributes()) {
            for (i = 0; i < 16; ++i) {
                GeomNioFloatData d = this.getVertexAttribData(i);
                if (d == null) continue;
                d.freeOpenGLResources(canvasPeer);
            }
        }
        if (this.openGLReferences_geomData.referenceExists(canvasPeer)) {
            this.openGLReferences_geomData.prepareObjectForDestroy(canvasPeer);
        }
        if (this.openGLReferences_texCoords.referenceExists(canvasPeer)) {
            this.openGLReferences_texCoords.prepareObjectForDestroy(canvasPeer);
        }
        if (this.openGLReferences.referenceExists(canvasPeer)) {
            this.openGLReferences.prepareObjectForDestroy(canvasPeer);
        }
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        Geometry o = (Geometry)original;
        this.dataContainer.copyFrom(o.dataContainer, forceDuplicate);
        this.optimization = o.optimization;
        this.setBoundsDirty();
    }

    public final void makeInterleaved(int features, boolean colorAlpha, int[] tuSizes, int[] vaSizes) {
        this.dataContainer.makeInterleaved(features, colorAlpha, tuSizes, vaSizes);
    }

    public final void makeInterleaved() {
        this.dataContainer.makeInterleaved();
    }

    @Override
    public String toString() {
        Tuple3f buffer = new Tuple3f();
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        result.append(" [ ");
        int max = this.getVertexCount();
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            this.getVertex(i, buffer);
            result.append('(');
            result.append(buffer.getX());
            result.append(',');
            result.append(buffer.getY());
            result.append(',');
            result.append(buffer.getZ());
            result.append(')');
        }
        result.append(" ]");
        return result.toString();
    }

    @Override
    public abstract Geometry cloneNodeComponent(boolean var1);

    public Geometry(GeometryArrayType type, boolean hasIndex, int coordsSize, int vertexCount, int[] stripVertexCounts, int indexCount) {
        super(false);
        this.dataContainer = new GeometryDataContainer(type, hasIndex, coordsSize, vertexCount, stripVertexCounts, indexCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Optimization {
        NONE,
        AUTO,
        USE_DISPLAY_LISTS,
        USE_VBOS,
        USE_VBO_FOR_VERTEX_DATA,
        USE_VBO_FOR_TEXTURE_COORDINATES;


        public final boolean isNone() {
            return this == NONE;
        }

        public final boolean isAuto() {
            return this == AUTO;
        }

        public final boolean dl() {
            return this == USE_DISPLAY_LISTS;
        }

        public final boolean vboForVertices() {
            return this == USE_VBOS || this == USE_VBO_FOR_VERTEX_DATA;
        }

        public final boolean vboForTexCoords() {
            return this == USE_VBOS || this == USE_VBO_FOR_TEXTURE_COORDINATES;
        }

        public final boolean vbo() {
            return this == USE_VBOS || this == USE_VBO_FOR_VERTEX_DATA || this == USE_VBO_FOR_TEXTURE_COORDINATES;
        }

        public final boolean optForVertices() {
            return this.vboForVertices();
        }

        public final boolean optForTexCoords() {
            return this.vboForTexCoords();
        }
    }
}

