/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.nio.FloatBuffer;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GeomNioFloatData;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;

public class Morph
extends Shape3D {
    public static final int ALLOW_GEOMETRY_ARRAY_READ = 20;
    public static final int ALLOW_GEOMETRY_ARRAY_WRITE = 21;
    public static final int ALLOW_WEIGHTS_READ = 22;
    public static final int ALLOW_WEIGHTS_WRITE = 23;
    private Geometry[] geometryArrays = null;
    private double[] weights = null;
    private float[][] coordinateData = null;
    private float[][] normalData = null;
    private float[][] colorData = null;
    private float[][][] texCoordData = null;
    private float[][] refData;
    private float[] refWeights;
    private int[] refGeoms;

    public void setGeometryArrays(Geometry[] geometryArrays) {
        if (geometryArrays == null || geometryArrays.length == 0) {
            throw new IllegalArgumentException("Morph: Number of GeometryArrays should be non-zero");
        }
        for (int i = 1; i < geometryArrays.length; ++i) {
            this.doErrorCheck(geometryArrays[i], geometryArrays[i - 1]);
        }
        this.geometryArrays = geometryArrays;
        this.buildCompatibleGeometry(geometryArrays[0]);
        double[] weights = new double[geometryArrays.length];
        weights[0] = 1.0;
        this.setWeights(weights);
    }

    private void doErrorCheck(Geometry a1, Geometry a2) {
        if (a1 == null || a2 == null) {
            throw new IllegalArgumentException("Morph: All GeometryArrays must be non-null");
        }
        if (a1.getVertexFormat() != a2.getVertexFormat() || a1.getValidVertexCount() != a2.getValidVertexCount()) {
            throw new IllegalArgumentException("Morph: All GeometryArrays must have same vertexFormat, same validVertexCount");
        }
        int[] texMap1 = a1.getTexCoordSetMap();
        int[] texMap2 = a2.getTexCoordSetMap();
        if (texMap1 != null && texMap2 != null) {
            if (texMap1.length != texMap2.length) {
                throw new IllegalArgumentException("Morph: All GeometryArrays must have same texCoordSetMap length");
            }
            for (int i = 0; i < texMap1.length; ++i) {
                if (texMap1[i] == texMap2[i]) continue;
                throw new IllegalArgumentException("Morph: All GeometryArrays must have same texCoordSetMap");
            }
        } else if (texMap1 != null || texMap2 != null) {
            throw new IllegalArgumentException("Morph: All GeometryArrays must have same non-null texCoordSetMap");
        }
    }

    private void buildCompatibleGeometry(Geometry a) {
        int[] tuSetMap;
        int j;
        this.setGeometry(a.cloneNodeComponent(true));
        this.coordinateData = new float[this.geometryArrays.length][];
        for (j = 0; j < this.geometryArrays.length; ++j) {
            this.coordinateData[j] = this.geometryArrays[j].getCoordRefFloat();
        }
        if ((a.getVertexFormat() & 2) != 0) {
            this.normalData = new float[this.geometryArrays.length][];
            for (j = 0; j < this.geometryArrays.length; ++j) {
                this.normalData[j] = this.geometryArrays[j].getNormalRefFloat();
            }
        } else {
            this.normalData = null;
        }
        if (a.hasColorAlpha()) {
            this.colorData = new float[this.geometryArrays.length][];
            for (j = 0; j < this.geometryArrays.length; ++j) {
                this.colorData[j] = this.geometryArrays[j].getColorRefFloat();
            }
        } else {
            this.colorData = null;
        }
        if ((tuSetMap = a.getTexCoordSetMap()).length > 0) {
            this.texCoordData = new float[tuSetMap.length][][];
            for (int i = 0; i < tuSetMap.length; ++i) {
                this.texCoordData[i] = new float[this.geometryArrays.length][];
                for (int j2 = 0; j2 < this.geometryArrays.length; ++j2) {
                    this.texCoordData[i][j2] = this.geometryArrays[j2].getTexCoordRefFloat(tuSetMap[i]);
                }
            }
        } else {
            this.texCoordData = null;
        }
    }

    public final Geometry getGeometryArray(int i) {
        return this.geometryArrays[i];
    }

    public void setWeights(double[] weights) {
        if (weights.length != this.geometryArrays.length) {
            throw new IllegalArgumentException("Morph: number of weights not same as number of GeometryArrays");
        }
        if (this.weights == null || this.weights.length != weights.length) {
            this.weights = new double[weights.length];
        }
        for (int i = weights.length - 1; i >= 0; --i) {
            this.weights[i] = weights[i];
        }
        this.updateGeometryData();
    }

    private void doWeight(float[][] src, float[] weights, int n, GeomNioFloatData dstData) {
        FloatBuffer dst = dstData.getBuffer();
        dst.rewind();
        int dstCount = src[0].length;
        switch (n) {
            case 1: {
                float[] s0 = src[0];
                float w0 = weights[0];
                for (int i = 0; i < dstCount; ++i) {
                    dst.put(s0[i] * w0);
                }
                return;
            }
            case 2: {
                float[] s0 = src[0];
                float[] s1 = src[1];
                float w0 = weights[0];
                float w1 = weights[1];
                for (int i = 0; i < dstCount; ++i) {
                    dst.put(s0[i] * w0 + s1[i] * w1);
                }
                return;
            }
            case 3: {
                float[] s0 = src[0];
                float[] s1 = src[1];
                float[] s2 = src[2];
                float w0 = weights[0];
                float w1 = weights[1];
                float w2 = weights[2];
                for (int i = 0; i < dstCount; ++i) {
                    dst.put(s0[i] * w0 + s1[i] * w1 + s2[i] * w2);
                }
                return;
            }
        }
        for (int i = 0; i < dstCount; ++i) {
            float v = src[0][i] * weights[0];
            for (int j = 1; j < n; ++j) {
                v += src[j][i] * weights[j];
            }
            dst.put(v);
        }
    }

    private void updateGeometryData() {
        int[] texCoordSetMap;
        int texCoordSetCount;
        int i;
        Geometry ga = this.getGeometry();
        if (this.refData == null || this.refData.length != this.geometryArrays.length) {
            this.refData = new float[this.geometryArrays.length][];
            this.refWeights = new float[this.geometryArrays.length];
            this.refGeoms = new int[this.geometryArrays.length];
        }
        int n = 0;
        for (i = 0; i < this.weights.length; ++i) {
            float w = (float)this.weights[i];
            if (w == 0.0f) continue;
            this.refWeights[n] = w;
            this.refGeoms[n++] = i;
        }
        if (n == 0) {
            return;
        }
        for (i = 0; i < n; ++i) {
            this.refData[i] = this.coordinateData[this.refGeoms[i]];
        }
        this.doWeight(this.refData, this.refWeights, n, ga.getCoordinatesData());
        ga.getCoordinatesData().setDirty(true);
        if ((ga.getVertexFormat() & 2) != 0) {
            for (i = 0; i < n; ++i) {
                this.refData[i] = this.normalData[this.refGeoms[i]];
            }
            this.doWeight(this.refData, this.refWeights, n, ga.getNormalsData());
            ga.getNormalsData().setDirty(true);
        }
        if (ga.hasColorAlpha()) {
            for (i = 0; i < n; ++i) {
                this.refData[i] = this.colorData[this.refGeoms[i]];
            }
            this.doWeight(this.refData, this.refWeights, n, ga.getColorData());
            ga.getColorData().setDirty(true);
        }
        int n2 = texCoordSetCount = (texCoordSetMap = ga.getTexCoordSetMap()) == null ? 0 : texCoordSetMap.length;
        if (texCoordSetCount > 0) {
            for (int j = 0; j < texCoordSetCount; ++j) {
                for (int i2 = 0; i2 < n; ++i2) {
                    this.refData[i2] = this.texCoordData[j][this.refGeoms[i2]];
                }
                this.doWeight(this.refData, this.refWeights, n, ga.getTexCoordsData(j));
                ga.getTexCoordsData(j).setDirty(true);
            }
        }
    }

    public final int getGeometryArrayCount() {
        return this.geometryArrays.length;
    }

    public Morph() {
    }

    public Morph(Geometry[] geometryArrays) {
        this.setGeometryArrays(geometryArrays);
    }

    public Morph(Geometry[] geometryArrays, Appearance appearance) {
        this.setGeometryArrays(geometryArrays);
        this.setAppearance(appearance);
    }
}

