/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiShape3D
extends Shape3D {
    private ArrayList<Geometry> geometries = new ArrayList();
    private ArrayList<Appearance> appearances = new ArrayList();
    private HashMap<String, Integer> mapName2Unit = new HashMap();
    private ArrayList<String> mapUnit2Name = new ArrayList();
    private List<String> unmodMapUnit2Name = Collections.unmodifiableList(this.mapUnit2Name);
    private int activeUnit = -1;

    public final List<String> getUnits() {
        return this.unmodMapUnit2Name;
    }

    public final int getNumberOfUnits() {
        return this.mapUnit2Name.size();
    }

    public final int getActiveUnit() {
        if (this.activeUnit == -1) {
            return -1;
        }
        return this.activeUnit;
    }

    public final String getActiveUnitName() {
        if (this.activeUnit == -1) {
            return null;
        }
        return this.mapUnit2Name.get(this.activeUnit);
    }

    public void setActiveUnit(int index) {
        this.setGeometry(this.geometries.get(index));
        this.setAppearance(this.appearances.get(index));
        this.activeUnit = index;
    }

    public void setActiveUnit(String name) {
        this.setActiveUnit(this.mapName2Unit.get(name));
    }

    public void addUnit(String name, Geometry geometry, Appearance appearance) {
        this.mapName2Unit.put(name, new Integer(this.getNumberOfUnits()));
        this.geometries.add(geometry);
        this.appearances.add(appearance);
        geometry.setModListener(this.getModListener());
        appearance.setModListener(this.getModListener());
        if (this.getGeometry() == null || this.getAppearance() == null) {
            this.setActiveUnit(name);
        }
    }

    public void addUnit(Geometry geometry, Appearance appearance) {
        this.addUnit(Integer.toHexString(geometry.hashCode()) + "-" + Integer.toHexString(appearance.hashCode()), geometry, appearance);
    }

    @Override
    public void setModListener(ScenegraphModificationsListener modListener) {
        int i;
        super.setModListener(modListener);
        if (this.getAppearance() != null) {
            this.getAppearance().setModListener(this.getModListener());
        }
        if (this.getGeometry() != null) {
            this.getGeometry().setModListener(this.getModListener());
        }
        for (i = 0; i < this.geometries.size(); ++i) {
            this.geometries.get(i).setModListener(this.getModListener());
        }
        for (i = 0; i < this.appearances.size(); ++i) {
            this.appearances.get(i).setModListener(this.getModListener());
        }
    }

    public MultiShape3D(Geometry geometry, Appearance appearance) {
        this.setGeometry(geometry);
        this.setAppearance(appearance);
    }

    public MultiShape3D(Geometry geometry) {
        this(geometry, null);
    }

    public MultiShape3D() {
        this(null, null);
    }
}

