/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.Renderer;
import org.xith3d.render._RNDR_PrivilegedAccess;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;
import org.xith3d.ui.hud.HUD;

public class SceneGraph {
    protected static final boolean CHECK_FOR_ILLEGAL_MODIFICATION = false;
    private final Renderer renderer;
    private final ArrayList<View> views = new ArrayList();
    protected final ArrayList<HUD> huds = new ArrayList();
    private final ArrayList<BranchGroup> branchGroups = new ArrayList();
    public ScenegraphModificationsListener modListener = null;

    protected static final void checkForIllegalModification(Node node2) {
        if (node2.isLive() && _RNDR_PrivilegedAccess.getRenderersWorking() > 0) {
            new Error("Illegal Scenegraph Modification ").printStackTrace();
            System.exit(100);
        }
    }

    public final Renderer getRenderer() {
        return this.renderer;
    }

    public final void addScenegraphModificationListener(ScenegraphModificationsListener modListener) {
        this.getRenderer().addScenegraphModificationListener(modListener);
    }

    public final void removeScenegraphModificationListener(ScenegraphModificationsListener modListener) {
        this.getRenderer().removeScenegraphModificationListener(modListener);
    }

    public final void addView(View view) {
        this.views.add(view);
    }

    public final int getNumberOfViews() {
        return this.views.size();
    }

    public final View getView() {
        if (this.views.size() == 0) {
            return null;
        }
        return this.views.get(0);
    }

    public View getView(int index) {
        return this.views.get(index);
    }

    private final void addBranchGroup(BranchGroup bg) {
        this.branchGroups.add(bg);
        bg.setSceneGraph(this);
        if (this.modListener != null) {
            this.modListener.onBranchGraphAdded(bg);
        }
    }

    public final RenderPass addBranchGraph(BranchGroup branchGraph, RenderPassConfig renderPassConfig) {
        this.addBranchGroup(branchGraph);
        View.ProjectionPolicy projPoli = renderPassConfig.getProjectionPolicy();
        if (projPoli == null && this.getView() != null) {
            projPoli = this.getView().getProjectionPolicy();
        }
        RenderPass renderPass = new RenderPass(branchGraph, renderPassConfig);
        this.addRenderPass(renderPass);
        return renderPass;
    }

    public final RenderPass addPerspectiveBranch(BranchGroup branchGraph) {
        BaseRenderPassConfig persPassConfig = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
        return this.addBranchGraph(branchGraph, persPassConfig);
    }

    public final RenderPass addPerspectiveBranch() {
        return this.addPerspectiveBranch(new BranchGroup());
    }

    public final RenderPass addParallelBranch(BranchGroup branchGraph) {
        BaseRenderPassConfig paraPassConfig = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION);
        return this.addBranchGraph(branchGraph, paraPassConfig);
    }

    public final RenderPass addParallelBranch() {
        return this.addParallelBranch(new BranchGroup());
    }

    public final void removeBranchGraph(BranchGroup branchGraph) {
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses(branchGraph);
        branchGraph.setSceneGraph(null);
        if (this.modListener != null) {
            this.modListener.onBranchGraphRemoved(branchGraph);
        }
        for (int i = 0; i < renderPasses.size(); ++i) {
            _RNDR_PrivilegedAccess.removeRenderPass(renderPasses.get(i), this.getRenderer());
        }
        this.branchGroups.remove(branchGraph);
    }

    public final int getNumberOfBranchGroups() {
        return this.branchGroups.size();
    }

    public final long getTotalNumChildren() {
        long totalNumChildren = 0L;
        for (int i = 0; i < this.branchGroups.size(); ++i) {
            totalNumChildren += 1L + this.branchGroups.get(i).getTotalNumChildren();
        }
        return totalNumChildren;
    }

    public final long getTotalNumShapes() {
        long totalNumShapes = 0L;
        for (int i = 0; i < this.branchGroups.size(); ++i) {
            totalNumShapes += this.branchGroups.get(i).getTotalNumShapes();
        }
        return totalNumShapes;
    }

    public final BranchGroup getBranchGroup(int index) {
        return this.branchGroups.get(index);
    }

    public final BranchGroup getBranchGroup() {
        if (this.branchGroups.size() == 0) {
            return null;
        }
        return this.getBranchGroup(0);
    }

    private final int findLastBackgroundPass() {
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses();
        for (int i = 0; i < renderPasses.size(); ++i) {
            RenderPass rp = renderPasses.get(i);
            if (rp instanceof BackgroundRenderPass) continue;
            return i - 1;
        }
        return renderPasses.size() - 1;
    }

    private final int findLastNormalPass() {
        int lastBackgroundPass = this.findLastBackgroundPass();
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses();
        for (int i = lastBackgroundPass + 1; i < renderPasses.size(); ++i) {
            RenderPass rp = renderPasses.get(i);
            if (!(rp instanceof ForegroundRenderPass)) continue;
            return i - 1;
        }
        return renderPasses.size() - 1;
    }

    public final void removeRenderPass(RenderPass renderPass) {
        this.removeBranchGraph(renderPass.getBranchGroup());
    }

    public final BranchGroup addRenderPass(RenderPass renderPass) {
        if (!this.branchGroups.contains(renderPass.getBranchGroup())) {
            this.addBranchGroup(renderPass.getBranchGroup());
        }
        if (this.getRenderer().getRenderPasses().contains(renderPass)) {
            return renderPass.getBranchGroup();
        }
        if (renderPass instanceof BackgroundRenderPass) {
            _RNDR_PrivilegedAccess.addRenderPass(this.findLastBackgroundPass() + 1, renderPass, this.getRenderer());
        } else if (renderPass instanceof ForegroundRenderPass) {
            _RNDR_PrivilegedAccess.addRenderPass(renderPass, this.getRenderer());
        } else {
            _RNDR_PrivilegedAccess.addRenderPass(this.findLastNormalPass() + 1, renderPass, this.getRenderer());
        }
        return renderPass.getBranchGroup();
    }

    public final BranchGroup addRenderPassFirst(RenderPass renderPass) {
        if (!this.branchGroups.contains(renderPass.getBranchGroup())) {
            this.addBranchGroup(renderPass.getBranchGroup());
        }
        _RNDR_PrivilegedAccess.addRenderPass(0, renderPass, this.getRenderer());
        return renderPass.getBranchGroup();
    }

    public final void removeAllBranchGraphs() {
        if (this.modListener != null) {
            for (int i = 0; i < this.branchGroups.size(); ++i) {
                this.modListener.onBranchGraphRemoved(this.branchGroups.get(i));
            }
        }
        this.branchGroups.clear();
        _RNDR_PrivilegedAccess.removeAllRenderPasses(this.getRenderer());
    }

    private final Canvas3D findFirstCanvas() {
        int nv = this.getNumberOfViews();
        for (int i = 0; i < nv; ++i) {
            View view = this.getView(i);
            if (view.numCanvas3Ds() <= 0) continue;
            return view.getCanvas3D(0);
        }
        return null;
    }

    public final RenderPass addHUD(HUD hud) {
        ForegroundRenderPass renderPass = hud.getRenderPass();
        this.addRenderPass(renderPass);
        this.huds.add(hud);
        Canvas3D canvas = this.findFirstCanvas();
        if (canvas != null) {
            hud.connect(canvas);
        }
        if (InputSystem.hasInstance()) {
            hud.connect(InputSystem.getInstance());
        }
        return renderPass;
    }

    public final HUD getHUD() {
        return this.huds.isEmpty() ? null : this.huds.get(0);
    }

    public final void removeHUD(HUD hud) {
        this.removeRenderPass(hud.getRenderPass());
        this.huds.remove(hud);
        Canvas3D canvas = this.findFirstCanvas();
        if (canvas != null) {
            hud.disconnect(canvas);
        }
        if (InputSystem.hasInstance()) {
            hud.disconnect(InputSystem.getInstance());
        }
    }

    public SceneGraph(Renderer renderer) {
        this.renderer = renderer;
    }
}

