/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;

public class SpotLight
extends PointLight {
    public static final Vector3f DEFAULT_DIRECTION = Vector3f.newReadOnly(0.0f, 0.0f, -1.0f);
    public static final float DEFAULT_SPREAD_ANGLE = (float)Math.PI;
    public static final float DEFAULT_CONCENTRAION = 1.0f;
    private Vector3f direction = new Vector3f(DEFAULT_DIRECTION);
    private float spread;
    private float spreadDeg;
    private float concentration;

    public void setDirection(float dirX, float dirY, float dirZ) {
        this.direction.set(dirX, dirY, dirZ);
    }

    public final void setDirection(Tuple3f direction) {
        this.setDirection(direction.getX(), direction.getY(), direction.getZ());
    }

    public final Vector3f getDirection() {
        return this.direction;
    }

    public final Vector3f getDirection(Vector3f direction) {
        direction.set((TupleNf)this.direction);
        return direction;
    }

    public final void getComputedDirection(Vector3f direction) {
        if (this.getTrackedNode() == null) {
            this.getDirection(direction);
        } else {
            this.getTrackedNode().getWorldTransform().transform(this.getDirection(), direction);
        }
    }

    public void setSpreadAngle(float spread) {
        this.spread = spread;
        this.spreadDeg = FastMath.toDeg(spread);
    }

    public void setSpreadAngleDeg(float spread) {
        this.spreadDeg = spread;
        this.spread = FastMath.toRad(this.spreadDeg);
    }

    public final float getSpreadAngle() {
        return this.spread;
    }

    public final float getSpreadAngleDeg() {
        return this.spreadDeg;
    }

    public void setConcentration(float concentration) {
        this.concentration = concentration;
    }

    public final float getConcentration() {
        return this.concentration;
    }

    public SpotLight(boolean enabled, Colorf color, Tuple3f location, Tuple3f direction, Tuple3f attenuation, float spreadAngle, float concentration) {
        super(enabled, color, location, attenuation);
        if (direction != null) {
            this.direction.set((TupleNf)direction);
        }
        this.setSpreadAngle(spreadAngle);
        this.concentration = concentration;
    }

    public SpotLight(Colorf color, Tuple3f location, Tuple3f direction, Tuple3f attenuation, float spreadAngle, float concentration) {
        this(true, color, location, direction, attenuation, spreadAngle, concentration);
    }

    public SpotLight(boolean enabled, Colorf color, Tuple3f location, Tuple3f direction, float spreadAngle) {
        this(enabled, color, location, direction, DEFAULT_ATTENUATION, spreadAngle, 1.0f);
    }

    public SpotLight(Colorf color, Tuple3f location, Tuple3f direction, float spreadAngle) {
        this(true, color, location, direction, spreadAngle);
    }

    public SpotLight(boolean enabled) {
        this(enabled, DEFAULT_COLOR, (Tuple3f)DEFAULT_LOCATION, DEFAULT_DIRECTION, DEFAULT_ATTENUATION, (float)Math.PI, 1.0f);
    }

    public SpotLight() {
        this(true);
    }

    public SpotLight(boolean enabled, Colorf color, Tuple3f direction, Node trackedNode, Tuple3f attenuation, float spreadAngle, float concentration) {
        this(enabled, color, (Tuple3f)DEFAULT_LOCATION, direction, attenuation, spreadAngle, concentration);
        this.setTrackedNode(trackedNode);
    }

    public SpotLight(Colorf color, Tuple3f direction, Node trackedNode, Tuple3f attenuation, float spreadAngle, float concentration) {
        this(true, color, direction, trackedNode, attenuation, spreadAngle, concentration);
    }

    public SpotLight(boolean enabled, Colorf color, Tuple3f direction, Node trackedNode, float spreadAngle) {
        this(enabled, color, direction, trackedNode, DEFAULT_ATTENUATION, spreadAngle, 1.0f);
    }

    public SpotLight(Colorf color, Tuple3f direction, Node trackedNode, float spreadAngle) {
        this(true, color, direction, trackedNode, spreadAngle);
    }

    public SpotLight(boolean enabled, Node trackedNode) {
        this(enabled);
        this.setTrackedNode(trackedNode);
    }

    public SpotLight(Node trackedNode) {
        this(true, trackedNode);
    }
}

