/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.jagatoo.opengl.enums.TexCoordGenMode;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexCoordGeneration
extends NodeComponent
implements StateTrackable<TexCoordGeneration>,
Enableable {
    public static final TexCoordGenMode OBJECT_LINEAR = TexCoordGenMode.OBJECT_LINEAR;
    public static final TexCoordGenMode EYE_LINEAR = TexCoordGenMode.EYE_LINEAR;
    public static final TexCoordGenMode SPHERE_MAP = TexCoordGenMode.SPHERE_MAP;
    public static final TexCoordGenMode NORMAL_MAP = TexCoordGenMode.NORMAL_MAP;
    public static final TexCoordGenMode REFLECTION_MAP = TexCoordGenMode.REFLECTION_MAP;
    public static final CoordMode TEXTURE_COORDINATE_1 = CoordMode.TEXTURE_COORDINATES_1;
    public static final CoordMode TEXTURE_COORDINATE_2 = CoordMode.TEXTURE_COORDINATES_2;
    public static final CoordMode TEXTURE_COORDINATE_3 = CoordMode.TEXTURE_COORDINATES_3;
    public static final CoordMode TEXTURE_COORDINATE_4 = CoordMode.TEXTURE_COORDINATES_4;
    private TexCoordGenMode genMode = OBJECT_LINEAR;
    private CoordMode format = CoordMode.TEXTURE_COORDINATES_2;
    private final Vector4f planeS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    private final Vector4f planeT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    private final Vector4f planeR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private final Vector4f planeQ = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean enabled = true;
    private StateNode stateNode = null;
    private long stateId = -1L;

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
        this.setChanged(true);
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void setChanged(boolean changed) {
        super.setChanged(changed);
    }

    public final void setFormat(CoordMode format) {
        this.format = format;
        this.setChanged(true);
    }

    public final CoordMode getFormat() {
        return this.format;
    }

    public final void setGenMode(TexCoordGenMode genMode) {
        this.genMode = genMode;
        this.setChanged(true);
    }

    public final TexCoordGenMode getGenMode() {
        return this.genMode;
    }

    public final void setPlaneS(float planeSx, float planeSy, float planeSz, float planeSw) {
        this.planeS.set(planeSx, planeSy, planeSz, planeSw);
        this.setChanged(true);
    }

    public final void setPlaneS(Vector4f planeS) {
        this.planeS.set((TupleNf)planeS);
        this.setChanged(true);
    }

    public final Vector4f getPlaneS() {
        return this.planeS;
    }

    public final void setPlaneT(float planeTx, float planeTy, float planeTz, float planeTw) {
        this.planeT.set(planeTx, planeTy, planeTz, planeTw);
        this.setChanged(true);
    }

    public final void setPlaneT(Vector4f planeT) {
        this.planeT.set((TupleNf)planeT);
        this.setChanged(true);
    }

    public final Vector4f getPlaneT() {
        return this.planeT;
    }

    public final void setPlaneR(float planeRx, float planeRy, float planeRz, float planeRw) {
        this.planeR.set(planeRx, planeRy, planeRz, planeRw);
        this.setChanged(true);
    }

    public final void setPlaneR(Vector4f planeR) {
        this.planeR.set((TupleNf)planeR);
        this.setChanged(true);
    }

    public final Vector4f getPlaneR() {
        return this.planeR;
    }

    public final void setPlaneQ(float planeQx, float planeQy, float planeQz, float planeQw) {
        this.planeQ.set(planeQx, planeQy, planeQz, planeQw);
        this.setChanged(true);
    }

    public final void setPlaneQ(Vector4f planeQ) {
        this.planeQ.set((TupleNf)planeQ);
        this.setChanged(true);
    }

    public final Vector4f getPlaneQ() {
        return this.planeQ;
    }

    @Override
    public String toString() {
        return TexCoordGeneration.class.getSimpleName() + " {" + (Object)((Object)this.getGenMode()) + ", " + (Object)((Object)this.getFormat()) + ", " + (this.isEnabled() ? "enabled" : "disabled") + "}";
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        TexCoordGeneration origTG = (TexCoordGeneration)original;
        this.genMode = origTG.genMode;
        this.format = TEXTURE_COORDINATE_2;
        this.planeS.set((TupleNf)origTG.planeS);
        this.planeT.set((TupleNf)origTG.planeT);
        this.planeR.set((TupleNf)origTG.planeR);
        this.planeQ.set((TupleNf)origTG.planeQ);
        this.enabled = origTG.enabled;
    }

    @Override
    public TexCoordGeneration cloneNodeComponent(boolean forceDuplicate) {
        TexCoordGeneration tcg = new TexCoordGeneration();
        tcg.duplicateNodeComponent(this, forceDuplicate);
        return tcg;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    @Override
    public final void setStateNode(StateNode node2) {
        this.stateNode = node2;
        this.stateId = node2.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public TexCoordGeneration getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TexCoordGeneration)) {
            return false;
        }
        TexCoordGeneration tcgo = (TexCoordGeneration)o;
        if (this.genMode != tcgo.genMode) {
            return false;
        }
        if (this.format != tcgo.format) {
            return false;
        }
        if (!((TupleNf)this.planeS).equals(tcgo.planeS)) {
            return false;
        }
        if (!((TupleNf)this.planeT).equals(tcgo.planeT)) {
            return false;
        }
        if (!((TupleNf)this.planeR).equals(tcgo.planeR)) {
            return false;
        }
        return ((TupleNf)this.planeQ).equals(tcgo.planeQ);
    }

    @Override
    public int compareTo(TexCoordGeneration o) {
        if (this == o) {
            return 0;
        }
        if (this.genMode.ordinal() < o.genMode.ordinal()) {
            return -1;
        }
        if (this.genMode.ordinal() > o.genMode.ordinal()) {
            return 1;
        }
        if (this.format.ordinal() < o.format.ordinal()) {
            return -1;
        }
        if (this.format.ordinal() > o.format.ordinal()) {
            return 1;
        }
        int val = ComparatorHelper.compareTuple(this.planeS, o.planeS);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareTuple(this.planeT, o.planeT);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareTuple(this.planeR, o.planeR);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareTuple(this.planeQ, o.planeQ);
        if (val != 0) {
            return val;
        }
        return 0;
    }

    public TexCoordGeneration() {
        super(false);
    }

    public TexCoordGeneration(boolean enabled) {
        this();
        this.enabled = enabled;
    }

    public TexCoordGeneration(TexCoordGenMode genMode, CoordMode format) {
        this();
        this.genMode = genMode;
        this.format = format;
    }

    public TexCoordGeneration(TexCoordGenMode genMode, CoordMode format, Vector4f planeS) {
        this(genMode, format);
        this.planeS.set((TupleNf)planeS);
    }

    public TexCoordGeneration(TexCoordGenMode genMode, CoordMode format, Vector4f planeS, Vector4f planeT) {
        this(genMode, format, planeS);
        this.planeT.set((TupleNf)planeT);
    }

    public TexCoordGeneration(TexCoordGenMode genMode, CoordMode format, Vector4f planeS, Vector4f planeT, Vector4f planeR) {
        this(genMode, format, planeS, planeT);
        this.planeR.set((TupleNf)planeR);
    }

    public TexCoordGeneration(TexCoordGenMode genMode, CoordMode format, Vector4f planeS, Vector4f planeT, Vector4f planeR, Vector4f planeQ) {
        this(genMode, format, planeS, planeT, planeR);
        this.planeQ.set((TupleNf)planeQ);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordMode {
        TEXTURE_COORDINATES_1(1, 1),
        TEXTURE_COORDINATES_2(2, 3),
        TEXTURE_COORDINATES_3(3, 7),
        TEXTURE_COORDINATES_4(4, 15);

        private final int numTUs;
        private final int bitmaks;

        public final int getNumTUs() {
            return this.numTUs;
        }

        public final int getBitMask() {
            return this.bitmaks;
        }

        public static CoordMode getFromNumber(int number) {
            switch (number) {
                case 1: {
                    return TEXTURE_COORDINATE_1;
                }
                case 2: {
                    return TEXTURE_COORDINATE_2;
                }
                case 3: {
                    return TEXTURE_COORDINATE_3;
                }
                case 4: {
                    return TEXTURE_COORDINATE_4;
                }
            }
            throw new IllegalArgumentException(number + " is not a valid TextureCoordGeneration mode.");
        }

        private CoordMode(int numTUs, int bitmaks) {
            this.numTUs = numTUs;
            this.bitmaks = bitmaks;
        }
    }
}

