/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureType;
import org.jagatoo.util.image.ImageUtility;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage;
import org.xith3d.scenegraph.TextureImage2D;

public class Texture2D
extends Texture {
    private final boolean isDrawTexture;
    private boolean hasUpdateList = false;
    private Texture2DCanvas textureCanvas = null;
    private boolean hasTextureCanvas = false;

    public final boolean isDrawTexture() {
        return this.isDrawTexture;
    }

    public void setHasUpdateList(boolean b) {
        this.hasUpdateList = b;
    }

    public final boolean hasUpdateList() {
        return this.hasUpdateList;
    }

    public final TextureImage2D getImage0() {
        if (this.getImagesCount() == 0) {
            return null;
        }
        return (TextureImage2D)super.getImage(0);
    }

    public final boolean hasTextureCanvas() {
        return this.hasTextureCanvas;
    }

    public Texture2DCanvas getTextureCanvas() {
        if (this.textureCanvas == null) {
            TextureImage2D ti0 = (TextureImage2D)this.getImage(0);
            this.textureCanvas = new Texture2DCanvas(this, ti0, this.getOriginalWidth(), this.getOriginalHeight());
            this.hasTextureCanvas = true;
        }
        return this.textureCanvas;
    }

    public void setSizeChanged() {
        super.setSizeChanged();
        if (this.getImagesCount() > 0 && this.hasTextureCanvas) {
            TextureImage2D ti0 = this.getImage0();
            ti0.fixUpdateListAfterSizeChange();
            this.textureCanvas.notifyImagesizeChanged(ti0.getOriginalWidth(), ti0.getOriginalHeight(), ti0.createGraphics2D());
        }
    }

    protected void checkImageType(TextureImage image) {
        if (!(image instanceof TextureImage2D)) {
            throw new Error("Only TextureImage2D instances can be added to a Texture2D.");
        }
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        Texture2D orgTex = (Texture2D)original;
        this.hasUpdateList = orgTex.hasUpdateList;
        this.textureCanvas = orgTex.textureCanvas;
        this.hasTextureCanvas = orgTex.hasTextureCanvas;
    }

    public Texture2D cloneNodeComponent(boolean forceDuplicate) {
        Texture2D t2d = new Texture2D(this.isDrawTexture(), this.getFormat());
        t2d.duplicateNodeComponent(this, forceDuplicate);
        return t2d;
    }

    private Texture2D(boolean isDrawTexture, TextureFormat format) {
        super(TextureType.TEXTURE_2D, format);
        this.isDrawTexture = isDrawTexture;
    }

    private Texture2D(boolean isDrawTexture, TextureFormat format, int boundaryWidth) {
        super(TextureType.TEXTURE_2D, format, boundaryWidth);
        this.isDrawTexture = isDrawTexture;
    }

    public Texture2D(TextureFormat format) {
        this(false, format);
    }

    public Texture2D(TextureFormat format, int boundaryWidth) {
        this(false, format, boundaryWidth);
    }

    public static Texture2D createDrawTexture(TextureFormat format, int width, int height, boolean strechToPowerOfTwo, boolean useByteBuffer, boolean yUp) {
        int orgWidth = width;
        int orgHeight = height;
        if (strechToPowerOfTwo) {
            width = ImageUtility.roundUpPower2(width);
            height = ImageUtility.roundUpPower2(height);
        }
        switch (format) {
            case RGBA: {
                break;
            }
            case RGB: {
                break;
            }
            case DEPTH: {
                throw new Error("Unsupported format " + (Object)((Object)format));
            }
            default: {
                throw new Error("Unsupported format " + (Object)((Object)format));
            }
        }
        Texture2D tex = new Texture2D(true, format);
        TextureImageFormat tiFormat = format.getDefaultTextureImageFormat();
        TextureImage2D ti = new TextureImage2D(tiFormat, width, height, orgWidth, orgHeight, yUp);
        ti.setReadOnly(false);
        ti.setImageData(null, width * height * ti.getPixelSize(), useByteBuffer);
        tex.setImage(0, ti);
        return tex;
    }

    public static Texture2D createDrawTexture(TextureFormat format, int width, int height, boolean useByteBuffer, boolean yUp) {
        return Texture2D.createDrawTexture(format, width, height, true, useByteBuffer, yUp);
    }

    public static Texture2D createDrawTexture(TextureFormat format, int width, int height, boolean useByteBuffer) {
        return Texture2D.createDrawTexture(format, width, height, useByteBuffer, false);
    }

    public static Texture2D createDrawTexture(TextureFormat format, int width, int height) {
        return Texture2D.createDrawTexture(format, width, height, false, false);
    }

    public static Texture2D createOfflineDrawTexture(TextureFormat format, int width, int height, boolean useByteBuffer, boolean yUp) {
        return Texture2D.createDrawTexture(format, width, height, false, useByteBuffer, yUp);
    }

    public static Texture2D createOfflineDrawTexture(TextureFormat format, int width, int height, boolean useByteBuffer) {
        return Texture2D.createOfflineDrawTexture(format, width, height, useByteBuffer, false);
    }

    public static Texture2D createOfflineDrawTexture(TextureFormat format, int width, int height) {
        return Texture2D.createOfflineDrawTexture(format, width, height, false, false);
    }
}

