/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.logging.X3DLog;

public abstract class TextureImage
extends NodeComponent
implements AbstractTextureImage {
    private final TextureImageFormat format;
    private TextureImageInternalFormat internalFormat;
    private final Dim2i size = new Dim2i();
    private final Dim2i orgSize = new Dim2i();
    private boolean hasData = true;

    protected void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    public final boolean hasData() {
        return this.hasData;
    }

    public final TextureImageFormat getFormat() {
        return this.format;
    }

    public final boolean hasAlpha() {
        return this.getFormat().hasAlpha();
    }

    public final boolean isCompressed() {
        return this.getFormat().isCompressed();
    }

    public final void setInternalFormat(TextureImageInternalFormat internalFormat) {
        block0 : switch (this.format) {
            case INTENSITY: {
                switch (internalFormat) {
                    case INTENSITY: 
                    case INTENSITY4: 
                    case INTENSITY8: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.INTENSITY;
                break;
            }
            case LUMINANCE: {
                switch (internalFormat) {
                    case LUMINANCE: 
                    case LUMINANCE4: 
                    case LUMINANCE8: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.LUMINANCE;
                break;
            }
            case ALPHA: {
                switch (internalFormat) {
                    case ALPHA: 
                    case ALPHA4: 
                    case ALPHA8: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.ALPHA;
                break;
            }
            case LUMINANCE_ALPHA: {
                switch (internalFormat) {
                    case LUM_ALPHA: 
                    case LUM4_ALPHA4: 
                    case LUM8_ALPHA8: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.LUM_ALPHA;
                break;
            }
            case RGB: {
                switch (internalFormat) {
                    case RGB: 
                    case RGB4: 
                    case RGB5: 
                    case RGB8: 
                    case R3_G3_B2: 
                    case RGB_DXT1: 
                    case RGBA_DXT1: 
                    case RGBA_DXT3: 
                    case RGBA_DXT5: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.RGB;
                break;
            }
            case RGBA: {
                switch (internalFormat) {
                    case RGBA_DXT1: 
                    case RGBA_DXT3: 
                    case RGBA_DXT5: 
                    case RGBA: 
                    case RGBA4: 
                    case RGB5_A1: 
                    case RGBA8: {
                        this.internalFormat = internalFormat;
                        break block0;
                    }
                }
                this.internalFormat = TextureImageInternalFormat.RGBA;
                break;
            }
            case RGB_DXT1: {
                this.internalFormat = TextureImageInternalFormat.RGB_DXT1;
                break;
            }
            case RGBA_DXT1: {
                this.internalFormat = TextureImageInternalFormat.RGBA_DXT1;
                break;
            }
            case RGBA_DXT3: {
                this.internalFormat = TextureImageInternalFormat.RGBA_DXT3;
                break;
            }
            case RGBA_DXT5: {
                this.internalFormat = TextureImageInternalFormat.RGBA_DXT5;
                break;
            }
            case DEPTH: {
                if (internalFormat != null) {
                    switch (internalFormat) {
                        case DEPTH16: 
                        case DEPTH24: 
                        case DEPTH32: {
                            this.internalFormat = internalFormat;
                            break block0;
                        }
                    }
                    this.internalFormat = TextureImageInternalFormat.DEPTH24;
                    break;
                }
                this.internalFormat = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data format: " + (Object)((Object)this.format));
            }
        }
    }

    public final TextureImageInternalFormat getInternalFormat() {
        return this.internalFormat;
    }

    public final boolean isInternalFormatCompressed() {
        return this.getInternalFormat().isCompressed();
    }

    protected void setSize(int width, int height) {
        this.size.set(width, height);
    }

    public final Sized2iRO getSize() {
        return this.size;
    }

    public final int getWidth() {
        return this.size.getWidth();
    }

    public final int getHeight() {
        return this.size.getHeight();
    }

    protected void setOriginalSize(int orgWidth, int orgHeight) {
        this.orgSize.set(orgWidth, orgHeight);
    }

    public Sized2iRO getOriginalSize() {
        return this.orgSize;
    }

    public int getOriginalWidth() {
        return this.orgSize.getWidth();
    }

    public int getOriginalHeight() {
        return this.orgSize.getHeight();
    }

    protected final int calculateNeededImageSize() {
        int sizeMultiplier = 0;
        switch (this.format) {
            case RGB_DXT1: 
            case RGBA_DXT1: {
                return (this.getWidth() + 3) / 4 * ((this.getHeight() + 3) / 4) * 8;
            }
            case RGBA_DXT3: 
            case RGBA_DXT5: {
                return (this.getWidth() + 3) / 4 * ((this.getHeight() + 3) / 4) * 16;
            }
            case RGB: {
                sizeMultiplier = 3;
                break;
            }
            case RGBA: {
                sizeMultiplier = 4;
                break;
            }
            case LUMINANCE_ALPHA: {
                sizeMultiplier = 2;
                break;
            }
            case INTENSITY: 
            case LUMINANCE: 
            case ALPHA: {
                sizeMultiplier = 1;
                break;
            }
            case DEPTH: {
                sizeMultiplier = 3;
                break;
            }
            default: {
                X3DLog.exception(new Object[]{"TextureImage2D.setImage(): The image object contains a value, ", this.format, ", in the format that is unknown."});
            }
        }
        return sizeMultiplier * this.getWidth() * this.getHeight();
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public TextureImage(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight, TextureImageInternalFormat internalFormat) {
        super(false);
        this.format = format;
        this.size.set(width, height);
        this.orgSize.set(orgWidth, orgHeight);
        this.setInternalFormat(internalFormat);
    }

    public TextureImage(TextureImageFormat format, int width, int height, int orgWidth, int orgHeight) {
        this(format, width, height, orgWidth, orgHeight, TextureImageInternalFormat.getFallbackInternalFormat(format));
    }
}

