/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;

public class TextureUnit
extends NodeComponent {
    private Texture texture;
    private TextureAttributes textureAttributes;
    private TexCoordGeneration texCoordGeneration;

    public void setTexture(Texture texture) {
        this.texture = texture;
        this.setChanged(true);
    }

    public final void setTexture(String texture) {
        this.setTexture(TextureLoader.getInstance().getTexture(texture));
    }

    public final Texture getTexture() {
        return this.texture;
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) {
        this.textureAttributes = textureAttributes;
        this.setChanged(true);
    }

    public final TextureAttributes getTextureAttributes() {
        return this.textureAttributes;
    }

    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        this.texCoordGeneration = texCoordGeneration;
        this.setChanged(true);
    }

    public final TexCoordGeneration getTexCoordGeneration() {
        return this.texCoordGeneration;
    }

    public void setChangedRecursive(boolean changed) {
        this.setChanged(changed);
        if (this.texture != null) {
            this.texture.setChanged(changed);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.setChanged(changed);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.setChanged(changed);
        }
    }

    public void setModListener(ScenegraphModificationsListener modListener) {
        super.setModListener(modListener);
        if (this.texture != null) {
            this.texture.setModListener(modListener);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.setModListener(modListener);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.setModListener(modListener);
        }
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        TextureUnit origTU = (TextureUnit)original;
        this.setTexture(origTU.getTexture());
        if (forceDuplicate) {
            if (origTU.getTextureAttributes() != null) {
                this.setTextureAttributes(origTU.getTextureAttributes().cloneNodeComponent(true));
            }
            if (origTU.getTexCoordGeneration() != null) {
                this.setTexCoordGeneration(origTU.getTexCoordGeneration().cloneNodeComponent(true));
            }
        } else {
            this.setTextureAttributes(origTU.getTextureAttributes());
            this.setTexCoordGeneration(origTU.getTexCoordGeneration());
        }
    }

    protected TextureUnit newInstance() {
        return new TextureUnit();
    }

    public TextureUnit cloneNodeComponent(boolean forceDuplicate) {
        TextureUnit tu = this.newInstance();
        tu.duplicateNodeComponent(this, forceDuplicate);
        return tu;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.texture != null) {
            this.texture.freeOpenGLResources(canvasPeer);
        }
        if (this.textureAttributes != null) {
            this.textureAttributes.freeOpenGLResources(canvasPeer);
        }
        if (this.texCoordGeneration != null) {
            this.texCoordGeneration.freeOpenGLResources(canvasPeer);
        }
    }

    public TextureUnit(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        super(false);
        this.setTexture(texture);
        this.setTextureAttributes(textureAttributes);
        this.setTexCoordGeneration(texCoordGeneration);
    }

    public TextureUnit(String texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this(TextureLoader.getInstance().getTexture(texture), textureAttributes, texCoordGeneration);
    }

    public TextureUnit(Texture texture, TextureAttributes textureAttributes) {
        this(texture, textureAttributes, null);
    }

    public TextureUnit(String texture, TextureAttributes textureAttributes) {
        this(texture, textureAttributes, null);
    }

    public TextureUnit(Texture texture) {
        this(texture, null, null);
    }

    public TextureUnit(String texture) {
        this(texture, null, null);
    }

    public TextureUnit() {
        this((Texture)null, null, null);
    }
}

