/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openmali.FastMath;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraphObject;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends SceneGraphObject
implements Transformable {
    public static final ProjectionPolicy PARALLEL_PROJECTION = ProjectionPolicy.PARALLEL_PROJECTION;
    public static final ProjectionPolicy PERSPECTIVE_PROJECTION = ProjectionPolicy.PERSPECTIVE_PROJECTION;
    public static final float DEFAULT_FIELD_OF_VIEW = FastMath.toRad(35.0f);
    public static final float DEFAULT_FRONT_CLIP_DISTANCE_PERSPECTIVE = 1.0f;
    public static final float DEFAULT_FRONT_CLIP_DISTANCE_PARALLEL = -1.0f;
    public static final float DEFAULT_BACK_CLIP_DISTANCE_PERSPECTIVE = 2000.0f;
    public static final float DEFAULT_BACK_CLIP_DISTANCE_PARALLEL = 100.0f;
    private final ArrayList<Canvas3D> canvasList;
    private final List<Canvas3D> unmodCanvasList;
    private ProjectionPolicy projectionPolicy = PERSPECTIVE_PROJECTION;
    private float fieldOfView = DEFAULT_FIELD_OF_VIEW;
    private float frontClipDistance;
    private float backClipDistance;
    private boolean isFrontClipSet = false;
    private boolean isBackClipSet = false;
    private float screenScale = 1.0f;
    private Tuple2f centerOfView = null;
    private RenderPassConfig[] rpcStack = new RenderPassConfig[16];
    private int rpcStackSize = 0;
    private final Transform3D transform = new Transform3D();
    private final Transform3D modelViewTransform = new Transform3D();
    private final Transform3D modelViewTransform2 = new Transform3D();
    private final Point3f position = new Point3f();
    private final Transform3D projection = new Transform3D();
    private Transform3D customProjection = null;
    private final Matrix4f projViewMatrix = new Matrix4f();
    private final Matrix3f tempMatrix = new Matrix3f();
    private final Matrix4f IDENTITY = new Matrix4f();
    private final Frustum frustum = new Frustum();
    private final Matrix3f rotMat = new Matrix3f();
    private static final Vector3f TO_BACK = Vector3f.NEGATIVE_Z_AXIS;
    private static final Vector3f TO_RIGHT = Vector3f.POSITIVE_X_AXIS;
    private static final Vector3f TO_UP = Vector3f.POSITIVE_Y_AXIS;
    private float soundActivationRadius = 40.0f;
    private PointLight attachedLight = null;

    public final void setAttachedLight(PointLight light) {
        this.attachedLight = light;
    }

    public final PointLight getAttachedLight() {
        return this.attachedLight;
    }

    public final void setProjectionPolicy(ProjectionPolicy policy) {
        this.projectionPolicy = policy;
    }

    public final ProjectionPolicy getProjectionPolicy() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || this.rpcStack[i].getProjectionPolicy() == null) continue;
                return this.rpcStack[i].getProjectionPolicy();
            }
        }
        return this.projectionPolicy;
    }

    public final void setCenterOfView(Tuple2f cov) {
        this.centerOfView = cov;
    }

    public final Tuple2f getCenterOfView() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || this.rpcStack[i].getCenterOfView() == null) continue;
                return this.rpcStack[i].getCenterOfView();
            }
        }
        return this.centerOfView;
    }

    public final void setScreenScale(float screenScale) {
        this.screenScale = screenScale;
    }

    public final float getScreenScale() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || !(this.rpcStack[i].getScreenScale() > -9998.0f)) continue;
                return this.rpcStack[i].getScreenScale();
            }
        }
        return this.screenScale;
    }

    public final void setFrontClipDistance(float value) {
        this.frontClipDistance = value;
        this.isFrontClipSet = true;
    }

    public final float getFrontClipDistance() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || !(this.rpcStack[i].getFrontClipDistance() > -9998.0f)) continue;
                return this.rpcStack[i].getFrontClipDistance();
            }
        }
        if (this.isFrontClipSet) {
            return this.frontClipDistance;
        }
        if (this.getProjectionPolicy() == ProjectionPolicy.PARALLEL_PROJECTION) {
            return -1.0f;
        }
        return 1.0f;
    }

    public final void setBackClipDistance(float value) {
        this.backClipDistance = value;
        this.isBackClipSet = true;
    }

    public final float getBackClipDistance() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || !(this.rpcStack[i].getBackClipDistance() > -9998.0f)) continue;
                return this.rpcStack[i].getBackClipDistance();
            }
        }
        if (this.isBackClipSet) {
            return this.backClipDistance;
        }
        if (this.getProjectionPolicy() == ProjectionPolicy.PARALLEL_PROJECTION) {
            return 100.0f;
        }
        return 2000.0f;
    }

    public final void setFieldOfView(float value) {
        this.fieldOfView = value;
    }

    public final float getFieldOfView() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || !(this.rpcStack[i].getFieldOfView() > -9998.0f)) continue;
                return this.rpcStack[i].getFieldOfView();
            }
        }
        return this.fieldOfView;
    }

    final void set(boolean b, RenderPassConfig rpc) {
        if (b) {
            this.rpcStack[this.rpcStackSize++] = rpc;
        } else {
            this.rpcStack[--this.rpcStackSize] = null;
        }
    }

    public final void setSoundActivationRadius(float radius) {
        this.soundActivationRadius = radius;
    }

    public final float getSoundActivationRadius() {
        return this.soundActivationRadius;
    }

    @Override
    public final void setTransform(Transform3D transform) {
        this.transform.set(transform);
    }

    @Override
    public final Transform3D getTransform() {
        if (this.rpcStackSize > 0) {
            for (int i = this.rpcStackSize - 1; i >= 0; --i) {
                if (this.rpcStack[i] == null || this.rpcStack[i].getViewTransform() == null) continue;
                return this.rpcStack[i].getViewTransform();
            }
        }
        return this.transform;
    }

    @Override
    public final void getTransform(Transform3D transform) {
        this.getTransform().get(transform);
    }

    @Override
    public void setPosition(float posX, float posY, float posZ) {
        this.getTransform().setTranslation(posX, posY, posZ);
    }

    @Override
    public final void setPosition(Tuple3f position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public final void getPosition(Tuple3f position) {
        this.getTransform().getTranslation(position);
    }

    @Override
    public final Point3f getPosition() {
        this.getTransform().getTranslation(this.position);
        return this.position;
    }

    public final void lookAt(float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ) {
        this.transform.lookAt(eyePositionX, eyePositionY, eyePositionZ, viewFocusX, viewFocusY, viewFocusZ, vecUpX, vecUpY, vecUpZ);
    }

    public final void lookAt(Tuple3f eyePosition, Tuple3f viewFocus, Tuple3f vecUp) {
        this.transform.lookAt(eyePosition, viewFocus, vecUp);
    }

    public final void lookAt(Tuple3f viewFocus) {
        this.getPosition(this.position);
        Vector3f up = Vector3f.fromPool();
        this.getUpDirection(up);
        this.lookAt(this.position, viewFocus, up);
        Vector3f.toPool(up);
    }

    public final void lookAlong(float eyePositionX, float eyePositionY, float eyePositionZ, float viewDirectionX, float viewDirectionY, float viewDirectionZ, float vecUpX, float vecUpY, float vecUpZ) {
        this.transform.lookAlong(eyePositionX, eyePositionY, eyePositionZ, viewDirectionX, viewDirectionY, viewDirectionZ, vecUpX, vecUpY, vecUpZ);
    }

    public final void lookAlong(Tuple3f eyePosition, Tuple3f viewDirection, Tuple3f vecUp) {
        this.transform.lookAlong(eyePosition, viewDirection, vecUp);
    }

    public final void lookAlong(float eyePositionX, float eyePositionY, float eyePositionZ, float viewDirectionX, float viewDirectionY, float viewDirectionZ) {
        this.transform.lookAlong(eyePositionX, eyePositionY, eyePositionZ, viewDirectionX, viewDirectionY, viewDirectionZ);
    }

    public final void lookAlong(Tuple3f eyePosition, Tuple3f viewDirection) {
        this.transform.lookAlong(eyePosition, viewDirection);
    }

    public final void setFacingDirection(Vector3f direction) {
        this.getPosition(this.position);
        Vector3f up = Vector3f.fromPool();
        this.getUpDirection(up);
        this.lookAlong(this.position, direction, up);
        Vector3f.toPool(up);
    }

    public final <T extends Tuple3f> T getFacingDirection(T direction) {
        this.transform.getRotation(this.rotMat);
        this.rotMat.mul(TO_BACK, direction);
        return direction;
    }

    public final Vector3f getFacingDirection() {
        Vector3f direction = new Vector3f();
        this.getFacingDirection(direction);
        return direction;
    }

    public final <T extends Tuple3f> T getRightDirection(T direction) {
        this.transform.getRotation(this.rotMat);
        this.rotMat.mul(TO_RIGHT, direction);
        return direction;
    }

    public final Vector3f getRightDirection() {
        Vector3f direction = new Vector3f();
        this.getRightDirection(direction);
        return direction;
    }

    public final <T extends Tuple3f> T getUpDirection(T direction) {
        this.transform.getRotation(this.rotMat);
        this.rotMat.mul(TO_UP, direction);
        return direction;
    }

    public final Vector3f getUpDirection() {
        Vector3f direction = new Vector3f();
        this.getUpDirection(direction);
        return direction;
    }

    public final Transform3D getModelViewTransform(CameraMode mode, boolean forceRecomputation) {
        if (!forceRecomputation) {
            return this.modelViewTransform;
        }
        switch (mode) {
            case VIEW_NORMAL: {
                this.modelViewTransform.set(this.getTransform());
                this.modelViewTransform.invert();
                return this.modelViewTransform;
            }
            case VIEW_FIXED_POSITION: {
                this.getTransform().getRotation(this.tempMatrix);
                this.modelViewTransform.set(this.tempMatrix);
                this.modelViewTransform.invert();
                return this.modelViewTransform;
            }
            case VIEW_FIXED: {
                this.modelViewTransform.setIdentity();
                return this.modelViewTransform;
            }
        }
        throw new AssertionError((Object)"Unknown CameraMode encountered");
    }

    public final Transform3D getModelViewTransform(boolean forceRecomputation) {
        return this.getModelViewTransform(CameraMode.VIEW_NORMAL, forceRecomputation);
    }

    public Transform3D calculatePerspective(float viewportWidth, float viewportHeight) {
        if (this.getProjectionPolicy() == ProjectionPolicy.CUSTOM_PROJECTION) {
            return this.customProjection;
        }
        Tuple2f cov = this.getCenterOfView();
        float zFar = this.getBackClipDistance();
        float zNear = this.getFrontClipDistance();
        if (this.getProjectionPolicy() == PARALLEL_PROJECTION) {
            float screenScale = this.getScreenScale();
            float aspect = viewportWidth / viewportHeight;
            this.projection.ortho(-screenScale, screenScale, -screenScale / aspect, screenScale / aspect, zNear, zFar);
            if (cov != null) {
                this.projection.getMatrix4f().add(0, 3, cov.getX() / (viewportWidth / 2.0f));
                this.projection.getMatrix4f().add(1, 3, cov.getY() / (viewportHeight / 2.0f));
            }
        } else {
            float fovy = this.getFieldOfView();
            float aspect = viewportWidth / viewportHeight;
            if (cov == null) {
                this.projection.perspectiveMesa(fovy, aspect, zNear, zFar);
            } else {
                float ymax = zNear * FastMath.tan(fovy);
                float ymin = -ymax;
                float xmin = ymin * aspect;
                float xmax = ymax * aspect;
                ymax += ymax * cov.getY();
                ymin -= ymin * cov.getY();
                xmax += xmax * cov.getX();
                xmin -= xmin * cov.getX();
                this.projection.frustumMesa(xmin, xmax, ymin, ymax, zNear, zFar);
            }
            this.projection.transpose();
        }
        return this.projection;
    }

    public final Transform3D calculatePerspective(Sized2iRO viewport) {
        return this.calculatePerspective(viewport.getWidth(), viewport.getHeight());
    }

    public void setProjection(Transform3D customProjection) {
        this.customProjection = customProjection;
        this.setProjectionPolicy(this.customProjection == null ? ProjectionPolicy.PERSPECTIVE_PROJECTION : ProjectionPolicy.CUSTOM_PROJECTION);
    }

    public final Transform3D getProjection() {
        if (this.getProjectionPolicy() == ProjectionPolicy.CUSTOM_PROJECTION) {
            return this.customProjection;
        }
        return this.projection;
    }

    public final Frustum getFrustum(float viewportWidth, float viewportHeight) {
        this.modelViewTransform2.set(this.getTransform());
        this.modelViewTransform2.invert();
        Transform3D projection = this.calculatePerspective(viewportWidth, viewportHeight);
        this.projViewMatrix.mulTransposeBoth(this.modelViewTransform2.getMatrix4f(), projection.getMatrix4f());
        this.frustum.compute(this.projViewMatrix, this.IDENTITY);
        return this.frustum;
    }

    public final Frustum getFrustum(Sized2iRO viewport) {
        return this.getFrustum(viewport.getWidth(), viewport.getHeight());
    }

    public void addCanvas3D(Canvas3D canvas3D) {
        canvas3D.setView(this);
        this.canvasList.add(canvas3D);
    }

    public final void addCanvas3D(Canvas3D canvas, int index) {
        canvas.setView(this);
        this.canvasList.add(canvas);
    }

    public final Canvas3D removeCanvas3D(int index) {
        Canvas3D removedCanvas = this.canvasList.remove(index);
        removedCanvas.setView(null);
        return removedCanvas;
    }

    public void removeCanvas3D(Canvas3D canvas) {
        this.canvasList.remove(canvas);
    }

    public final Canvas3D getCanvas3D(int index) {
        return this.canvasList.get(index);
    }

    public final int indexOfCanvas3D(Canvas3D canvas) {
        return this.canvasList.indexOf(canvas);
    }

    public final int numCanvas3Ds() {
        return this.canvasList.size();
    }

    public final List<Canvas3D> getCanvas3Ds() {
        return this.unmodCanvasList;
    }

    public View(float eyePositionX, float eyePositionY, float eyePositionZ, float viewFocusX, float viewFocusY, float viewFocusZ, float vecUpX, float vecUpY, float vecUpZ) {
        this.IDENTITY.setIdentity();
        this.lookAt(eyePositionX, eyePositionY, eyePositionZ, viewFocusX, viewFocusY, viewFocusZ, vecUpX, vecUpY, vecUpZ);
        this.canvasList = new ArrayList();
        this.unmodCanvasList = Collections.unmodifiableList(this.canvasList);
    }

    public View(Tuple3f eyePosition, Tuple3f viewFocus, Tuple3f vecUp) {
        this(eyePosition.getX(), eyePosition.getY(), eyePosition.getZ(), viewFocus.getX(), viewFocus.getY(), viewFocus.getZ(), vecUp.getX(), vecUp.getY(), vecUp.getZ());
    }

    public View() {
        this(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectionPolicy {
        PARALLEL_PROJECTION,
        PERSPECTIVE_PROJECTION,
        CUSTOM_PROJECTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CameraMode {
        VIEW_NORMAL,
        VIEW_FIXED,
        VIEW_FIXED_POSITION;

    }
}

