/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.GeomFactory;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class Box
extends Shape3D {
    private static GeometryType geomConstructTypeHint = GeometryType.TRIANGLE_ARRAY;

    public static void setGeometryConstructionTypeHint(GeometryType hint) {
        switch (hint) {
            case TRIANGLE_ARRAY: {
                geomConstructTypeHint = hint;
                break;
            }
            default: {
                throw new UnsupportedOperationException("A " + Box.class.getSimpleName() + " can only by constructed of " + GeometryType.TRIANGLE_ARRAY.getCorrespondingClass().getSimpleName());
            }
        }
    }

    public static GeometryType getGeometryConstructionTypeHint() {
        return geomConstructTypeHint;
    }

    public static GeometryConstruct createGeometryConstructTA(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        Tuple3f[] vertices = null;
        Vector3f[] normals = null;
        TexCoord2f[] texCoords2f = null;
        TexCoord3f[] texCoords3f = null;
        Colorf[] colors = null;
        float halfX = sizeX / 2.0f;
        float halfY = sizeY / 2.0f;
        float halfZ = sizeZ / 2.0f;
        vertices = new Point3f[]{new Point3f(-halfX, halfY, halfZ), new Point3f(halfX, halfY, halfZ), new Point3f(halfX, halfY, -halfZ), new Point3f(halfX, halfY, -halfZ), new Point3f(-halfX, halfY, -halfZ), new Point3f(-halfX, halfY, halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(halfX, halfY, halfZ), new Point3f(-halfX, halfY, halfZ), new Point3f(-halfX, halfY, halfZ), new Point3f(-halfX, -halfY, halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(halfX, halfY, -halfZ), new Point3f(halfX, halfY, halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(halfX, -halfY, -halfZ), new Point3f(halfX, halfY, -halfZ), new Point3f(-halfX, -halfY, halfZ), new Point3f(-halfX, halfY, halfZ), new Point3f(-halfX, halfY, -halfZ), new Point3f(-halfX, halfY, -halfZ), new Point3f(-halfX, -halfY, -halfZ), new Point3f(-halfX, -halfY, halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(-halfX, -halfY, halfZ), new Point3f(-halfX, -halfY, -halfZ), new Point3f(-halfX, -halfY, -halfZ), new Point3f(halfX, -halfY, -halfZ), new Point3f(halfX, -halfY, halfZ), new Point3f(halfX, halfY, -halfZ), new Point3f(halfX, -halfY, -halfZ), new Point3f(-halfX, -halfY, -halfZ), new Point3f(-halfX, -halfY, -halfZ), new Point3f(-halfX, halfY, -halfZ), new Point3f(halfX, halfY, -halfZ)};
        if (offsetX != 0.0f || offsetY != 0.0f || offsetZ != 0.0f) {
            StaticTransform.translate(vertices, offsetX, offsetY, offsetZ);
        }
        if ((features & 2) > 0) {
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f down = new Vector3f(0.0f, -1.0f, 0.0f);
            Vector3f right = new Vector3f(-1.0f, 0.0f, 0.0f);
            Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
            Vector3f back = new Vector3f(0.0f, 0.0f, 1.0f);
            normals = new Vector3f[]{new Vector3f(up), new Vector3f(up), new Vector3f(up), new Vector3f(up), new Vector3f(up), new Vector3f(up), new Vector3f(back), new Vector3f(back), new Vector3f(back), new Vector3f(back), new Vector3f(back), new Vector3f(back), new Vector3f(left), new Vector3f(left), new Vector3f(left), new Vector3f(left), new Vector3f(left), new Vector3f(left), new Vector3f(right), new Vector3f(right), new Vector3f(right), new Vector3f(right), new Vector3f(right), new Vector3f(right), new Vector3f(down), new Vector3f(down), new Vector3f(down), new Vector3f(down), new Vector3f(down), new Vector3f(down), new Vector3f(front), new Vector3f(front), new Vector3f(front), new Vector3f(front), new Vector3f(front), new Vector3f(front)};
        }
        if ((features & 8) != 0 && texCoordsSize == 2) {
            texCoords2f = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f)};
        }
        if ((features & 8) != 0 && texCoordsSize == 3) {
            texCoords3f = new TexCoord3f[]{new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(1.0f, 0.0f, 0.5f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(1.0f, 1.0f, 1.0f), new TexCoord3f(0.0f, 1.0f, 0.5f), new TexCoord3f(0.0f, 0.0f, 0.0f)};
        }
        if ((features & 4) != 0) {
            colors = new Colorf[]{new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f), new Colorf(1.0f, 0.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 1.0f, 0.0f), new Colorf(0.0f, 0.0f, 1.0f), new Colorf(1.0f, 1.0f, 1.0f)};
            if (colorAlpha) {
                for (int i = 0; i < colors.length; ++i) {
                    colors[i].setAlpha(0.0f);
                }
            }
        }
        if (texCoords3f != null) {
            return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, vertices, normals, texCoords3f, colors);
        }
        return new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, vertices, normals, texCoords2f, colors);
    }

    public static GeometryConstruct createGeometryConstructTA(float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        return Box.createGeometryConstructTA(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
    }

    public static TriangleArray createGeometryTA(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        GeometryConstruct gc = Box.createGeometryConstructTA(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
        return GeomFactory.createTriangleArray(gc);
    }

    public static Geometry createGeometry(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        switch (Box.getGeometryConstructionTypeHint()) {
            case TRIANGLE_ARRAY: {
                return Box.createGeometryTA(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
            }
        }
        throw new Error(Box.getGeometryConstructionTypeHint().getCorrespondingClass().getSimpleName() + " creation is not yet implemented.");
    }

    public static Geometry createGeometry(float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        return Box.createGeometry(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
    }

    public Box(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        super.setGeometry(Box.createGeometry(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize));
    }

    public Box(Tuple3f offset, float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        this(offset.getX(), offset.getY(), offset.getZ(), sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
    }

    public Box(float sizeX, float sizeY, float sizeZ, int features, boolean colorAlpha, int texCoordsSize) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, features, colorAlpha, texCoordsSize);
    }

    public Box(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, Texture texture) {
        this(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Box(Tuple3f offset, float sizeX, float sizeY, float sizeZ, Texture texture) {
        this(offset, sizeX, sizeY, sizeZ, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public Box(float sizeX, float sizeY, float sizeZ, Texture texture) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, texture);
    }

    public Box(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, String texture) {
        this(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, TextureLoader.getInstance().getTexture(texture));
    }

    public Box(Tuple3f offset, float sizeX, float sizeY, float sizeZ, String texture) {
        this(offset, sizeX, sizeY, sizeZ, TextureLoader.getInstance().getTexture(texture));
    }

    public Box(float sizeX, float sizeY, float sizeZ, String texture) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, texture);
    }

    public Box(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, Colorf color) {
        this(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Box(Tuple3f offset, float sizeX, float sizeY, float sizeZ, Colorf color) {
        this(offset, sizeX, sizeY, sizeZ, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public Box(float sizeX, float sizeY, float sizeZ, Colorf color) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, color);
    }

    public Box(float offsetX, float offsetY, float offsetZ, float sizeX, float sizeY, float sizeZ, Appearance app) {
        this(offsetX, offsetY, offsetZ, sizeX, sizeY, sizeZ, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Box(Tuple3f offset, float sizeX, float sizeY, float sizeZ, Appearance app) {
        this(offset, sizeX, sizeY, sizeZ, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }

    public Box(float sizeX, float sizeY, float sizeZ, Appearance app) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, app);
    }

    public static final Box createFromBoxBody(org.openmali.spatial.bodies.Box box, int features, boolean colorAlpha, int texCoordsSize) {
        return new Box(box.getCenterX(), box.getCenterY(), box.getCenterZ(), box.getSize().getX(), box.getSize().getY(), box.getSize().getZ(), features, colorAlpha, texCoordsSize);
    }

    public static final Box createFromBoxBody(org.openmali.spatial.bodies.Box box, Texture texture) {
        return new Box(box.getCenterX(), box.getCenterY(), box.getCenterZ(), box.getSize().getX(), box.getSize().getY(), box.getSize().getZ(), texture);
    }

    public static final Box createFromBoxBody(org.openmali.spatial.bodies.Box box, String texture) {
        return new Box(box.getCenterX(), box.getCenterY(), box.getCenterZ(), box.getSize().getX(), box.getSize().getY(), box.getSize().getZ(), texture);
    }

    public static final Box createFromBoxBody(org.openmali.spatial.bodies.Box box, Colorf color) {
        return new Box(box.getCenterX(), box.getCenterY(), box.getCenterZ(), box.getSize().getX(), box.getSize().getY(), box.getSize().getZ(), color);
    }

    public static final Box createFromBoxBody(org.openmali.spatial.bodies.Box box, Appearance app) {
        return new Box(box.getCenterX(), box.getCenterY(), box.getCenterZ(), box.getSize().getX(), box.getSize().getY(), box.getSize().getZ(), app);
    }
}

