/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.FaceCullMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.primitives.Rectangle;

public class DrawRectangle
extends Rectangle {
    private boolean allowBiggerTexture = false;

    public void setAllowBiggerTexture(boolean allow) {
        this.allowBiggerTexture = allow;
    }

    public final boolean getAllowBiggerTexture() {
        return this.allowBiggerTexture;
    }

    public Texture2D getTexture() {
        return (Texture2D)this.getAppearance().getTexture();
    }

    public final Texture2DCanvas getTextureCanvas() {
        return this.getTexture().getTextureCanvas();
    }

    public boolean resize(float width, float height, float xOffset, float yOffset, float zOffset) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return false;
        }
        if (!super.resize(width, height, xOffset, yOffset, zOffset)) {
            return false;
        }
        int texWidth = Math.max(1, (int)Math.ceil(width));
        int texHeight = Math.max(1, (int)Math.ceil(height));
        Texture2D texture = this.getTexture();
        TextureImage2D ti0 = texture.getImage0();
        if (ti0.initImageData(texWidth, texHeight, this.allowBiggerTexture)) {
            texture.setSizeChanged();
        } else if (texture.hasTextureCanvas()) {
            texture.getTextureCanvas().notifyImagesizeChanged(ti0.getOriginalWidth(), ti0.getOriginalHeight(), null);
        }
        Tuple2f tmpTC = Tuple2f.fromPool();
        ti0.getTextureCoordinateUR(tmpTC);
        this.setTexturePosition(tmpTC);
        Tuple2f.toPool(tmpTC);
        return true;
    }

    private static Texture2D createDrawTexture(int width, int height, boolean withAlpha, boolean useByteBuffer) {
        TextureFormat format = withAlpha ? TextureFormat.RGBA : TextureFormat.RGB;
        width = Math.max(1, width);
        height = Math.max(1, height);
        Texture2D texture = Texture2D.createDrawTexture(format, width, height, useByteBuffer);
        return texture;
    }

    public DrawRectangle(float width, float height, boolean generateNormals, boolean withAlpha, boolean useByteBuffer) {
        super(width, height, generateNormals, Rectangle.ZeroPointLocation.TOP_LEFT, (Texture)DrawRectangle.createDrawTexture((int)width, (int)height, withAlpha, useByteBuffer));
        this.getAppearance().getPolygonAttributes(true).setFaceCullMode(FaceCullMode.BACK);
        Tuple2f tmpTC = Tuple2f.fromPool();
        this.getTexture().getImage0().getTextureCoordinateUR(tmpTC);
        this.setTexturePosition(tmpTC);
        Tuple2f.toPool(tmpTC);
    }

    public DrawRectangle(float width, float height, boolean withAlpha, boolean useByteBuffer) {
        this(width, height, false, withAlpha, useByteBuffer);
    }

    public DrawRectangle(float width, float height, boolean useByteBuffer) {
        this(width, height, false, true, useByteBuffer);
    }
}

