/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.primitives.GeomFactory;

public class GeoEllipsoid
extends Shape3D {
    public static void geodesate(Vector3f a, Vector3f b, Vector3f c, int N, int offset, Vector3f[] vertices) {
        Vector3f[][] buffer = new Vector3f[2][N + 1];
        buffer[0][0] = new Vector3f(a);
        for (int i = 0; i < N; ++i) {
            int top = i % 2;
            int bottom = (i + 1) % 2;
            buffer[bottom][0] = new Vector3f();
            buffer[bottom][0].setX((float)(N - i - 1) * a.getX() + (float)(i + 1) * b.getX());
            buffer[bottom][0].setY((float)(N - i - 1) * a.getY() + (float)(i + 1) * b.getY());
            buffer[bottom][0].setZ((float)(N - i - 1) * a.getZ() + (float)(i + 1) * b.getZ());
            buffer[bottom][0].normalize();
            for (int j = 0; j <= i; ++j) {
                buffer[bottom][j + 1] = new Vector3f();
                buffer[bottom][j + 1].setX((float)(N - i - 1) * a.getX() + (float)(i - j) * b.getX() + (float)(j + 1) * c.getX());
                buffer[bottom][j + 1].setY((float)(N - i - 1) * a.getY() + (float)(i - j) * b.getY() + (float)(j + 1) * c.getY());
                buffer[bottom][j + 1].setZ((float)(N - i - 1) * a.getZ() + (float)(i - j) * b.getZ() + (float)(j + 1) * c.getZ());
                buffer[bottom][j + 1].normalize();
                vertices[offset++] = buffer[top][j];
                vertices[offset++] = buffer[bottom][j];
                vertices[offset++] = buffer[bottom][j + 1];
                if (j >= i) continue;
                vertices[offset++] = buffer[top][j];
                vertices[offset++] = buffer[bottom][j + 1];
                vertices[offset++] = buffer[top][j + 1];
            }
        }
    }

    public GeoEllipsoid(float rx, float ry, float rz, int N, int features, boolean colorAlpha, int texCoordsSize) {
        if (N < 0) {
            throw new IllegalArgumentException("requires N>=0");
        }
        features |= 1;
        Vector3f[] coords = new Vector3f[60 * N * N];
        for (int i = 0; i < 5; ++i) {
            Vector3f a = new Vector3f(0.0f, 0.0f, 1.0f);
            Vector3f b = new Vector3f();
            b.setX(FastMath.cos((float)i * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            b.setY(FastMath.sin((float)i * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            b.setZ(FastMath.cos(1.0471976f));
            Vector3f c = new Vector3f();
            c.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setY(FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setZ(FastMath.cos(1.0471976f));
            GeoEllipsoid.geodesate(a, b, c, N, 3 * (4 * i + 0) * N * N, coords);
            a = new Vector3f();
            a.setX(FastMath.cos((float)i * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            a.setY(FastMath.sin((float)i * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            a.setZ(FastMath.cos(1.0471976f));
            b = new Vector3f();
            b.setX(FastMath.cos((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            b.setY(FastMath.sin((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            b.setZ(FastMath.cos(2.0943952f));
            c = new Vector3f();
            c.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setY(FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setZ(FastMath.cos(1.0471976f));
            GeoEllipsoid.geodesate(a, b, c, N, 3 * (4 * i + 1) * N * N, coords);
            a = new Vector3f();
            a.setX(FastMath.cos((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            a.setY(FastMath.sin((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            a.setZ(FastMath.cos(2.0943952f));
            b = new Vector3f();
            b.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            b.setY(FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            b.setZ(FastMath.cos(2.0943952f));
            c = new Vector3f();
            c.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setY(FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / 5.0f) * FastMath.sin(1.0471976f));
            c.setZ(FastMath.cos(1.0471976f));
            GeoEllipsoid.geodesate(a, b, c, N, 3 * (4 * i + 2) * N * N, coords);
            a = new Vector3f();
            a.setX(FastMath.cos((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            a.setY(FastMath.sin((float)i * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            a.setZ(FastMath.cos(2.0943952f));
            b = new Vector3f(0.0f, 0.0f, -1.0f);
            c = new Vector3f();
            c.setX(FastMath.cos((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            c.setY(FastMath.sin((float)(i + 1) * ((float)Math.PI * 2) / 5.0f + 0.62831855f) * FastMath.sin(2.0943952f));
            c.setZ(FastMath.cos(2.0943952f));
            GeoEllipsoid.geodesate(a, b, c, N, 3 * (4 * i + 3) * N * N, coords);
        }
        Tuple3f[] vertices = new Point3f[coords.length];
        Colorf[] colors = null;
        if ((features & 4) != 0) {
            colors = new Colorf[vertices.length];
        }
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = new Point3f(coords[i]);
            vertices[i].mul(rx, ry, rz);
            colors[i] = colors != null && colorAlpha ? new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ(), 0.0f) : new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ());
        }
        TriangleArray geom = new TriangleArray(vertices.length);
        geom.makeInterleaved(features, colorAlpha, new int[]{texCoordsSize}, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        if (colors != null) {
            geom.setColors(0, colors);
        }
        super.setGeometry(geom);
    }

    public GeoEllipsoid(float rx, float ry, float rz, int N, Texture texture) {
        this(rx, ry, rz, N, 11, false, 2);
        this.getAppearance(true).setTexture(texture);
    }

    public GeoEllipsoid(float rx, float ry, float rz, int N, String texture) {
        this(rx, ry, rz, N, TextureLoader.getInstance().getTexture(texture));
    }

    public GeoEllipsoid(float rx, float ry, float rz, int N, Colorf color) {
        this(rx, ry, rz, N, 3, false, 2);
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
        if (color.hasAlpha()) {
            this.getAppearance(true).getTransparencyAttributes(true).setTransparency(color.getAlpha());
        }
    }

    public GeoEllipsoid(float rx, float ry, float rz, int N, Appearance app) {
        this(rx, ry, rz, N, 3 | GeomFactory.getFeaturesFromAppearance(app), false, GeomFactory.getTexCoordsSize(app));
        this.setAppearance(app);
    }
}

