/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.TextureImage3D;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.GeometryConstruct;
import org.xith3d.scenegraph.primitives.GeometryType;

public class GeomFactory {
    public static void reverseWinding(Geometry ga) {
        float[] coords = ga.getCoordinatesData().getData();
        for (int i = 0; i < coords.length / 9; ++i) {
            int j = i * 9;
            float tempx = coords[j + 6];
            float tempy = coords[j + 7];
            float tempz = coords[j + 8];
            coords[j + 6] = coords[j + 0];
            coords[j + 7] = coords[j + 1];
            coords[j + 8] = coords[j + 2];
            coords[j + 0] = tempx;
            coords[j + 1] = tempy;
            coords[j + 2] = tempz;
        }
        ga.setCoordinate(0, coords);
    }

    public static int getFeaturesFromAppearance(Appearance app) {
        int features = 0;
        if (app == null) {
            return features;
        }
        if (app.getTexture() != null) {
            features = app.getTexture().getImage(0) instanceof TextureImage3D ? (features |= 8) : (features |= 8);
        }
        return features;
    }

    public static int getTexCoordsSize(Appearance app) {
        if (app.getTexture() != null) {
            if (app.getTexture().getImage(0) instanceof TextureImage3D) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public static Vector3f[] generateNaiveNormals(Tuple3f[] vertices) {
        Vector3f[] normals = new Vector3f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            normals[i] = new Vector3f(vertices[i]);
            normals[i].normalize();
        }
        return normals;
    }

    private static void generateNaiveNormals(Tuple3f[] vertices, Geometry trg) {
        Vector3f normal = new Vector3f();
        for (int i = 0; i < vertices.length; ++i) {
            normal.set((TupleNf)vertices[i]);
            normal.normalize();
            trg.setNormal(i, normal);
        }
    }

    public static TexCoord2f[] generateTexCoords2(Tuple3f[] vertices) {
        float zmin = Float.MAX_VALUE;
        float zmax = Float.MIN_VALUE;
        for (int i = 0; i < vertices.length; ++i) {
            zmin = Math.min(zmin, vertices[i].getZ());
            zmax = Math.max(zmax, vertices[i].getZ());
        }
        float zscale = 1.0f / (zmax - zmin);
        TexCoord2f[] texCoords = new TexCoord2f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            texCoords[i] = new TexCoord2f();
            texCoords[i].setS((FastMath.atan2(vertices[i].getY(), vertices[i].getX()) + (float)Math.PI) / ((float)Math.PI * 2));
            texCoords[i].setT(zscale * (vertices[i].getZ() - zmin));
        }
        return texCoords;
    }

    public static TexCoord3f[] generateTexCoords3(Tuple3f[] vertices) {
        float zmin = Float.MAX_VALUE;
        float zmax = Float.MIN_VALUE;
        for (int i = 0; i < vertices.length; ++i) {
            zmin = Math.min(zmin, vertices[i].getZ());
            zmax = Math.max(zmax, vertices[i].getZ());
        }
        float zscale = 1.0f / (zmax - zmin);
        TexCoord3f[] texCoords = new TexCoord3f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            texCoords[i] = new TexCoord3f();
            texCoords[i].setS((FastMath.atan2(vertices[i].getY(), vertices[i].getX()) + (float)Math.PI) / ((float)Math.PI * 2));
            texCoords[i].setT(zscale * (vertices[i].getZ() - zmin));
            texCoords[i].setP(0.0f);
        }
        return texCoords;
    }

    public static Colorf[] generateColors(boolean alpha, Tuple3f[] coords) {
        Colorf[] colors = new Colorf[coords.length];
        float xmin = Float.MAX_VALUE;
        float xmax = -3.4028235E38f;
        float ymin = Float.MAX_VALUE;
        float ymax = -3.4028235E38f;
        float zmin = Float.MAX_VALUE;
        float zmax = -3.4028235E38f;
        for (int i = 0; i < coords.length; ++i) {
            colors[i] = alpha ? new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ(), 0.0f) : new Colorf(coords[i].getX(), coords[i].getY(), coords[i].getZ());
            xmin = Math.min(xmin, coords[i].getX());
            xmax = Math.max(xmax, coords[i].getX());
            ymin = Math.min(ymin, coords[i].getY());
            ymax = Math.max(ymax, coords[i].getY());
            zmin = Math.min(zmin, coords[i].getZ());
            zmax = Math.max(zmax, coords[i].getZ());
        }
        float scaleX = xmax == xmin ? 1.0f : 1.0f / (xmax - xmin);
        float scaleY = ymax == ymin ? 1.0f : 1.0f / (ymax - ymin);
        float scaleZ = zmax == zmin ? 1.0f : 1.0f / (zmax - zmin);
        for (int i = 0; i < colors.length; ++i) {
            colors[i].setRed((colors[i].getRed() + xmin) * scaleX);
            colors[i].setGreen((colors[i].getGreen() + ymin) * scaleY);
            colors[i].setBlue((colors[i].getBlue() + zmin) * scaleZ);
        }
        return colors;
    }

    public static TriangleArray createFullFeaturedTriangleArray(Tuple3f[] vertices, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, int features, boolean colorAlpha, int texCoordsSize) {
        TriangleArray geom = new TriangleArray(vertices.length);
        geom.setCoordinates(0, vertices);
        if (normals != null) {
            geom.setNormals(0, normals);
        } else if ((features & 2) > 0) {
            GeomFactory.generateNaiveNormals(vertices, geom);
        }
        if (colors != null) {
            geom.setColors(0, colors);
        } else if ((features & 4) != 0 && !colorAlpha) {
            colors = new Colorf[vertices.length];
            for (int i = 0; i < vertices.length; ++i) {
                colors[i] = new Colorf(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ());
                colors[i].mul(2.0f);
            }
            geom.setColors(0, colors);
        } else if ((features & 4) != 0 && colorAlpha) {
            colors = new Colorf[vertices.length];
            for (int i = 0; i < vertices.length; ++i) {
                colors[i] = new Colorf(vertices[i].getX(), vertices[i].getY(), vertices[i].getZ(), 0.0f);
                colors[i].mul(2.0f);
            }
            geom.setColors(0, colors);
        }
        if (texCoords2 != null) {
            geom.setTextureCoordinates(0, 0, texCoords2);
        } else if ((features & 8) > 0 && texCoordsSize == 2) {
            geom.setTextureCoordinates(0, 0, GeomFactory.generateTexCoords2(vertices));
        }
        return geom;
    }

    protected static TriangleArray createFullFeaturedTriangleArray(GeometryConstruct[] geoms) {
        int i;
        int i2;
        int i3;
        int numVertices = 0;
        for (int i4 = 0; i4 < geoms.length; ++i4) {
            numVertices += geoms[i4].getCoordinates().length;
        }
        Tuple3f[] vertices = new Tuple3f[numVertices];
        int k = 0;
        for (i3 = 0; i3 < geoms.length; ++i3) {
            Tuple3f[] vs = geoms[i3].getCoordinates();
            for (int j = 0; j < vs.length; ++j) {
                vertices[k++] = vs[j];
            }
        }
        int numNormals = 0;
        for (i3 = 0; i3 < geoms.length; ++i3) {
            if (geoms[i3].getNormals() == null) continue;
            numNormals += geoms[i3].getNormals().length;
        }
        Vector3f[] normals = null;
        if (numNormals > 0) {
            normals = new Vector3f[numVertices];
            int k2 = 0;
            for (i2 = 0; i2 < geoms.length; ++i2) {
                int j;
                Vector3f[] ns = geoms[i2].getNormals();
                if (ns == null) {
                    for (j = 0; j < geoms[i2].getCoordinates().length; ++j) {
                        normals[k2++] = new Vector3f(geoms[i2].getCoordinates()[j]);
                        normals[k2++].normalize();
                    }
                    continue;
                }
                for (j = 0; j < geoms[i2].getCoordinates().length; ++j) {
                    normals[k2++] = ns[j];
                }
            }
        }
        int numTexCoords2 = 0;
        for (i2 = 0; i2 < geoms.length; ++i2) {
            if (geoms[i2].getTextureCoordinates2f() == null) continue;
            numTexCoords2 += geoms[i2].getTextureCoordinates2f().length;
        }
        TexCoord2f[] texCoords2 = null;
        if (numTexCoords2 > 0) {
            texCoords2 = new TexCoord2f[numVertices];
            int k3 = 0;
            for (i = 0; i < geoms.length; ++i) {
                TexCoord2f[] ts = geoms[i].getTextureCoordinates2f();
                if (ts == null) {
                    ts = GeomFactory.generateTexCoords2(vertices);
                }
                for (int j = 0; j < geoms[i].getCoordinates().length; ++j) {
                    texCoords2[k3++] = ts[j];
                }
            }
        }
        int numTexCoords3 = 0;
        for (i = 0; i < geoms.length; ++i) {
            if (geoms[i].getTextureCoordinates2f() == null) continue;
            numTexCoords3 += geoms[i].getTextureCoordinates2f().length;
        }
        TexCoord3f[] texCoords3 = null;
        if (numTexCoords3 > 0) {
            texCoords3 = new TexCoord3f[numVertices];
            int k4 = 0;
            for (int i5 = 0; i5 < geoms.length; ++i5) {
                TexCoord3f[] ts = geoms[i5].getTextureCoordinates3f();
                if (ts == null) {
                    ts = GeomFactory.generateTexCoords3(vertices);
                }
                for (int j = 0; j < geoms[i5].getCoordinates().length; ++j) {
                    texCoords3[k4++] = ts[j];
                }
            }
        }
        int numColors = 0;
        boolean alphaColors = false;
        for (int i6 = 0; i6 < geoms.length; ++i6) {
            if (geoms[i6].getColors() == null) continue;
            numColors += geoms[i6].getColors().length;
            alphaColors = geoms[i6].getColors()[0] != null && geoms[i6].getColors()[0].hasAlpha();
        }
        Colorf[] colors = null;
        if (numColors > 0) {
            colors = new Colorf[numVertices];
            int k5 = 0;
            for (int i7 = 0; i7 < geoms.length; ++i7) {
                Colorf[] cs = geoms[i7].getColors();
                if (cs == null) {
                    cs = GeomFactory.generateColors(alphaColors, vertices);
                }
                for (int j = 0; j < geoms[i7].getCoordinates().length; ++j) {
                    colors[k5++] = cs[j];
                }
            }
        }
        return GeomFactory.createTriangleArray(vertices, normals, colors, texCoords2, texCoords3);
    }

    protected static int calculateFeatures(Tuple3f[] coords, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, TexCoord3f[] texCoords3) {
        int features = 1;
        if (normals != null) {
            features |= 2;
        }
        if (texCoords2 != null || texCoords3 != null) {
            features |= 8;
        }
        if (colors != null) {
            features |= 4;
        }
        return features;
    }

    public static TriangleArray createTriangleArray(Tuple3f[] vertices, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, TexCoord3f[] texCoords3) {
        boolean colorAlpha;
        int features = GeomFactory.calculateFeatures(vertices, normals, colors, texCoords2, texCoords3);
        boolean bl = colorAlpha = colors != null ? colors[0].hasAlpha() : false;
        int[] texCoordsSizes = texCoords2 != null ? new int[]{2} : (texCoords3 != null ? new int[]{3} : null);
        TriangleArray geom = new TriangleArray(vertices.length);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        if (normals != null) {
            geom.setNormals(0, normals);
        }
        if (texCoords2 != null) {
            geom.setTextureCoordinates(0, 0, texCoords2);
        }
        if (texCoords3 != null) {
            geom.setTextureCoordinates(0, 0, texCoords3);
        }
        if (colors != null) {
            geom.setColors(0, colors);
        }
        return geom;
    }

    public static TriangleArray createTriangleArray(GeometryConstruct geomConstruct) {
        if (geomConstruct.getGeometryTypeHint() != GeometryType.TRIANGLE_ARRAY) {
            throw new IllegalArgumentException("The GeometryConstruct is not made " + geomConstruct.getGeometryTypeHint().getCorrespondingClass().getSimpleName() + ", but " + GeometryType.TRIANGLE_ARRAY.getCorrespondingClass().getSimpleName() + " is expected.");
        }
        return GeomFactory.createTriangleArray(geomConstruct.getCoordinates(), geomConstruct.getNormals(), geomConstruct.getColors(), geomConstruct.getTextureCoordinates2f(), geomConstruct.getTextureCoordinates3f());
    }

    public static IndexedTriangleArray createIndexedTriangleArray(Tuple3f[] vertices, int[] indices, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, TexCoord3f[] texCoords3) {
        boolean colorAlpha;
        int features = GeomFactory.calculateFeatures(vertices, normals, colors, texCoords2, texCoords3);
        boolean bl = colorAlpha = colors != null ? colors[0].hasAlpha() : false;
        int[] texCoordsSizes = texCoords2 != null ? new int[]{2} : (texCoords3 != null ? new int[]{3} : null);
        IndexedTriangleArray geom = new IndexedTriangleArray(vertices.length, indices.length);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        geom.setIndex(indices);
        if (normals != null) {
            geom.setNormals(0, normals);
        }
        if (texCoords2 != null) {
            geom.setTextureCoordinates(0, 0, texCoords2);
        }
        if (texCoords3 != null) {
            geom.setTextureCoordinates(0, 0, texCoords3);
        }
        if (colors != null) {
            geom.setColors(0, colors);
        }
        return geom;
    }

    public static IndexedTriangleArray createIndexedTriangleArray(GeometryConstruct geomConstruct) {
        if (geomConstruct.getGeometryTypeHint() != GeometryType.INDEXED_TRIANGLE_ARRAY) {
            throw new IllegalArgumentException("The GeometryConstruct is not made " + geomConstruct.getGeometryTypeHint().getCorrespondingClass().getSimpleName() + ", but " + GeometryType.INDEXED_TRIANGLE_ARRAY.getCorrespondingClass().getSimpleName() + " is expected.");
        }
        return GeomFactory.createIndexedTriangleArray(geomConstruct.getCoordinates(), geomConstruct.getIndices(), geomConstruct.getNormals(), geomConstruct.getColors(), geomConstruct.getTextureCoordinates2f(), geomConstruct.getTextureCoordinates3f());
    }

    public static TriangleStripArray createTriangleStripArray(Tuple3f[] vertices, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, TexCoord3f[] texCoords3, int[] stripLengths) {
        boolean colorAlpha;
        int features = GeomFactory.calculateFeatures(vertices, normals, colors, texCoords2, texCoords3);
        boolean bl = colorAlpha = colors != null ? colors[0].hasAlpha() : false;
        int[] texCoordsSizes = texCoords2 != null ? new int[]{2} : (texCoords3 != null ? new int[]{3} : null);
        TriangleStripArray geom = new TriangleStripArray(vertices.length, stripLengths);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        if (normals != null) {
            geom.setNormals(0, normals);
        }
        if (texCoords2 != null) {
            geom.setTextureCoordinates(0, 0, texCoords2);
        }
        if (texCoords3 != null) {
            geom.setTextureCoordinates(0, 0, texCoords3);
        }
        if (colors != null) {
            geom.setColors(0, colors);
        }
        return geom;
    }

    public static TriangleStripArray createTriangleStripArray(GeometryConstruct geomConstruct) {
        if (geomConstruct.getGeometryTypeHint() != GeometryType.TRIANGLE_STRIP_ARRAY) {
            throw new IllegalArgumentException("The GeometryConstruct is not made " + geomConstruct.getGeometryTypeHint().getCorrespondingClass().getSimpleName() + ", but " + GeometryType.TRIANGLE_STRIP_ARRAY.getCorrespondingClass().getSimpleName() + " is expected.");
        }
        return GeomFactory.createTriangleStripArray(geomConstruct.getCoordinates(), geomConstruct.getNormals(), geomConstruct.getColors(), geomConstruct.getTextureCoordinates2f(), geomConstruct.getTextureCoordinates3f(), geomConstruct.getStripLengths());
    }

    public static IndexedTriangleStripArray createIndexedTriangleStripArray(Tuple3f[] vertices, int[] indices, Vector3f[] normals, Colorf[] colors, TexCoord2f[] texCoords2, TexCoord3f[] texCoords3, int[] stripLengths) {
        boolean colorAlpha;
        int features = GeomFactory.calculateFeatures(vertices, normals, colors, texCoords2, texCoords3);
        boolean bl = colorAlpha = colors != null ? colors[0].hasAlpha() : false;
        int[] texCoordsSizes = texCoords2 != null ? new int[]{2} : (texCoords3 != null ? new int[]{3} : null);
        IndexedTriangleStripArray geom = new IndexedTriangleStripArray(vertices.length, indices.length, stripLengths);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, vertices);
        geom.setIndex(indices);
        if (normals != null) {
            geom.setNormals(0, normals);
        }
        if (texCoords2 != null) {
            geom.setTextureCoordinates(0, 0, texCoords2);
        }
        if (texCoords3 != null) {
            geom.setTextureCoordinates(0, 0, texCoords3);
        }
        if (colors != null) {
            geom.setColors(0, colors);
        }
        return geom;
    }

    public static IndexedTriangleStripArray createIndexedTriangleStripArray(GeometryConstruct geomConstruct) {
        if (geomConstruct.getGeometryTypeHint() != GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) {
            throw new IllegalArgumentException("The GeometryConstruct is made for " + geomConstruct.getGeometryTypeHint().getCorrespondingClass().getSimpleName() + ", but " + GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY.getCorrespondingClass().getSimpleName() + " is expected.");
        }
        return GeomFactory.createIndexedTriangleStripArray(geomConstruct.getCoordinates(), geomConstruct.getIndices(), geomConstruct.getNormals(), geomConstruct.getColors(), geomConstruct.getTextureCoordinates2f(), geomConstruct.getTextureCoordinates3f(), geomConstruct.getStripLengths());
    }

    public static Geometry createGeometryArray(GeometryConstruct gc) {
        if (gc.getGeometryTypeHint() == GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) {
            return GeomFactory.createIndexedTriangleStripArray(gc);
        }
        if (gc.getGeometryTypeHint() == GeometryType.INDEXED_TRIANGLE_ARRAY) {
            return GeomFactory.createIndexedTriangleArray(gc);
        }
        if (gc.getGeometryTypeHint() == GeometryType.TRIANGLE_STRIP_ARRAY) {
            return GeomFactory.createTriangleStripArray(gc);
        }
        if (gc.getGeometryTypeHint() == GeometryType.TRIANGLE_ARRAY) {
            return GeomFactory.createTriangleArray(gc);
        }
        throw new UnsupportedOperationException("The type " + (Object)((Object)gc.getGeometryTypeHint()) + " cannot currently be created. (Must be implemented)");
    }

    public static GeometryConstruct convertGeometryConstructITSA2ITA(GeometryConstruct gcITSA) {
        int numStrips = gcITSA.getStripLengths().length;
        int[] indices = new int[(gcITSA.numIndices() - 2 * numStrips) * 3];
        int o = 0;
        int k = 0;
        for (int s = 0; s < numStrips; ++s) {
            for (int i = o; i < o + gcITSA.getStripLengths()[s] - 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    indices[k++] = gcITSA.getIndices()[i + j];
                }
            }
            o += gcITSA.getStripLengths()[s];
        }
        GeometryConstruct gcITA = new GeometryConstruct(GeometryType.INDEXED_TRIANGLE_ARRAY, gcITSA.getCoordinates(), gcITSA.getNormals(), gcITSA.getTextureCoordinates2f(), indices, null);
        return gcITA;
    }

    public static GeometryConstruct convertGeometryConstructITSA2TSA(GeometryConstruct gcITSA) {
        int numStrips = gcITSA.getStripLengths().length;
        int[] stripLengths = new int[numStrips];
        for (int i = 0; i < numStrips; ++i) {
            stripLengths[i] = gcITSA.getIndices().length / numStrips;
        }
        Tuple3f[] vertices = new Point3f[gcITSA.numIndices()];
        Vector3f[] normals = null;
        TexCoord2f[] texCoords = null;
        if (gcITSA.numNormals() > 0) {
            normals = new Vector3f[vertices.length];
        }
        if (gcITSA.numTextureCoordinates2f() > 0) {
            texCoords = new TexCoord2f[vertices.length];
        }
        for (int i = 0; i < gcITSA.getIndices().length; ++i) {
            int idx = gcITSA.getIndices()[i];
            vertices[i] = new Point3f(gcITSA.getCoordinates()[idx]);
            if (gcITSA.numNormals() > 0) {
                normals[i] = new Vector3f(gcITSA.getNormals()[idx]);
            }
            if (gcITSA.numTextureCoordinates2f() <= 0) continue;
            texCoords[i] = new TexCoord2f(gcITSA.getTextureCoordinates2f()[idx]);
        }
        GeometryConstruct gcTSA = new GeometryConstruct(GeometryType.TRIANGLE_STRIP_ARRAY, vertices, normals, texCoords, null, stripLengths);
        return gcTSA;
    }

    public static GeometryConstruct convertGeometryConstructITSA2TA(GeometryConstruct gcITSA) {
        int numStrips = gcITSA.getStripLengths().length;
        Tuple3f[] coords = new Point3f[(gcITSA.numIndices() - 2 * numStrips) * 3];
        Vector3f[] normals = null;
        TexCoord2f[] texCoords2 = null;
        TexCoord3f[] texCoords3 = null;
        Colorf[] colors = null;
        if (gcITSA.numNormals() > 0) {
            normals = new Vector3f[coords.length];
        }
        if (gcITSA.numTextureCoordinates2f() > 0) {
            texCoords2 = new TexCoord2f[coords.length];
        }
        if (gcITSA.numTextureCoordinates3f() > 0) {
            texCoords3 = new TexCoord3f[coords.length];
        }
        if (gcITSA.numColors() > 0) {
            colors = new Colorf[coords.length];
        }
        int o = 0;
        int k = 0;
        for (int s = 0; s < gcITSA.getStripLengths().length; ++s) {
            for (int i = o; i < o + gcITSA.getStripLengths()[s] - 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int idx = gcITSA.getIndices()[i + j];
                    coords[k] = new Point3f(gcITSA.getCoordinates()[idx]);
                    if (gcITSA.numNormals() > 0) {
                        normals[k] = new Vector3f(gcITSA.getNormals()[idx]);
                    }
                    if (gcITSA.numTextureCoordinates2f() > 0) {
                        texCoords2[k] = new TexCoord2f(gcITSA.getTextureCoordinates2f()[idx]);
                    }
                    if (gcITSA.numTextureCoordinates3f() > 0) {
                        texCoords3[k] = new TexCoord3f(gcITSA.getTextureCoordinates3f()[idx]);
                    }
                    if (gcITSA.numColors() > 0) {
                        colors[k] = gcITSA.getColors()[idx];
                    }
                    ++k;
                }
            }
            o += gcITSA.getStripLengths()[s];
        }
        GeometryConstruct gcTA = texCoords3 != null && colors != null ? new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, coords, normals, texCoords3, colors) : new GeometryConstruct(GeometryType.TRIANGLE_ARRAY, coords, normals, texCoords2, colors);
        return gcTA;
    }

    public static IndexedTriangleArray createITAfromITSA(GeometryConstruct gcITSA) {
        boolean colorAlpha;
        if (gcITSA.getGeometryTypeHint() != GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) {
            throw new IllegalArgumentException("The given GeometryConstruct must be of type " + (Object)((Object)GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) + ", but is of type " + (Object)((Object)gcITSA.getGeometryTypeHint()));
        }
        int numStrips = gcITSA.getStripLengths().length;
        int features = gcITSA.calculateFeatures();
        boolean bl = colorAlpha = gcITSA.getColors() != null ? gcITSA.getColors()[0].hasAlpha() : false;
        int[] texCoordsSizes = gcITSA.getTextureCoordinates2f() != null ? new int[]{2} : (gcITSA.getTextureCoordinates3f() != null ? new int[]{3} : null);
        IndexedTriangleArray geom = new IndexedTriangleArray(gcITSA.numVertices(), (gcITSA.numIndices() - 2 * numStrips) * 3);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        geom.setCoordinates(0, gcITSA.getCoordinates());
        if (gcITSA.numNormals() > 0) {
            geom.setNormals(0, gcITSA.getNormals());
        }
        if (gcITSA.numTextureCoordinates2f() > 0) {
            geom.setTextureCoordinates(0, 0, gcITSA.getTextureCoordinates2f());
        }
        if (gcITSA.numTextureCoordinates3f() > 0) {
            geom.setTextureCoordinates(0, 0, gcITSA.getTextureCoordinates3f());
        }
        if (gcITSA.numColors() > 0) {
            geom.setColors(0, gcITSA.getColors());
        }
        int o = 0;
        int k = 0;
        for (int s = 0; s < numStrips; ++s) {
            for (int i = o; i < o + gcITSA.getStripLengths()[s] - 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    geom.setIndex(k++, gcITSA.getIndices()[i + j]);
                }
            }
            o += gcITSA.getStripLengths()[s];
        }
        return geom;
    }

    public static TriangleStripArray createTSAfromITSA(GeometryConstruct gcITSA) {
        boolean colorAlpha;
        if (gcITSA.getGeometryTypeHint() != GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) {
            throw new IllegalArgumentException("The given GeometryConstruct must be of type " + (Object)((Object)GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) + ", but is of type " + (Object)((Object)gcITSA.getGeometryTypeHint()));
        }
        int numStrips = gcITSA.getStripLengths().length;
        int[] stripLengths = new int[numStrips];
        for (int i = 0; i < numStrips; ++i) {
            stripLengths[i] = gcITSA.getIndices().length / numStrips;
        }
        int features = gcITSA.calculateFeatures();
        boolean bl = colorAlpha = gcITSA.getColors() != null ? gcITSA.getColors()[0].hasAlpha() : false;
        int[] texCoordsSizes = gcITSA.getTextureCoordinates2f() != null ? new int[]{2} : (gcITSA.getTextureCoordinates3f() != null ? new int[]{3} : null);
        TriangleStripArray geom = new TriangleStripArray(gcITSA.numIndices(), stripLengths);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        for (int i = 0; i < gcITSA.getIndices().length; ++i) {
            int idx = gcITSA.getIndices()[i];
            geom.setCoordinate(i, gcITSA.getCoordinates()[idx]);
            if (gcITSA.numNormals() > 0) {
                geom.setNormal(i, gcITSA.getNormals()[idx]);
            }
            if (gcITSA.numTextureCoordinates2f() <= 0) continue;
            geom.setTextureCoordinate(0, i, gcITSA.getTextureCoordinates2f()[idx]);
        }
        return geom;
    }

    public static TriangleArray createTAfromITSA(GeometryConstruct gcITSA) {
        boolean colorAlpha;
        if (gcITSA.getGeometryTypeHint() != GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) {
            throw new IllegalArgumentException("The given GeometryConstruct must be of type " + (Object)((Object)GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY) + ", but is of type " + (Object)((Object)gcITSA.getGeometryTypeHint()));
        }
        int numStrips = gcITSA.getStripLengths().length;
        int features = gcITSA.calculateFeatures();
        boolean bl = colorAlpha = gcITSA.getColors() != null ? gcITSA.getColors()[0].hasAlpha() : false;
        int[] texCoordsSizes = gcITSA.getTextureCoordinates2f() != null ? new int[]{2} : (gcITSA.getTextureCoordinates3f() != null ? new int[]{3} : null);
        TriangleArray geom = new TriangleArray((gcITSA.numIndices() - 2 * numStrips) * 3);
        geom.makeInterleaved(features, colorAlpha, texCoordsSizes, null);
        geom.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        int o = 0;
        int k = 0;
        for (int s = 0; s < gcITSA.getStripLengths().length; ++s) {
            for (int i = o; i < o + gcITSA.getStripLengths()[s] - 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int idx = gcITSA.getIndices()[i + j];
                    geom.setCoordinate(k, gcITSA.getCoordinates()[idx]);
                    if (gcITSA.numNormals() > 0) {
                        geom.setNormal(k, gcITSA.getNormals()[idx]);
                    }
                    if (gcITSA.numTextureCoordinates2f() > 0) {
                        geom.setTextureCoordinate(0, k, gcITSA.getTextureCoordinates2f()[idx]);
                    }
                    if (gcITSA.numTextureCoordinates3f() > 0) {
                        geom.setTextureCoordinate(0, k, gcITSA.getTextureCoordinates3f()[idx]);
                    }
                    if (gcITSA.numColors() > 0) {
                        geom.setColor(k, gcITSA.getColors()[idx]);
                    }
                    ++k;
                }
            }
            o += gcITSA.getStripLengths()[s];
        }
        return geom;
    }
}

