/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import org.jagatoo.opengl.enums.TextureFormat;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.GeoSphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkyGeoSphere
extends BackgroundRenderPass {
    public static final int DEFAULT_SKY_SPLITS = 5;
    public static final float X_ROTATION = 4.712389f;

    private static Texture getTextureOrNull(String texture) {
        if (texture == null) {
            return null;
        }
        Texture2D tex = TextureLoader.getInstance().getTexture(texture, null, TextureFormat.RGB, Texture.MipmapMode.BASE_LEVEL, true, false, false);
        tex.enableAutoFreeLocalData();
        return tex;
    }

    public static <G extends GroupNode> G createSkyGeoSphereGroup(int frequency, Texture texture, G group) {
        GeoSphere sphere = new GeoSphere(5.0f, frequency, 9, false, 2);
        sphere.getGeometry().setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        StaticTransform.rotateX(sphere, 1.5707964f);
        StaticTransform.rotateZ(sphere, (float)Math.PI);
        Appearance appearance = sphere.getAppearance(true);
        appearance.setTexture(texture);
        PolygonAttributes polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_FRONT);
        appearance.setPolygonAttributes(polygonAttributes);
        sphere.setAppearance(appearance);
        group.addChild(sphere);
        group.setPickableRecursive(false);
        return group;
    }

    public static BranchGroup createSkyGeoSphereGroup(int frequency, Texture texture) {
        return SkyGeoSphere.createSkyGeoSphereGroup(frequency, texture, new BranchGroup());
    }

    public static final BranchGroup createSkyGeoSphereGroup(int frequency, String textureName) {
        return SkyGeoSphere.createSkyGeoSphereGroup(frequency, SkyGeoSphere.getTextureOrNull(textureName));
    }

    public static final BranchGroup createSkyGeoSphereGroup(Texture texture) {
        return SkyGeoSphere.createSkyGeoSphereGroup(5, texture);
    }

    public static final BranchGroup createSkyGeoSphereGroup(String textureName) {
        return SkyGeoSphere.createSkyGeoSphereGroup(5, textureName);
    }

    public SkyGeoSphere(int frequency, Texture texture) {
        super(SkyGeoSphere.createSkyGeoSphereGroup(frequency, texture), new BaseRenderPassConfig(View.CameraMode.VIEW_FIXED_POSITION));
    }

    public SkyGeoSphere(int frequency, String textureName) {
        this(frequency, SkyGeoSphere.getTextureOrNull(textureName));
    }

    public SkyGeoSphere(Texture texture) {
        this(5, texture);
    }

    public SkyGeoSphere(String textureName) {
        this(5, textureName);
    }
}

