/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.primitives;

import java.awt.Font;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Rectangle;

public class TextRectangle
extends Rectangle {
    public static final int TEXT_ALIGNMENT_HORIZONTAL_LEFT = 0;
    public static final int TEXT_ALIGNMENT_HORIZONTAL_CENTER = 1;
    public static final int TEXT_ALIGNMENT_HORIZONTAL_RIGHT = 2;
    private String text = null;
    private Colorf textColor = null;
    private Font textFont = null;
    private int textAlignment = 0;

    public void setText(String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        this.setTexture(texture);
        this.text = text;
        this.textColor = color;
        this.textFont = font;
        this.textAlignment = alignment;
    }

    public void setText(String text) {
        this.setText(text, this.getTextColor(), this.getTextFont(), this.getTextAlignment());
    }

    public String getText() {
        return this.text;
    }

    public Colorf getTextColor() {
        return this.textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    protected static float getHeightFromFixedWidth(float width, Texture texture) {
        Dim2i dim = (Dim2i)texture.getUserData("EFFECTIVE_SIZE");
        float q = (float)dim.getWidth() / (float)dim.getHeight();
        return width / q;
    }

    protected static float getWidthFromFixedHeight(float height, Texture texture) {
        Dim2i dim = (Dim2i)texture.getUserData("EFFECTIVE_SIZE");
        float q = (float)dim.getWidth() / (float)dim.getHeight();
        return height * q;
    }

    protected TextRectangle(float width, float height, Tuple3f offset, Texture texture) {
        super(width, height, offset, texture, null, null, null);
    }

    protected TextRectangle(float width, float height, Rectangle.ZeroPointLocation zpl, float zOffset, Texture texture) {
        super(width, height, zpl, zOffset, texture);
    }

    public static TextRectangle createFixedWidth(float width, Tuple3f offset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, offset, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, Tuple3f offset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, offset, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextRectangle createFixedWidth(float width, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float height = TextRectangle.getHeightFromFixedWidth(width, texture);
        return new TextRectangle(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, Tuple3f offset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, offset, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, String text, Colorf color, Font font, int alignment) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, alignment);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, zpl, 0.0f, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, Tuple3f offset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, offset, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, (Tuple3f)new Vector3f(0.0f, 0.0f, zOffset), (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, (Tuple3f)null, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(float height, Rectangle.ZeroPointLocation zpl, float zOffset, String text, Colorf color, Font font) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, zpl, zOffset, (Texture)texture);
    }

    public static TextRectangle createFixedHeight(String text, Colorf color, Font font, float height, Rectangle.ZeroPointLocation zpl) {
        Texture2D texture = TextureCreator.createTexture(text, color, font, 0);
        float width = TextRectangle.getWidthFromFixedHeight(height, texture);
        return new TextRectangle(width, height, zpl, 0.0f, (Texture)texture);
    }
}

