/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph.utils;

import java.util.ArrayList;
import java.util.List;
import org.openmali.spatial.VertexContainer;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Shape3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiGeometryVertexContainer
implements VertexContainer {
    private final int vertexCount;
    private final List<VertexContainer> geoms;

    @Override
    public final int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public final boolean getVertex(int index, Tuple3f vertex) {
        if (index >= this.vertexCount) {
            return false;
        }
        int offset = 0;
        for (int i = 0; i < this.geoms.size(); ++i) {
            VertexContainer geom = this.geoms.get(i);
            int size = geom.getVertexCount();
            if (index < offset + size) {
                return geom.getVertex(index - offset, vertex);
            }
            offset += size;
        }
        return false;
    }

    public MultiGeometryVertexContainer(GroupNode group) {
        List<Shape3D> shapes = group.findAll(Shape3D.class);
        this.geoms = new ArrayList<VertexContainer>();
        for (int i = 0; i < shapes.size(); ++i) {
            this.geoms.add(shapes.get(i).getGeometry());
        }
        int vertexCount = 0;
        for (int i = 0; i < this.geoms.size(); ++i) {
            vertexCount += this.geoms.get(i).getVertexCount();
        }
        this.vertexCount = vertexCount;
    }

    public MultiGeometryVertexContainer(List<VertexContainer> geometries) {
        this.geoms = geometries;
        int vertexCount = 0;
        for (int i = 0; i < this.geoms.size(); ++i) {
            vertexCount += this.geoms.get(i).getVertexCount();
        }
        this.vertexCount = vertexCount;
    }
}

