/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.scenegraph.View;

public class PointFocusser
extends ScheduledOperationImpl {
    private Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private float startGameTime = -1.0f;
    private View view;
    private float speed;
    private float duration;
    private Point3f point0;
    private Vector3f direction0;
    private Point3f point;
    private Vector3f direction;
    private Point3f point1;
    private Vector3f direction1;
    private float length;
    private FinishListener finishListener = null;

    public final void setUpVector(Vector3f up) {
        if (up == null) {
            throw new NullPointerException("up vector must not be null.");
        }
        this.up = up;
    }

    public final Vector3f getUpVector() {
        return this.up;
    }

    public void setPoint(Point3f point) {
        this.point1 = point;
    }

    public Point3f getPoint() {
        return this.point1;
    }

    public void setDirection(Vector3f direction) {
        this.direction1 = direction;
    }

    public Vector3f getDirection() {
        return this.direction1;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float seconds = timingMode.getSecondsAsFloat(gameTime);
        if (this.startGameTime < 0.0f) {
            this.startGameTime = seconds;
            this.point0 = new Point3f(this.view.getPosition());
            this.direction0 = new Vector3f(this.view.getFacingDirection());
            this.point = new Point3f();
            this.direction = new Vector3f();
            this.length = this.point0.distance(this.point1);
            this.duration = this.length / this.speed;
        } else {
            float alpha = (seconds - this.startGameTime) / this.duration;
            this.point.interpolate(this.point0, this.point1, alpha);
            this.direction.interpolate(this.direction0, this.direction1, alpha);
            if (this.point.distance(this.point0) >= this.length) {
                this.setAlive(false);
                if (this.finishListener != null) {
                    this.finishListener.onFocusserArrived(gameTime, timingMode);
                }
                return;
            }
            this.direction.add(this.point);
            this.view.lookAt(this.point, this.direction, this.up);
        }
    }

    public void setFinishListener(FinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public PointFocusser(View view, Point3f point, Vector3f direction, float speed, FinishListener finishLsitener) {
        super(true);
        this.view = view;
        this.point1 = point;
        this.direction1 = direction;
        this.speed = speed;
        this.finishListener = finishLsitener;
    }

    public PointFocusser(View view, Point3f point, Vector3f direction, float speed) {
        this(view, point, direction, speed, null);
    }

    public static interface FinishListener {
        public void onFocusserArrived(long var1, UpdatingThread.TimingMode var3);
    }
}

