/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.schedops.movement;

import org.openmali.vecmath2.Vector3f;

public class TransformationDirectives {
    private float initValueX = 0.0f;
    private float initValueY = 0.0f;
    private float initValueZ = 0.0f;
    private float initValueU = 0.0f;
    private float speedX = 0.0f;
    private float speedY = 0.0f;
    private float speedZ = 0.0f;
    private float speedU = 0.0f;
    private Vector3f userAxis;
    private AxisOrder axisOrder;
    private boolean isDirty = false;

    public final void setClean() {
        this.isDirty = false;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public AxisOrder getAxisOrder() {
        return this.axisOrder;
    }

    public void setAxisOrder(AxisOrder axisOrder) {
        this.axisOrder = axisOrder;
        this.isDirty = true;
    }

    public Vector3f getUserAxis() {
        return this.userAxis;
    }

    public void setUserAxis(Vector3f userAxis) {
        this.userAxis = new Vector3f(userAxis);
        this.userAxis.normalize();
        this.isDirty = true;
    }

    public void setInitValueX(float value) {
        this.initValueX = value;
        this.isDirty = true;
    }

    public float getInitValueX() {
        return this.initValueX;
    }

    public void setInitValueY(float value) {
        this.initValueY = value;
        this.isDirty = true;
    }

    public float getInitValueY() {
        return this.initValueY;
    }

    public void setInitValueZ(float value) {
        this.initValueZ = value;
        this.isDirty = true;
    }

    public float getInitValueZ() {
        return this.initValueZ;
    }

    public void setInitValueUser(float value) {
        this.initValueU = value;
        this.isDirty = true;
    }

    public float getInitValueUser() {
        return this.initValueU;
    }

    public void setInitValue(Axes axis, float value) {
        if (axis == null) {
            this.setInitValueUser(value);
            this.isDirty = true;
            return;
        }
        switch (axis) {
            case X_AXIS: {
                this.setInitValueX(value);
                break;
            }
            case Y_AXIS: {
                this.setInitValueY(value);
                break;
            }
            case Z_AXIS: {
                this.setInitValueZ(value);
            }
        }
        this.isDirty = true;
    }

    public void setInitValue(float value) {
        this.setInitValue(null, value);
    }

    public float getInitValue(Axes axis) {
        if (axis == null) {
            return this.getInitValueUser();
        }
        switch (axis) {
            case X_AXIS: {
                return this.getInitValueX();
            }
            case Y_AXIS: {
                return this.getInitValueY();
            }
            case Z_AXIS: {
                return this.getInitValueZ();
            }
        }
        return 0.0f;
    }

    public float getInitValue() {
        return this.getInitValue(null);
    }

    public void setSpeedX(float speed) {
        this.speedX = speed;
        this.isDirty = true;
    }

    public float getSpeedX() {
        return this.speedX;
    }

    public void setSpeedY(float speed) {
        this.speedY = speed;
        this.isDirty = true;
    }

    public float getSpeedY() {
        return this.speedY;
    }

    public void setSpeedZ(float speed) {
        this.speedZ = speed;
        this.isDirty = true;
    }

    public float getSpeedZ() {
        return this.speedZ;
    }

    public void setSpeedUser(float speed) {
        this.speedU = speed;
        this.isDirty = true;
    }

    public float getSpeedUser() {
        return this.speedU;
    }

    public void setSpeed(Axes axis, float value) {
        if (axis == null) {
            this.setSpeedUser(value);
            this.isDirty = true;
            return;
        }
        switch (axis) {
            case X_AXIS: {
                this.setSpeedX(value);
                break;
            }
            case Y_AXIS: {
                this.setSpeedY(value);
                break;
            }
            case Z_AXIS: {
                this.setSpeedZ(value);
            }
        }
        this.isDirty = true;
    }

    public void setSpeed(float value) {
        this.setSpeed(null, value);
    }

    public float getSpeed(Axes axis) {
        if (axis == null) {
            return this.getSpeedUser();
        }
        switch (axis) {
            case X_AXIS: {
                return this.getSpeedX();
            }
            case Y_AXIS: {
                return this.getSpeedY();
            }
            case Z_AXIS: {
                return this.getSpeedZ();
            }
        }
        return 0.0f;
    }

    public float getSpeed() {
        return this.getSpeed(null);
    }

    public TransformationDirectives(Vector3f userAxis, float initValue, float speed) {
        this.initValueX = -1.0f;
        this.initValueY = -1.0f;
        this.initValueZ = -1.0f;
        this.initValueU = initValue;
        this.speedX = -1.0f;
        this.speedY = -1.0f;
        this.speedZ = -1.0f;
        this.speedU = speed;
        this.axisOrder = null;
        this.setUserAxis(userAxis);
    }

    public TransformationDirectives(Vector3f userAxis, float speed) {
        this(userAxis, 0.0f, speed);
    }

    public TransformationDirectives(Vector3f userAxis) {
        this(userAxis, 0.0f, 0.0f);
    }

    public TransformationDirectives(float initValueX, float initValueY, float initValueZ, float speedX, float speedY, float speedZ, AxisOrder axisOrder) {
        this.initValueX = initValueX;
        this.initValueY = initValueY;
        this.initValueZ = initValueZ;
        this.initValueU = -1.0f;
        this.speedX = speedX;
        this.speedY = speedY;
        this.speedZ = speedZ;
        this.speedU = -1.0f;
        this.axisOrder = axisOrder;
        this.userAxis = null;
    }

    public TransformationDirectives(float initValueX, float initValueY, float initValueZ, float speedX, float speedY, float speedZ) {
        this(initValueX, initValueY, initValueZ, speedX, speedY, speedZ, AxisOrder.getDefault());
    }

    public TransformationDirectives(float speedX, float speedY, float speedZ, AxisOrder axisOrder) {
        this(0.0f, 0.0f, 0.0f, speedX, speedY, speedZ, axisOrder);
    }

    public TransformationDirectives(float speedX, float speedY, float speedZ) {
        this(0.0f, 0.0f, 0.0f, speedX, speedY, speedZ, AxisOrder.getDefault());
    }

    public TransformationDirectives(AxisOrder axisOrder) {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, axisOrder);
    }

    public TransformationDirectives() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, AxisOrder.getDefault());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxisOrder {
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;


        public static AxisOrder getDefault() {
            return XYZ;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axes {
        X_AXIS,
        Y_AXIS,
        Z_AXIS;

    }
}

