/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xith3d.selection.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionList {
    private ArrayList<ActionEntry> actions = new ArrayList(16);

    public void addAll(ActionList source) {
        for (int i = 0; i < source.actions.size(); ++i) {
            ActionEntry entry = source.actions.get(i);
            this.addAction(entry.preferredPosition, entry.action);
        }
    }

    public void addAction(int preferredPosition, Action action) {
        this.removeAction(action);
        this.actions.add(new ActionEntry(preferredPosition, action));
        Collections.sort(this.actions);
    }

    public boolean removeAction(Action action) {
        boolean removed = false;
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            ActionEntry actionEntry = this.actions.get(i);
            if (!actionEntry.action.equals(action)) continue;
            this.actions.remove(i);
            removed = true;
        }
        Collections.sort(this.actions);
        return removed;
    }

    public List<Action> getActions() {
        ArrayList<Action> list = new ArrayList<Action>(this.actions.size());
        for (int i = 0; i < this.actions.size(); ++i) {
            list.add(this.actions.get((int)i).action);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionEntry
    implements Comparable<ActionEntry> {
        Action action;
        int preferredPosition;

        public ActionEntry(int preferredPosition, Action action) {
            this.action = action;
            this.preferredPosition = preferredPosition;
        }

        @Override
        public int compareTo(ActionEntry o) {
            return this.preferredPosition - o.preferredPosition;
        }
    }
}

