/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import java.util.ArrayList;
import java.util.List;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.selection.ContextMenuProvider;
import org.xith3d.selection.MenuAction;
import org.xith3d.selection.Selectable;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.contextmenu.ContextMenu;
import org.xith3d.ui.hud.contextmenu.DefaultContextMenu;
import org.xith3d.ui.hud.contextmenu.DefaultContextMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUDContextMenuProvider
implements ContextMenuProvider {
    private static final String PROP_HUD_MENU_ITEM = "HUD_MENU_ITEM";
    public static final String PROP_MOUSE_COORDS = "mouseCoords";
    public static final String PROP_WORLD_COORDS = "worldCoords";
    public static final String PROP_SELECTION = "selection";
    public static final String PROP_SELECTED_CONTEXT = "selectedContext";
    private ContextMenu menu = new DefaultContextMenu();

    @Override
    public void showContextMenu(Tuple2i mouseCoords, Tuple3f worldCoords, List<Selectable> selection, List<Selectable> selectedContext) {
        if (this.menu.isPoppedUp()) {
            this.menu.popUp(false);
        } else {
            int i;
            this.menu.removeAllItems();
            ArrayList<MenuAction> result = new ArrayList<MenuAction>();
            for (i = 0; i < selection.size(); ++i) {
                Selectable selectable = selection.get(i);
                List<MenuAction> actions = selectable.lookup(MenuAction.class);
                result.addAll(actions);
            }
            for (i = 0; i < result.size(); ++i) {
                final MenuAction action = (MenuAction)result.get(i);
                action.setProperty(PROP_MOUSE_COORDS, mouseCoords);
                action.setProperty(PROP_WORLD_COORDS, worldCoords);
                action.setProperty(PROP_SELECTION, selection);
                action.setProperty(PROP_SELECTED_CONTEXT, selectedContext);
                DefaultContextMenuItem hudItem = (DefaultContextMenuItem)action.getProperty(PROP_HUD_MENU_ITEM);
                if (hudItem == null) {
                    hudItem = new DefaultContextMenuItem(action.getName()){

                        public void onItemClicked() {
                            super.onItemClicked();
                            action.onActionPerformed();
                        }
                    };
                    action.setProperty(PROP_HUD_MENU_ITEM, hudItem);
                }
                if (action == MenuAction.SEPARATOR) continue;
                this.menu.addItem(hudItem);
            }
            this.menu.popUp(mouseCoords.getX(), mouseCoords.getY());
        }
    }

    public HUDContextMenuProvider(HUD hud) {
        hud.setContextMenu(this.menu);
    }
}

