/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.selection;

import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRay;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.selection.MovementConstraints;

public class PlaneConstraints
implements MovementConstraints {
    private Vector3f planeNormal;

    public Vector3f getPlaneNormal() {
        return this.planeNormal;
    }

    public void setPlaneNormal(Vector3f planeNormal) {
        this.planeNormal = planeNormal;
    }

    public void computeNewPosition(RenderPassConfig rpc, Canvas3D canvas, int x, int y, Point3f p0, Point3f newPosition) {
        Vector3f n = this.planeNormal;
        Plane movementPlane = Plane.fromPool();
        PickRay pickRay = PickPool.allocatePickRay();
        float d = -(n.getX() * p0.getX() + n.getY() * p0.getY() + n.getZ() * p0.getZ());
        movementPlane.set(n.getX(), n.getY(), n.getZ(), d);
        pickRay.recalculate(rpc, canvas, x, y);
        movementPlane.intersects(pickRay, newPosition);
        PickPool.deallocatePickRay(pickRay);
        Plane.toPool(movementPlane);
    }

    public PlaneConstraints(Vector3f planeNormal) {
        this.planeNormal = planeNormal;
    }

    public PlaneConstraints() {
        this(Vector3f.POSITIVE_Z_AXIS);
    }
}

