/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.javasound;

import java.util.ArrayList;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.SoundState;
import org.xith3d.sound.drivers.javasound.SoundBufferImpl;

public class SoundSourceImpl
implements SoundSource {
    private final SoundDriver driver;
    private final ArrayList<SoundBufferImpl> queue = new ArrayList();
    private Clip clip = null;
    private SoundState state;
    private Point3f position = new Point3f();
    private int loopCount = 0;

    public final SoundDriver getSoundDriver() {
        return this.driver;
    }

    public SoundState getState() {
        return this.state;
    }

    public Mixer getMixer() {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixers.length; ++i) {
            if (!mixers[i].getName().equals("Java Sound Audio Engine")) continue;
            return AudioSystem.getMixer(mixers[i]);
        }
        return null;
    }

    public void setBuffer(SoundBuffer buffer) {
        try {
            SoundBufferImpl sb = (SoundBufferImpl)buffer;
            Mixer mix = this.getMixer();
            this.clip = mix != null ? (Clip)mix.getLine(((SoundBufferImpl)buffer).getInfo()) : (Clip)AudioSystem.getLine(((SoundBufferImpl)buffer).getInfo());
            this.clip.open(sb.af, sb.data, 0, sb.size);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public void close() {
        if (this.clip != null) {
            this.clip.close();
            this.clip = null;
        }
        this.state = SoundState.INITIAL;
    }

    public void queueBuffer(SoundBuffer buffer) {
        if (!(buffer instanceof SoundBufferImpl)) {
            throw new IllegalArgumentException("buffer must be an instance of SoundBufferImpl.");
        }
        this.queue.add((SoundBufferImpl)buffer);
    }

    public void setContainer(SoundContainer container) {
        SoundBuffer sb = container.getData(this.driver);
        if (sb != null) {
            this.setBuffer(sb);
        }
    }

    public void play() {
        if (this.clip == null) {
            if (this.queue.size() == 0) {
                return;
            }
            SoundBufferImpl sb = this.queue.remove(0);
            this.setBuffer(sb);
        }
        this.clip.loop(this.loopCount);
        this.state = SoundState.PLAYING;
    }

    public void pause() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.state = SoundState.PAUSED;
    }

    public void rewind() {
        if (this.clip != null) {
            this.clip.setFramePosition(0);
        }
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
        this.state = SoundState.STOPPED;
    }

    public boolean isPlaying() {
        if (this.clip != null) {
            return this.clip.isRunning();
        }
        return this.state == SoundState.PLAYING;
    }

    public void setPosition(float posX, float posY, float posZ) {
        this.position.set(posX, posY, posZ);
    }

    public void setPosition(Tuple3f position) {
        this.position.set((TupleNf)position);
    }

    public void setVelocity(float veloX, float veloY, float veloZ) {
    }

    public void setVelocity(Tuple3f velocity) {
    }

    public void setDirection(float dirX, float dirY, float dirZ) {
    }

    public void setDirection(Tuple3f direction) {
    }

    public void setVolume(float gain) {
    }

    public void setReferenceDistance(float refDistance) {
    }

    public void setRolloffFactor(float factor) {
    }

    public void setRelative(boolean relative) {
    }

    public void setLoop(boolean loop) {
        if (this.clip != null) {
            int n = this.loopCount = loop ? -1 : 0;
            if (this.isPlaying()) {
                this.clip.loop(this.loopCount);
            }
        }
    }

    public void setMaxVolume(float maxVolume) {
    }

    public void setMinVolume(float minVolume) {
    }

    public void setMaxDistance(float maxDistance) {
    }

    public void setMaxTime(long ms) {
    }

    public SoundSourceImpl(SoundDriver driver) {
        this.driver = driver;
        this.state = SoundState.INITIAL;
    }
}

