/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.joal;

import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALFactory;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.drivers.joal.SoundBufferImpl;
import org.xith3d.sound.drivers.joal.SoundSourceImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundDriverImpl
extends SoundDriver {
    private AL al;
    private ALC alc;
    private ALCdevice device;
    private ALCcontext context;

    protected final AL getAL() {
        return this.al;
    }

    protected String decodeSoundError(int error) {
        switch (error) {
            case 0: {
                return "NO ERROR";
            }
            case 40962: {
                return "INVALID ENUM";
            }
            case 40963: {
                return "INVALID VALUE";
            }
            case 40961: {
                return "INVALID NAME";
            }
            case 40964: {
                return "INVALID OPERATION";
            }
            case 40965: {
                return "OUT OF MEMORY";
            }
        }
        return "UNKNOWN ERROR";
    }

    protected void checkError() {
        int error = this.getAL().alGetError();
        if (error != 0) {
            throw new Error(this.decodeSoundError(error));
        }
    }

    protected void startImpl() {
    }

    public void newFrameSync() {
        int[] sourceList = new int[this.sources.size()];
        for (int i = 0; i < sourceList.length; ++i) {
            SoundSourceImpl ss = (SoundSourceImpl)this.sources.get(i);
            sourceList[i] = ss.handle;
            ss.stop();
        }
    }

    public void newFrameAsync() {
    }

    public void setListenerVelocity(Tuple3f velocity) {
        this.al.alListener3f(4102, velocity.getX(), velocity.getY(), velocity.getZ());
        this.checkError();
        super.setListenerVelocity(velocity);
    }

    public void setListenerPosition(Tuple3f position) {
        this.al.alListenerfv(4100, new float[]{position.getX(), position.getY(), position.getZ()}, 0);
        this.checkError();
        super.setListenerPosition(position);
    }

    public void setListenerOrientation(Tuple3f direction, Tuple3f up) {
        this.al.alListenerfv(4111, new float[]{direction.getX(), direction.getY(), direction.getZ(), up.getX(), up.getY(), up.getZ()}, 0);
        super.setListenerOrientation(direction, up);
    }

    public void setListenerVolume(float gain) {
        this.al.alListenerf(4106, gain);
        this.checkError();
        super.setListenerVolume(gain);
    }

    public void setDopplerVelocity(float velocity) {
        this.al.alDopplerVelocity(velocity);
        this.checkError();
        super.setDopplerVelocity(velocity);
    }

    public void setDopplerFactor(float factor) {
        this.al.alDopplerFactor(factor);
        super.setDopplerFactor(factor);
    }

    protected SoundSource createSoundSource() {
        return new SoundSourceImpl(this);
    }

    public SoundBuffer allocateSoundBuffer() {
        return new SoundBufferImpl(this);
    }

    public boolean delete(SoundSource source) {
        if (super.delete(source)) {
            ((SoundSourceImpl)source).releaseCachedResources();
            return true;
        }
        return false;
    }

    protected void shutdownImpl() {
        SoundSourceImpl ss;
        int j;
        int[] sourceList = new int[this.sources.size() + this.availableSources.size()];
        int i = 0;
        for (j = 0; j < this.sources.size(); ++j) {
            ss = (SoundSourceImpl)this.sources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        for (j = 0; j < this.availableSources.size(); ++j) {
            ss = (SoundSourceImpl)this.availableSources.get(j);
            sourceList[i++] = ss.handle;
            ss.stop();
        }
        if (sourceList.length > 0) {
            this.al.alDeleteSources(sourceList.length, sourceList, 0);
            this.checkError();
        }
        int[] bufferList = new int[this.buffers.size()];
        int j2 = 0;
        while (i < bufferList.length) {
            SoundBufferImpl ss2 = (SoundBufferImpl)this.buffers.get(j2);
            bufferList[j2] = ss2.handle;
            ++j2;
        }
        if (bufferList.length > 0) {
            this.al.alDeleteBuffers(bufferList.length, bufferList, 0);
            this.checkError();
        }
        X3DLog.debug("Making sound context current");
        this.alc.alcMakeContextCurrent(this.context);
        X3DLog.debug("Destroying context");
        this.alc.alcDestroyContext(this.context);
        X3DLog.debug("Closing device");
        this.alc.alcCloseDevice(this.device);
    }

    protected void initSoundDevice() {
        try {
            this.al = ALFactory.getAL();
            this.alc = ALFactory.getALC();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.device = this.alc.alcOpenDevice(System.getProperty("XITH3D_OPENAL_DEVICE"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.device == null) {
            throw new Error("No sound device found");
        }
        this.context = this.alc.alcCreateContext(this.device, null);
        this.alc.alcMakeContextCurrent(this.context);
        this.checkError();
        this.al.alDistanceModel(53249);
        this.checkError();
    }

    public SoundDriverImpl() {
        X3DLog.debug("OpenAL sound driver initialized with ", this.getNumAvailableSources(), " available sources");
    }
}

