/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.sound.drivers.lwjgl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundSource;
import org.xith3d.sound.SoundState;
import org.xith3d.sound.drivers.lwjgl.SoundBufferImpl;
import org.xith3d.sound.drivers.lwjgl.SoundDriverImpl;
import org.xith3d.utility.logging.X3DLog;

public class SoundSourceImpl
implements SoundSource {
    static int count = 0;
    int handle;
    private SoundDriverImpl driver;
    private float[] pos = new float[3];
    private boolean hasCachedPosition = false;

    public SoundSourceImpl(SoundDriverImpl driver) {
        this.driver = driver;
        IntBuffer buffer = BufferUtils.createIntBuffer(1);
        int error = AL10.alGetError();
        AL10.alGenSources(buffer);
        error = AL10.alGetError();
        if (error != 0) {
            throw new Error("no more sources available : " + driver.decodeSoundError(error));
        }
        this.handle = buffer.get(0);
        X3DLog.debug("Created new source.. handle = ", this.handle);
        this.setRolloffFactor(0.5f);
        this.setMaxDistance(30.0f);
        this.setReferenceDistance(5.0f);
        this.setMinVolume(0.0f);
        this.setMaxVolume(1.0f);
    }

    public void queueBuffer(SoundBuffer buffer) {
        IntBuffer intbuf = BufferUtils.createIntBuffer(1).put(((SoundBufferImpl)buffer).handle);
        intbuf.rewind();
        AL10.alSourceQueueBuffers(this.handle, intbuf);
        this.driver.checkError();
    }

    public int[] unqueueProcessedBuffers() {
        int num = AL10.alGetSourcei(this.handle, 4118);
        IntBuffer buffers = BufferUtils.createIntBuffer(num);
        AL10.alSourceUnqueueBuffers(this.handle, buffers);
        this.driver.checkError();
        return buffers.array();
    }

    public void setBuffer(SoundBuffer buffer) {
        AL10.alSourcei(this.handle, 4105, ((SoundBufferImpl)buffer).handle);
        this.driver.checkError();
    }

    public void setContainer(SoundContainer container) {
        SoundBuffer b = container.getData(this.driver);
        if (b != null) {
            this.setBuffer(b);
        }
    }

    public void setVolume(float gain) {
        AL10.alSourcef(this.handle, 4106, gain);
        this.driver.checkError();
    }

    public void play() {
        AL10.alSourcePlay(this.handle);
        this.driver.checkError();
    }

    public void pause() {
        AL10.alSourcePause(this.handle);
        this.driver.checkError();
    }

    public void rewind() {
        AL10.alSourceRewind(this.handle);
        this.driver.checkError();
    }

    public void stop() {
        AL10.alSourceStop(this.handle);
        this.driver.checkError();
    }

    public boolean isPlaying() {
        return this.getState() == SoundState.PLAYING;
    }

    void releaseCachedResources() {
        this.hasCachedPosition = false;
    }

    public void setPosition(float posX, float posY, float posZ) {
        if (this.hasCachedPosition) {
            if (this.pos[0] == posX && this.pos[1] == posY && this.pos[2] == posZ) {
                return;
            }
            this.hasCachedPosition = true;
        }
        this.pos[0] = posX;
        this.pos[1] = posY;
        this.pos[2] = posZ;
        AL10.alSource3f(this.handle, 4100, posX, posY, posZ);
        this.driver.checkError();
    }

    public void setPosition(Tuple3f position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setVelocity(float veloX, float veloY, float veloZ) {
        AL10.alSource3f(this.handle, 4102, veloX, veloY, veloZ);
        this.driver.checkError();
    }

    public void setVelocity(Tuple3f velocity) {
        this.setVelocity(velocity.getX(), velocity.getY(), velocity.getZ());
    }

    public void setDirection(float dirX, float dirY, float dirZ) {
    }

    public void setDirection(Tuple3f direction) {
    }

    public SoundState getState() {
        int state = AL10.alGetSourcei(this.handle, 4112);
        switch (state) {
            case 4113: {
                return SoundState.INITIAL;
            }
            case 4114: {
                return SoundState.PLAYING;
            }
            case 4115: {
                return SoundState.PAUSED;
            }
            case 4116: {
                return SoundState.STOPPED;
            }
        }
        throw new Error("Illegal OpenAL state found");
    }

    public void setReferenceDistance(float refDistance) {
        AL10.alSourcef(this.handle, 4128, refDistance);
        this.driver.checkError();
    }

    public void setRolloffFactor(float factor) {
        AL10.alSourcef(this.handle, 4129, factor);
        this.driver.checkError();
    }

    public void setRelative(boolean relative) {
        AL10.alSourcei(this.handle, 514, relative ? 1 : 0);
        this.driver.checkError();
    }

    public void setLoop(boolean loop) {
        AL10.alSourcei(this.handle, 4103, loop ? 1 : 0);
    }

    public void setMaxVolume(float maxVolume) {
        AL10.alSourcef(this.handle, 4110, maxVolume);
        this.driver.checkError();
    }

    public void setMinVolume(float minVolume) {
        AL10.alSourcef(this.handle, 4109, minVolume);
        this.driver.checkError();
    }

    public void setMaxDistance(float maxDistance) {
        AL10.alSourcef(this.handle, 4131, maxDistance);
        this.driver.checkError();
    }

    public void setMaxTime(long ms) {
    }

    public SoundDriver getSoundDriver() {
        return this.driver;
    }
}

