/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.terrain;

import java.net.URL;
import org.xith3d.terrain.ChunkedTerrain;
import org.xith3d.terrain.L3DTResourceProvider;

public class L3DTerrain
extends ChunkedTerrain {
    public L3DTerrain(URL location) {
        super(new L3DTSpec(location, 1.0f));
    }

    public L3DTerrain(URL location, float unitSize) {
        super(new L3DTSpec(location, unitSize));
    }

    private static class L3DTSpec
    extends ChunkedTerrain.Spec {
        public L3DTSpec(URL location, float unitSize) {
            L3DTResourceProvider provider = new L3DTResourceProvider(location);
            float width = (float)provider.getNx() * provider.getHScale() * unitSize;
            float depth = (float)provider.getNy() * provider.getHScale() * unitSize;
            float height = (provider.getMaxAlt() - provider.getMinAlt()) * unitSize;
            this.resourceProvider = provider;
            this.x = -(width / 2.0f);
            this.y = provider.getMinAlt() * unitSize;
            this.z = -(depth / 2.0f);
            this.scale = width;
            this.height = height;
        }
    }
}

