/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.animation;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.schedops.movement.Bullet;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.Cursor;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This test class demonstrates the use of the abstract Bullet class.", "It extends Bullet to a LaserImpulse.", "Bullet itself doesn't have any visual part."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BulletTest
extends Xith3DTest {
    private float resX;
    private float resY;
    private BranchGroup rootBranch;
    private static final long MAX_BULLET_LIFETIME = 10000000L;
    private Random rnd;

    private void shoot(Vector3f velocity) {
        velocity.normalize();
        velocity.scale(5.0f);
        Colorf color = new Colorf(0.6f + this.rnd.nextFloat() * 0.4f, 0.6f + this.rnd.nextFloat() * 0.4f, 0.6f + this.rnd.nextFloat() * 0.4f);
        LaserImpulse bullet = new LaserImpulse(velocity, 10000000L, color);
        this.rootBranch.addChild(bullet);
        this.getAnimator().addAnimatableObject(bullet);
    }

    private void shoot(float x, float y) {
        Vector2f dir = new Vector2f(x - this.resX / 2.0f, -(y - this.resY / 2.0f));
        dir.normalize();
        dir.scale(this.rnd.nextFloat());
        this.shoot(new Vector3f(dir.getX(), dir.getY(), -this.rnd.nextFloat()));
    }

    private void shoot() {
        Vector3f velocity = new Vector3f(-1.0f + this.rnd.nextFloat() * 2.0f, -1.0f + this.rnd.nextFloat() * 2.0f, -this.rnd.nextFloat());
        this.shoot(velocity);
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (button == MouseButtons.LEFT_BUTTON) {
            this.shoot(e.getX(), e.getY());
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.shoot();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private HUD createHUD(Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        this.resX = resolution.getWidth();
        this.resY = resolution.getHeight();
        resLoc.createAndAddTSL("HUD");
        HUD hud = new HUD(resolution, 800.0f);
        Image horiz = new Image(hud.getResX(), 3.0f, Colorf.RED);
        hud.getContentPane().addWidget(horiz, 0.0f, (hud.getResY() - horiz.getHeight()) / 2.0f);
        Image verti = new Image(3.0f, hud.getResY(), Colorf.RED);
        hud.getContentPane().addWidget(verti, (hud.getResX() - verti.getWidth()) / 2.0f, 0.0f);
        Texture2D crosshairTex = TextureLoader.getInstance().getTexture("CrosshairWhite.png");
        hud.setCursor(new Cursor(crosshairTex, crosshairTex.getOriginalWidth() / 2, crosshairTex.getOriginalHeight() / 2));
        DeviceComponent[] comps = new DeviceComponent[]{Keys.SPACE, MouseButtons.LEFT_BUTTON, new MouseAxis(null, 'm', "Mouse")};
        String[] boundActions = new String[]{"Shoot a random bullet (laser impulse)", "Shoot a bullet to the cursor (laser impulse)", "Move the cursor"};
        TestUtils.displayInputBindings(comps, boundActions, hud);
        return hud;
    }

    private void createSceneGraph(SceneGraph sg, Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        this.rootBranch = sg.addPerspectiveBranch().getBranchGroup();
        this.rnd = new Random(System.nanoTime());
        sg.addHUD(this.createHUD(resolution, resLoc));
    }

    public BulletTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, arguments.getResolution(), resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        canvas.setCursor(null);
    }

    public static void main(String[] args) throws Throwable {
        BulletTest test = new BulletTest(BulletTest.parseCommandLine(args));
        test.begin();
    }

    private static class LaserImpulse
    extends Bullet {
        private static final float LI_THICKNESS = 3.0f;

        public LaserImpulse(Vector3f velocity, long maxLifeTime, Colorf color) {
            super(velocity, maxLifeTime);
            Vector3f lineEnd = new Vector3f(velocity);
            lineEnd.normalize();
            lineEnd.scale(0.75f);
            Line line = new Line((Tuple3f)lineEnd, 3.0f, true, color);
            this.addChild(line);
        }
    }
}

