/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.animation;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.FPSCounter;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This class demonstrates the basic use of<br>", "org.xith3d.rendering.Xith3DEnvironment", "org.xith3d.rendering.Canvas3D<br>", "org.xith3d.rendering.InputAdapterRenderLoop<br>", "loopIteration overriding"}, authors={"Marvin Froehlich (aka Qudus)"})
public class RotatableGroupTest
extends Xith3DTest
implements NearestPickListener,
IntervalListener {
    private RenderPass persPass;
    private GroupNode pickGroup;
    private PickScheduler pickScheduler;
    private RotatingSphere rotSphere;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case W: {
                this.persPass.switchWireframeMode();
                break;
            }
            case SPACE: {
                if (this.rotSphere.isAnimating()) {
                    this.rotSphere.stopAnimation();
                    break;
                }
                this.rotSphere.startAnimation(this.getGameTime(), this.getTimingMode());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.pickScheduler.pickNearest(this.pickGroup, e.getButton(), e.getX(), e.getY(), (NearestPickListener)this, (Object)"my user object");
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("Picked node \"" + nearest.getNode().getName() + "\" with \"" + userObject.toString() + "\" (picktime: " + pickTime + "ms)");
        if (nearest.getNode().getName() == "the rotating sphere") {
            this.rotSphere.switchColor();
        }
    }

    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("Picking missed (picktime: " + pickTime + "ms)");
    }

    public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (interval.getName().equals("yellow-painter")) {
            this.rotSphere.switchColor(Colorf.YELLOW);
        }
    }

    private void initFPSCounter(SceneGraph sg, Canvas3D canvas) {
        HUD hud = new HUD((Sized2iRO)canvas, 800.0f);
        FPSCounter fpsCounter = new FPSCounter(100.0f, 30.0f, "YellowBorder.png");
        fpsCounter.setFontColor(Colorf.WHITE);
        this.addFPSListener(fpsCounter);
        hud.getContentPane().addWidget(fpsCounter, hud.getResX() - fpsCounter.getWidth() - 15.0f, hud.getResY() - fpsCounter.getHeight() - 15.0f);
        DeviceComponent[] comps = new DeviceComponent[]{Keys.SPACE, Keys.W, MouseButtons.LEFT_BUTTON};
        String[] boundActions = new String[]{"Stop/start the rotation", "Switch to wireframe mode", "Change the light color (click on the sphere)"};
        TestUtils.displayInputBindings(comps, boundActions, hud);
        sg.addHUD(hud);
    }

    public RotatableGroupTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.pickScheduler = env.getPickScheduler();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("HUD");
        this.rotSphere = new RotatingSphere();
        BranchGroup persGroup = new BranchGroup();
        persGroup.addChild(this.rotSphere);
        this.persPass = env.addPerspectiveBranch(persGroup);
        this.persPass.getConfig().setRenderOptions(new RenderOptions());
        this.pickGroup = persGroup;
        this.getAnimator().addAnimatableObject(this.rotSphere);
        this.getOperationScheduler().addInterval(new Interval(5000000L, "yellow-painter"));
        this.getOperationScheduler().addIntervalListener(this);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.initFPSCounter(env, canvas);
    }

    public static void main(String[] args) throws Throwable {
        RotatableGroupTest test = new RotatableGroupTest(RotatableGroupTest.parseCommandLine(args));
        test.begin();
    }

    public class RotatingSphere
    extends RotatableGroup {
        private Colorf currentColor;
        private DirectionalLight light;

        public void switchColor(Colorf c) {
            this.currentColor = c;
            this.light.setColor(this.currentColor);
        }

        public void switchColor() {
            if (this.currentColor == null || this.currentColor.equals(Colorf.RED)) {
                this.switchColor(Colorf.GREEN);
            } else {
                this.switchColor(Colorf.RED);
            }
        }

        private void initSphere(float radius) {
            Sphere sph = new Sphere(radius, 32, 32, "deathstar.jpg");
            sph.setName("the rotating sphere");
            Material mat = new Material();
            mat.setEmissiveColor(Colorf.GRAY90);
            mat.setColorTarget(Material.NONE);
            mat.setLightingEnabled(true);
            sph.getAppearance().setMaterial(mat);
            this.light = new DirectionalLight(true, Colorf.YELLOW, new Vector3f(-1.0f, -1.0f, -1.0f));
            this.switchColor();
            this.addChild(sph);
            this.addChild(this.light);
        }

        public RotatingSphere() {
            super(new TransformationDirectives(0.3f, 0.2f, 0.0f, TransformationDirectives.AxisOrder.XYZ));
            this.currentColor = null;
            this.light = null;
            this.initSphere(2.0f);
        }
    }
}

