/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.coloring;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Background Color test."}, authors={"YVG"})
public class BackgroundColorTest
extends Xith3DTest {
    private Canvas3D canvas;
    private int color = 0;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.color = (this.color + 1) % 6;
                switch (this.color) {
                    case 0: {
                        this.canvas.setBackgroundColor(Colorf.RED);
                        break;
                    }
                    case 1: {
                        this.canvas.setBackgroundColor(Colorf.GREEN);
                        break;
                    }
                    case 2: {
                        this.canvas.setBackgroundColor(Colorf.BLUE);
                        break;
                    }
                    case 3: {
                        this.canvas.setBackgroundColor(Colorf.YELLOW);
                        break;
                    }
                    case 4: {
                        this.canvas.setBackgroundColor(Colorf.WHITE);
                        break;
                    }
                    case 5: {
                        this.canvas.setBackgroundColor(Colorf.BLACK);
                    }
                }
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) throws Exception {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        Rectangle rect = new Rectangle(1.7f, 1.3f, "wood.jpg");
        Appearance rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        scaleTransform.addChild(rect);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(TextureLoader.getInstance().getTexture("stone.jpg"));
        Cube cube = new Cube(1.0f, a);
        scaleTransform.addChild(cube);
        env.addPerspectiveBranch().getBranchGroup().addChild(testRotateYGroup);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
    }

    public BackgroundColorTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.canvas.setBackgroundColor(Colorf.RED);
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        DeviceComponent[] comps = new DeviceComponent[]{Keys.SPACE};
        String[] boundActions = new String[]{"Toggle the background color"};
        TestUtils.displayInputBindings((Sized2iRO)this.canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BackgroundColorTest test = new BackgroundColorTest(BackgroundColorTest.parseCommandLine(args));
        test.begin();
    }
}

