/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.coloring;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.primitives.Grid;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D test for vertex colors."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ColorTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env) throws Exception {
        int resX = 128;
        int resY = 128;
        Grid grid = new Grid(500.0f, 500.0f, 128, 128, 5, false, 2);
        Geometry geom = grid.getGeometry();
        Point3f coord = new Point3f();
        int n = geom.getVertexCount();
        for (int i = 0; i < n; ++i) {
            geom.getCoordinate(i, coord);
            geom.setColor(i, (coord.getX() + 250.0f) / 500.0f, (coord.getY() + 250.0f) / 500.0f, 0.0f);
        }
        StaticTransform.translate(grid, 400.0f, -300.0f, 0.0f);
        RenderPass renderPass = RenderPass.create2D(800, 600);
        renderPass.getBranchGroup().addChild(grid);
        env.addRenderPass(renderPass);
    }

    public ColorTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ColorTest test = new ColorTest(ColorTest.parseCommandLine(args));
        test.begin();
    }
}

