/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.display;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates, how you can switch the resolution", "and windowed/fullscreen."}, authors={"Marvin Froehlich (aka Qudus)"})
public class FullscreenSwitchTest
extends Xith3DTest {
    private final Canvas3D canvas;
    private boolean standaloneCapable;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F5: {
                this.canvas.setSize(640, 480);
                break;
            }
            case F6: {
                this.canvas.setSize(800, 600);
                break;
            }
            case F7: {
                this.canvas.setSize(1024, 768);
                break;
            }
            case F8: {
                this.canvas.setSize(1280, 1024);
                break;
            }
            case SPACE: {
                this.canvas.setFullscreen(!this.canvas.isFullscreen());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) throws Exception {
        BranchGroup scene = new BranchGroup();
        scene.addChild(new Rectangle(4.0f, 4.0f, "stone.jpg"));
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.5f));
        rg.setTranslation(0.0f, 0.0f, 1.0f);
        rg.addChild(new Rectangle(3.0f, 3.0f, "jplogo.png"));
        scene.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        env.addPerspectiveBranch(scene);
        HUD hud = new HUD(resolution, 800.0f);
        HUDFont font = HUDFont.getFont("Monospace", HUDFont.PLAIN, 18);
        Colorf color = Colorf.WHITE;
        Label lbl640 = new Label(200.0f, 30.0f, "F5: 640x480", font, color, TextAlignment.CENTER_CENTER);
        Label lbl800 = new Label(200.0f, 30.0f, "F6: 800x600", font, color, TextAlignment.CENTER_CENTER);
        Label lbl1024 = new Label(200.0f, 30.0f, "F7: 1024x768", font, color, TextAlignment.CENTER_CENTER);
        Label lbl1280 = new Label(200.0f, 30.0f, "F8: 1280x1024", font, color, TextAlignment.CENTER_CENTER);
        Label lblFullscreen = new Label(800.0f, 30.0f, "SPACE: Fullscreen/Windowed", font, Colorf.RED, TextAlignment.CENTER_CENTER);
        if (!this.standaloneCapable) {
            lblFullscreen.setFont(HUDFont.getFont("Monospace", HUDFont.PLAIN, 14));
            lblFullscreen.setText("Warning: Fullscreen not supported with standalone-incapable OpenGLLayer");
        }
        float yPos = 0.0f;
        hud.getContentPane().addWidget(lbl640, 0.0f, 0.0f);
        hud.getContentPane().addWidget(lbl800, 200.0f, 0.0f);
        hud.getContentPane().addWidget(lbl1024, 400.0f, 0.0f);
        hud.getContentPane().addWidget(lbl1280, 600.0f, 0.0f);
        hud.getContentPane().addWidget(lblFullscreen, 0.0f, 30.0f);
        TestUtils.displayInputBindings(null, null, hud);
        env.addHUD(hud);
    }

    public FullscreenSwitchTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.standaloneCapable = arguments.getCanvasConstructionInfo().getOpenGLLayer().isStandaloneCapable();
        this.createSceneGraph(env, arguments.getResolution());
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        FullscreenSwitchTest test = new FullscreenSwitchTest(FullscreenSwitchTest.parseCommandLine(args));
        test.begin();
    }
}

