/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.etc;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.preprocessing.sorting.FrontToBackRenderBinSorter2;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.DistanceInterpolater;

@Xith3DTest.Description(fulltext={"This class tests the transparency blending through the FrontToBackRenderBinSorter2 class."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BleedingBlendingTest
extends Xith3DTest {
    private TransformGroup translateY_TG;
    private final DistanceInterpolater inter = new DistanceInterpolater(1.5f, 0.0f, 3.5f, true);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene() {
        BranchGroup scRootBG = new BranchGroup();
        float ALPHA_GREEN = 0.7f;
        float ALPHA_BLUE = 0.7f;
        Rectangle planeBOTTOM_GREEN = new Rectangle(5.0f, 5.0f, new Colorf(0.0f, 1.0f, 0.0f, 0.7f));
        planeBOTTOM_GREEN.setBounds(new BoundingBox());
        StaticTransform.translate(planeBOTTOM_GREEN, 0.0f, 0.0f, -1.0f);
        Rectangle planeTOP_BLUE = new Rectangle(5.0f, 5.0f, new Colorf(0.0f, 0.0f, 1.0f, 0.7f));
        planeTOP_BLUE.setBounds(new BoundingBox());
        StaticTransform.translate(planeTOP_BLUE, 1.0f, 0.0f, 0.0f);
        this.translateY_TG = new TransformGroup();
        this.translateY_TG.addChild(planeTOP_BLUE);
        scRootBG.addChild(planeBOTTOM_GREEN);
        scRootBG.addChild(this.translateY_TG);
        return scRootBG;
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.inter.startIncreasing(this.getGameMicroTime());
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        float translateY = this.inter.getValue(micros);
        this.translateY_TG.getTransform().setTranslation(0.0f, translateY, 0.0f);
        this.translateY_TG.updateTransform();
    }

    public BleedingBlendingTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, -4.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, this);
        env.addPerspectiveBranch(this.createScene());
        env.getRenderer().setTransparentSorter(new FrontToBackRenderBinSorter2());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        TestUtils.displayInputBindings((Sized2iRO)canvas, null, (String[])null, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BleedingBlendingTest test = new BleedingBlendingTest(BleedingBlendingTest.parseCommandLine(args));
        test.begin();
    }
}

